/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.ui.AbstractBasicPainter;
import edu.geophys.commons.util.SwingUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class AbstractPainter<T>
extends AbstractBasicPainter<T> {
    private SwingUtil.RenderQuality renderQuality = SwingUtil.RenderQuality.VERY_LOW;
    private T model;

    public final Rectangle getPaintingArea(int n, int n2, int n3, int n4) {
        return super.getPaintingArea(n, n2, n3, n4, this.getModel());
    }

    public final T getModel() {
        return this.model;
    }

    public void setModel(T t) {
        this.model = t;
    }

    public final SwingUtil.RenderQuality getRenderQuality() {
        return this.renderQuality;
    }

    public void setRenderQuality(SwingUtil.RenderQuality renderQuality) {
        this.renderQuality = renderQuality;
    }

    public final void paint(Graphics2D graphics2D) {
        this.paint(graphics2D, graphics2D.getClipBounds().x, graphics2D.getClipBounds().y, graphics2D.getClipBounds().width, graphics2D.getClipBounds().height);
    }

    @Override
    public final void paint(Graphics2D graphics2D, Rectangle rectangle) {
        this.paint(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public final void paint(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        this.preparePaint(graphics2D, n, n2, n3, n4, this.getModel());
    }

    @Override
    protected void preparePaint(Graphics2D graphics2D, int n, int n2, int n3, int n4, T t) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n, n2, n3, n4);
        SwingUtil.setRenderingQuality(graphics2D2, this.getRenderQuality());
        this.doBasicPaint(graphics2D2, n3, n4, t);
        graphics2D2.dispose();
    }

    @Override
    protected final void doBasicPaint(Graphics2D graphics2D, int n, int n2, T t) {
        this.doPaint(graphics2D, n, n2);
    }

    protected abstract void doPaint(Graphics2D var1, int var2, int var3);
}

