/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.ui.AbstractConfiguration;
import edu.geophys.commons.util.LogUtil;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JFrame;

public class ScreenDimensionTool {
    private static ScreenDimensionTool instance = null;
    private final Rectangle areaUsable;
    private final boolean smallScreen;
    private final Rectangle seisServArea;
    private final Rectangle sonoViewArea;
    private final Rectangle traceViewArea;
    private final Rectangle eventListArea;
    private static final Dimension SEIS_SERV_MIN_SIZE = new Dimension(650, 400);
    private static final int SONO_VIEW_FULL_HD_WIDTH = 1440;
    private static final Dimension SMALL_SCREEN_LIMIT = new Dimension(1366, 768);
    private static final Dimension SCREEN_FULL_HD = new Dimension(1920, 1080);

    public static ScreenDimensionTool getInstance() {
        if (instance == null) {
            instance = new ScreenDimensionTool();
        }
        return instance;
    }

    private ScreenDimensionTool() {
        boolean bl;
        Rectangle rectangle;
        try {
            JFrame jFrame = new JFrame("");
            GraphicsConfiguration graphicsConfiguration = jFrame.getGraphicsConfiguration();
            Rectangle rectangle2 = graphicsConfiguration.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            rectangle = new Rectangle(rectangle2.x + insets.left, rectangle2.y + insets.top, Math.min(rectangle2.width - insets.left - insets.right, ScreenDimensionTool.SCREEN_FULL_HD.width - insets.left), rectangle2.height - insets.top - insets.bottom);
            bl = rectangle2.width <= ScreenDimensionTool.SMALL_SCREEN_LIMIT.width || rectangle2.height <= ScreenDimensionTool.SMALL_SCREEN_LIMIT.height;
        }
        catch (Exception exception) {
            int n = ScreenDimensionTool.SMALL_SCREEN_LIMIT.width;
            int n2 = ScreenDimensionTool.SMALL_SCREEN_LIMIT.height;
            LogUtil.error(this.getClass(), String.format("Could not determine screen size. Use default values for small screens (%d/%d).", n, n2));
            bl = true;
            rectangle = new Rectangle(0, 0, n, n2 - 32);
        }
        this.areaUsable = rectangle;
        this.smallScreen = bl;
        this.seisServArea = this.calcSeisServArea();
        this.sonoViewArea = this.calcSonoViewArea();
        this.traceViewArea = this.calcTraceViewArea();
        this.eventListArea = this.calcEventListArea();
    }

    private Rectangle calcSeisServArea() {
        return new Rectangle(this.areaUsable.x + this.areaUsable.width - ScreenDimensionTool.SEIS_SERV_MIN_SIZE.width, this.areaUsable.y, ScreenDimensionTool.SEIS_SERV_MIN_SIZE.width, ScreenDimensionTool.SEIS_SERV_MIN_SIZE.height);
    }

    private Rectangle calcSonoViewArea() {
        Rectangle rectangle = new Rectangle();
        rectangle.width = !this.smallScreen ? 1440 : this.areaUsable.width;
        rectangle.height = this.areaUsable.height;
        rectangle.x = this.areaUsable.x;
        rectangle.y = this.areaUsable.y;
        return rectangle;
    }

    private Rectangle calcTraceViewArea() {
        Rectangle rectangle = new Rectangle();
        rectangle.width = !this.smallScreen ? this.areaUsable.width - 1440 : 6 * this.areaUsable.width / 10;
        rectangle.height = this.areaUsable.height;
        rectangle.x = this.areaUsable.x + this.areaUsable.width - rectangle.width;
        rectangle.y = this.areaUsable.y;
        return rectangle;
    }

    private Rectangle calcEventListArea() {
        Rectangle rectangle = new Rectangle();
        rectangle.width = !this.smallScreen ? 864 : 6 * this.areaUsable.width / 10;
        rectangle.height = this.areaUsable.height - ScreenDimensionTool.SEIS_SERV_MIN_SIZE.height;
        rectangle.x = this.areaUsable.x + this.areaUsable.width - rectangle.width;
        rectangle.y = this.areaUsable.y + this.areaUsable.height - rectangle.height;
        return rectangle;
    }

    public boolean isSmallScreen() {
        return this.smallScreen;
    }

    private static AbstractConfiguration.FramePosition rectToFPosition(Rectangle rectangle) {
        return new AbstractConfiguration.FramePosition(rectangle.x, rectangle.y);
    }

    private static AbstractConfiguration.FrameSize rectToFSize(Rectangle rectangle) {
        return new AbstractConfiguration.FrameSize(rectangle.width, rectangle.height);
    }

    public AbstractConfiguration.FramePosition getSeisServPosition() {
        return ScreenDimensionTool.rectToFPosition(this.seisServArea);
    }

    public AbstractConfiguration.FramePosition getSonoViewPosition() {
        return ScreenDimensionTool.rectToFPosition(this.sonoViewArea);
    }

    public AbstractConfiguration.FramePosition getTraceViewPosition() {
        return ScreenDimensionTool.rectToFPosition(this.traceViewArea);
    }

    public AbstractConfiguration.FramePosition getEventListPosition() {
        return ScreenDimensionTool.rectToFPosition(this.eventListArea);
    }

    public AbstractConfiguration.FrameSize getSeisServSize() {
        return ScreenDimensionTool.rectToFSize(this.seisServArea);
    }

    public AbstractConfiguration.FrameSize getSonoViewSize() {
        return ScreenDimensionTool.rectToFSize(this.sonoViewArea);
    }

    public AbstractConfiguration.FrameSize getTraceViewSize() {
        return ScreenDimensionTool.rectToFSize(this.traceViewArea);
    }

    public AbstractConfiguration.FrameSize getEventListSize() {
        return ScreenDimensionTool.rectToFSize(this.eventListArea);
    }
}

