/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.ui.AbstractPaint;
import edu.geophys.commons.ui.trace.PlotRenderer;
import edu.geophys.commons.util.MathUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class SingleTracePaint
extends AbstractPaint {
    private static final long serialVersionUID = 1L;
    private final float[] dashs = null;
    protected BufferedImage buffer;
    private float[] values;
    private int[] markers;
    private PlotRenderer plot;
    private Color[] markerColors;
    private float scaleFactor;

    public PlotRenderer getPlot() {
        return this.plot;
    }

    public SingleTracePaint(float[] fArray, float f, boolean bl) {
        this.plot = new PlotRenderer(bl);
        this.setValues(fArray, f);
    }

    public SingleTracePaint(float[] fArray, float f) {
        this.plot = new PlotRenderer();
        this.setValues(fArray, f);
    }

    public SingleTracePaint(float[] fArray, float f, float f2) {
        this.scaleFactor = f / f2;
        this.plot = new PlotRenderer();
        this.setValues(fArray, f);
    }

    public SingleTracePaint(float[] fArray, boolean bl, boolean bl2) {
        this.plot = new PlotRenderer(bl, bl2);
        this.setValues(fArray, MathUtil.calcAbsMaximum(fArray));
    }

    public SingleTracePaint(float[] fArray) {
        this.plot = new PlotRenderer();
        this.setValues(fArray, MathUtil.calcAbsMaximum(fArray));
    }

    public SingleTracePaint(float[] fArray, int[] nArray) {
        this(fArray);
        this.markers = nArray;
    }

    public SingleTracePaint(float[] fArray, float f, boolean bl, int[] nArray) {
        this(fArray, f, bl);
        this.markers = nArray;
    }

    public SingleTracePaint(float[] fArray, boolean bl, boolean bl2, int[] nArray) {
        this(fArray, bl, bl2);
        this.markers = nArray;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n = 0;
        if (this.scaleFactor > 0.0f) {
            n = (int)((float)this.getHeight() * 0.5f * this.scaleFactor - (float)this.getHeight() * 0.5f);
        }
        this.plot.draw(graphics2D, new Rectangle2D.Double(this.getBorder().getBorderInsets((Component)this).left, this.getBorder().getBorderInsets((Component)this).top - n, this.getWidth() - this.getBorder().getBorderInsets((Component)this).left - this.getBorder().getBorderInsets((Component)this).right, this.getHeight() - this.getBorder().getBorderInsets((Component)this).top - this.getBorder().getBorderInsets((Component)this).bottom + 2 * n));
        if (this.markers != null) {
            for (int i = 0; i < this.markers.length; ++i) {
                if (this.markerColors == null) {
                    graphics2D.setColor(Color.RED);
                } else if (this.markerColors.length == this.markers.length) {
                    graphics2D.setColor(this.markerColors[i]);
                    graphics2D.setStroke(new BasicStroke(2.0f, 0, 0, 1.0f, this.dashs, 0.0f));
                }
                int n2 = (int)MathUtil.convertFromTo(this.markers[i], 0.0, this.values.length, this.getBorder().getBorderInsets((Component)this).left, this.getWidth());
                graphics2D.drawLine(n2, 0, n2, this.getHeight());
            }
        }
        graphics2D.dispose();
    }

    public void setValues(float[] fArray, float f) {
        this.values = fArray;
        this.plot.setValues(fArray);
        this.plot.setExternalScale(1.0f / f);
        this.repaint();
    }

    public Color[] getMarkerColors() {
        return this.markerColors;
    }

    public void setMarkerColors(Color[] colorArray) {
        this.markerColors = colorArray;
    }

    public int[] getMarkers() {
        return this.markers;
    }

    public void setMarkers(int[] nArray) {
        this.markers = nArray;
    }

    public float[] getValues() {
        return this.values;
    }

    public void setValues(float[] fArray) {
        this.values = fArray;
    }
}

