/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.suite.TraceProvider;
import edu.geophys.commons.ui.SimpleTraceBorder;
import edu.geophys.commons.ui.trace.PlotRenderer;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;

public class SpectrumTracePaint
extends JComponent {
    private static final long serialVersionUID = 1L;
    private float[] values;
    private PlotRenderer plot;
    private boolean logAmp = true;
    private boolean logFreq = true;
    private String traceName;
    private SimpleTraceBorder tb1;
    private double i95;

    public SpectrumTracePaint(float[] fArray, float f, boolean bl) {
        this.plot = new PlotRenderer(bl);
        this.setValues(fArray, f);
    }

    public SpectrumTracePaint(float[] fArray, float f) {
        this.plot = new PlotRenderer();
        this.setValues(fArray, f);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.plot.setForegroundColor(Color.BLACK);
        if (this.getBorder() != null) {
            this.plot.draw(graphics2D, new Rectangle2D.Double(this.getBorder().getBorderInsets((Component)this).left, this.getBorder().getBorderInsets((Component)this).top, this.getWidth() - this.getBorder().getBorderInsets((Component)this).left - this.getBorder().getBorderInsets((Component)this).right, this.getHeight() - this.getBorder().getBorderInsets((Component)this).top - this.getBorder().getBorderInsets((Component)this).bottom));
        } else {
            this.plot.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        }
        graphics2D.dispose();
    }

    public void setValues(float[] fArray, float f) {
        this.values = fArray;
        this.plot.setValues(fArray);
        this.plot.setExternalScale(1.0f / f);
        this.repaint();
    }

    public float[] getValues() {
        return this.values;
    }

    public PlotRenderer getPlot() {
        return this.plot;
    }

    public void setPlot(PlotRenderer plotRenderer) {
        this.plot = plotRenderer;
    }

    public void calcSpectrum(double d, double d2, SpecModeEnum specModeEnum) {
        this.calcSpectrum(d, d2, specModeEnum, true, false);
    }

    public void calcSpectrum(double d, double d2, SpecModeEnum specModeEnum, boolean bl, boolean bl2) {
        Mean mean;
        Object object;
        int n;
        long l;
        int n2;
        int n3;
        TraceProvider traceProvider = SuiteManager.INSTANCE.getTraceProvider();
        float f = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
        long l2 = (long)((d2 - d) * (double)f);
        if (l2 > (long)(n3 = (int)(600.0f * f))) {
            n2 = n3;
            l = n2 / 2;
            n = (int)Math.ceil((double)(l2 + l) / (double)n2);
        } else {
            n2 = (int)l2;
            l = 0L;
            n = 1;
        }
        int n4 = MathUtil.getNextPowerOfTwo(n2);
        FastFourierTransformer fastFourierTransformer = new FastFourierTransformer(DftNormalization.STANDARD);
        double[] dArray = null;
        if (bl2) {
            dArray = new double[n * n2];
        }
        double[][] dArray2 = new double[n4 / 2][n];
        for (int i = 0; i < n; ++i) {
            double d3 = d + (double)i * ((double)n2 / (double)f);
            if (i != 0) {
                d3 -= (double)l / (double)f;
            }
            int n5 = n2;
            if (i == n - 1) {
                n5 = (int)((d2 - d3) * (double)f);
            }
            LogUtil.debug(this.getClass(), "Calculating spectrum of trace " + this.traceName + " from " + DateTimeUtil.formatDateTimeISO(d3) + " until " + DateTimeUtil.formatDateTimeISO(d3 + (double)n5 / (double)f));
            object = traceProvider.requestTrace(d3, n5, f, this.traceName)[0].getSamples();
            object = MathUtil.subMeanZeroNaN((float[])object);
            if (bl2) {
                for (int j = 0; j < ((Object)object).length; ++j) {
                    dArray[i * n2 + j] = Math.abs((float)object[j]);
                }
            }
            object = MathUtil.derivative((float[])object, 1.0f / f);
            MathUtil.hannWindow((float[])object, 0, ((Object)object).length);
            double[] dArray3 = new double[n4];
            for (int j = 0; j < n5; ++j) {
                if (Float.isNaN((float)object[j])) continue;
                dArray3[j] = (double)object[j];
            }
            Complex[] complexArray = fastFourierTransformer.transform(dArray3, TransformType.FORWARD);
            for (int j = 0; j < n4 / 2; ++j) {
                dArray2[j][i] = complexArray[j].abs() / Math.sqrt(n4 / 2) * 1.0E-9;
            }
        }
        float[] fArray = new float[n4 / 2];
        if (!specModeEnum.equals((Object)SpecModeEnum.Mean)) {
            switch (specModeEnum) {
                case Percentile25: {
                    mean = new Percentile(25.0);
                    break;
                }
                case Percentile75: {
                    mean = new Percentile(75.0);
                    break;
                }
                default: {
                    mean = new Percentile(50.0);
                }
            }
            for (var23_38 = 0; var23_38 < fArray.length; ++var23_38) {
                fArray[var23_38] = (float)mean.evaluate(dArray2[var23_38]);
            }
        } else {
            mean = new Mean();
            for (var23_38 = 0; var23_38 < fArray.length; ++var23_38) {
                fArray[var23_38] = (float)mean.evaluate(dArray2[var23_38]);
            }
        }
        if (bl2) {
            mean = new Percentile(95.0);
            this.i95 = mean.evaluate(dArray);
        }
        float f2 = MathUtil.calcAbsMaximum(fArray);
        float f3 = MathUtil.calcMinimum(fArray);
        float f4 = (float)Math.log10(f3);
        object = "[(nm/s^2)^2/Hz]";
        this.setPlot(new PlotRenderer(true));
        if (this.logAmp) {
            int n6;
            for (n6 = 0; n6 < fArray.length; ++n6) {
                fArray[n6] = (float)Math.log10(fArray[n6]) - f4;
            }
            n6 = 0;
            while (Math.pow(10.0, n6) < (double)f2) {
                ++n6;
            }
            float f5 = (float)Math.ceil(Math.log10(f2));
            float f6 = (float)Math.floor(f4);
            f2 = f5 - f6;
        }
        int n7 = 0;
        int n8 = 0;
        if (this.logFreq) {
            double d4 = (double)f / 2.0;
            float[] fArray2 = new float[fArray.length];
            int n9 = fArray.length;
            while (Math.pow(10.0, n8) < d4) {
                ++n8;
            }
            double d5 = 1.0 / (double)n9 * d4;
            while (Math.pow(10.0, n7) > d5) {
                --n7;
            }
            fArray2[0] = 0.0f;
            int n10 = 0;
            float f7 = Float.NaN;
            for (int i = 1; i < n9; ++i) {
                double d6 = (double)i / (double)n9 * d4;
                double d7 = Math.log10(d6);
                if (!(d7 > (double)n7)) continue;
                int n11 = (int)MathUtil.convertFromTo(d7, n7, n8, 1.0, n9);
                float f8 = fArray[i];
                if (i > 1 && !Float.isNaN(f7)) {
                    float f9 = f8 - f7;
                    int n12 = n11 - n10;
                    for (int j = n10 + 1; j < n11; ++j) {
                        fArray2[j] = f7 + f9 * (float)(j - n10) / (float)n12;
                    }
                }
                fArray2[n11] = f8;
                f7 = f8;
                n10 = n11;
            }
            fArray = fArray2;
        }
        this.setValues(fArray, f2);
        if (bl) {
            float f10 = 0.0f;
            float f11 = f / 2.0f;
            if (this.logFreq) {
                f10 = n7;
                f11 = n8;
            }
            this.tb1 = new SimpleTraceBorder(Color.BLACK, 60, 40, 1.0 / (this.logAmp ? Math.pow(10.0, f2 + f4) : (double)f2), "[Hz]", (String)object, f10, f11, true, this.logAmp, this.logFreq, f3);
            this.setBorder(this.tb1);
            this.repaint();
        }
    }

    public boolean isLogAmp() {
        return this.logAmp;
    }

    public void setLogAmp(boolean bl) {
        this.logAmp = bl;
    }

    public String getTraceName() {
        return this.traceName;
    }

    public void setTraceName(String string) {
        this.traceName = string;
    }

    public boolean isLogFreq() {
        return this.logFreq;
    }

    public void setLogFreq(boolean bl) {
        this.logFreq = bl;
    }

    public SimpleTraceBorder getTb1() {
        return this.tb1;
    }

    public void setTb1(SimpleTraceBorder simpleTraceBorder) {
        this.tb1 = simpleTraceBorder;
    }

    public double getI95() {
        return this.i95;
    }

    public void setI95(double d) {
        this.i95 = d;
    }

    public static enum SpecModeEnum {
        Mean,
        Median,
        Percentile25,
        Percentile75;

    }
}

