/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.map;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.resources.Colors;
import edu.geophys.commons.suite.EventWindowModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.suite.TraceProvider;
import edu.geophys.commons.util.LocalMagnitude;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import layout.TableLayout;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class DetectionThresholdCalculation {
    private double snr = 2.0;
    private int nrOfDetections = 8;
    double start;
    double end;

    public DetectionThresholdCalculation(JFrame jFrame) {
        TableLayout tableLayout = new TableLayout();
        JPanel jPanel = new JPanel((LayoutManager)tableLayout);
        tableLayout.insertColumn(0, -3.0);
        tableLayout.insertColumn(1, 150.0);
        int n = 0;
        JLabel jLabel = new JLabel("no. of detections:");
        jLabel.setToolTipText("Single stations which need to fulfill the criteria.");
        JSpinner jSpinner = new JSpinner();
        jSpinner.setModel(new SpinnerNumberModel((Number)this.nrOfDetections, Integer.valueOf(1), null, (Number)1));
        tableLayout.insertRow(n, -3.0);
        jPanel.add((Component)jLabel, "0, " + n);
        jPanel.add((Component)jSpinner, "1, " + n);
        JLabel jLabel2 = new JLabel("minimum snr:");
        jLabel2.setToolTipText("<html>A detection of a certain local magnitude ML is possible if:<br>\"no. of detections\" single stations have a I95 value which is smaller or the same <br>to the simulated amplitude in the specific distance divided by the value of \"minimum snr\"<html>");
        JSpinner jSpinner2 = new JSpinner();
        jSpinner2.setModel(new SpinnerNumberModel((Number)this.snr, Double.valueOf(Double.MIN_VALUE), null, (Number)1.0));
        tableLayout.insertRow(++n, -3.0);
        jPanel.add((Component)jLabel2, "0, " + n);
        jPanel.add((Component)jSpinner2, "1, " + n);
        ++n;
        Calendar calendar = Calendar.getInstance();
        EventWindowModel eventWindowModel = SuiteManager.INSTANCE.getGlobalEventWindowModel();
        JLabel jLabel3 = new JLabel("Start time:");
        SpinnerDateModel spinnerDateModel = new SpinnerDateModel();
        JSpinner jSpinner3 = new JSpinner(spinnerDateModel);
        SimpleDateFormat simpleDateFormat = ((JSpinner.DateEditor)jSpinner3.getEditor()).getFormat();
        simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss");
        calendar.setTimeInMillis(eventWindowModel.getStartEpochTimeMs());
        jSpinner3.setValue(calendar.getTime());
        tableLayout.insertRow(n, -3.0);
        jPanel.add((Component)jLabel3, "0, " + n);
        jPanel.add((Component)jSpinner3, "1, " + n);
        ++n;
        JLabel jLabel4 = new JLabel("End time:");
        SpinnerDateModel spinnerDateModel2 = new SpinnerDateModel();
        JSpinner jSpinner4 = new JSpinner(spinnerDateModel2);
        SimpleDateFormat simpleDateFormat2 = ((JSpinner.DateEditor)jSpinner4.getEditor()).getFormat();
        simpleDateFormat2.applyPattern("yyyy-MM-dd HH:mm:ss");
        calendar.setTimeInMillis(eventWindowModel.getStartEpochTimeMs() + eventWindowModel.getLength());
        jSpinner4.setValue(calendar.getTime());
        tableLayout.insertRow(n, -3.0);
        jPanel.add((Component)jLabel4, "0, " + n);
        jPanel.add((Component)jSpinner4, "1, " + n);
        ++n;
        JOptionPane.showConfirmDialog(jFrame, jPanel, "Select detection threshold parameters", -1, -1, null);
        this.start = (double)((Date)jSpinner3.getValue()).getTime() / 1000.0;
        this.end = (double)((Date)jSpinner4.getValue()).getTime() / 1000.0;
        this.snr = (Double)jSpinner2.getValue();
        this.nrOfDetections = (Integer)jSpinner.getValue();
    }

    public BufferedImage calcDetectionThresholdImage(int n, int n2, double d, double d2, double d3) {
        int n3;
        double d4;
        double d5;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        TraceProvider traceProvider = SuiteManager.INSTANCE.getTraceProvider();
        SNS[] sNSArray = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        float f = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();
        Percentile percentile = new Percentile(95.0);
        for (SNS object5 : sNSArray) {
            Site site = object5.getCenter();
            DefaultTrace n4 = traceProvider.requestTrace(this.start, this.end, f, site.getTraceZ())[0];
            float[] n32 = MathUtil.subMeanZeroNaN(n4.getSamples());
            double i = percentile.evaluate(MathUtil.floatArrayToDoubleArray(n32));
            double string2 = 1.0;
            if (site.getTraceEW() != null && !site.getTraceEW().isEmpty() && site.getTraceNS() != null && !site.getTraceNS().isEmpty()) {
                DefaultTrace[] defaultTraceArray = traceProvider.requestTrace(this.start, this.end, f, site.getTraceEW(), site.getTraceNS());
                LocalMagnitude localMagnitude = new LocalMagnitude(defaultTraceArray[0].getSamples(), defaultTraceArray[0].getSamplerate(), 0.0f);
                localMagnitude.woodAnderson();
                double d6 = percentile.evaluate(MathUtil.floatArrayToDoubleArray(localMagnitude.getWaSamples()));
                LocalMagnitude localMagnitude2 = new LocalMagnitude(defaultTraceArray[0].getSamples(), defaultTraceArray[0].getSamplerate(), 0.0f);
                localMagnitude2.woodAnderson();
                d5 = percentile.evaluate(MathUtil.floatArrayToDoubleArray(localMagnitude2.getWaSamples()));
                d4 = (d6 + d5) / 2.0;
                string2 = d4 / i;
            } else {
                LogUtil.error(this.getClass(), "Could not calculate ratio between horizontal and vertical traces because center station is without 3 components, using ratio 1.");
            }
            arrayList.add(i * string2);
            arrayList2.add(site.getXOffsetKm());
            arrayList3.add(site.getYOffsetKm());
            for (Site site2 : object5.getAllSatellites()) {
                if (site2 == null) continue;
                DefaultTrace defaultTrace = traceProvider.requestTrace(this.start, this.end, f, site2.getTraceZ())[0];
                float[] fArray = MathUtil.subMeanZeroNaN(defaultTrace.getSamples());
                arrayList.add(percentile.evaluate(MathUtil.floatArrayToDoubleArray(fArray)) * string2);
                arrayList2.add(site2.getXOffsetKm());
                arrayList3.add(site2.getYOffsetKm());
            }
        }
        double[][] dArray = new double[n][n2];
        double d7 = -1.7976931348623157E308;
        double d8 = Double.MAX_VALUE;
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                double d9 = ((double)(n2 - i) - d3) / d;
                double d10 = ((double)n3 - d2) / d;
                ArrayList<Float> arrayList4 = new ArrayList<Float>();
                for (int j = 0; j < arrayList.size(); ++j) {
                    double d11 = Math.abs((Double)arrayList2.get(j) - d10);
                    d5 = Math.abs((Double)arrayList3.get(j) - d9);
                    d4 = Math.sqrt(d11 * d11 + d5 * d5);
                    double d12 = this.snr * (Double)arrayList.get(j) / 1000.0;
                    if (!(d12 > Double.MIN_VALUE)) continue;
                    if (d4 < 3.0) {
                        arrayList4.add(Float.valueOf((float)(Math.log10(d12) + 1.0 * Math.log10(d4) + 0.7)));
                        continue;
                    }
                    if (d4 < 100.0) {
                        arrayList4.add(Float.valueOf((float)(Math.log10(d12) + 1.5 * Math.log10(d4) + 0.45)));
                        continue;
                    }
                    arrayList4.add(Float.valueOf((float)(Math.log10(d12) + 2.56 * Math.log10(d4) - 1.67)));
                }
                Collections.sort(arrayList4);
                if (this.nrOfDetections <= arrayList4.size()) {
                    dArray[n3][i] = ((Float)arrayList4.get(this.nrOfDetections - 1)).floatValue();
                    if (dArray[n3][i] > d7) {
                        d7 = dArray[n3][i];
                    }
                    if (!(dArray[n3][i] < d8)) continue;
                    d8 = dArray[n3][i];
                    continue;
                }
                dArray[n3][i] = Double.NaN;
                ++n4;
            }
        }
        if (n4 > 0) {
            LogUtil.warn(this.getClass(), "Detection threshold map contains " + n4 + " invalid points.");
        }
        n3 = Colors.SONOGRAM.length;
        for (int string = 0; string < n; ++string) {
            for (int i = 0; i < n2; ++i) {
                if (!Double.isNaN(dArray[string][i])) {
                    dArray[string][i] = MathUtil.convertFromTo(dArray[string][i], d8, d7, 0.0, n3 - 1);
                }
                if (!Double.isNaN(dArray[string][i])) {
                    graphics2D.setColor(Colors.SONOGRAM[n3 - 1 - (int)dArray[string][i]]);
                } else {
                    graphics2D.setColor(Color.WHITE);
                }
                graphics2D.fillRect(string, i, 1, 1);
            }
        }
        graphics2D.setColor(Color.RED);
        String string = "Worst ML:" + MathUtil.format2Digits(d7);
        Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
        graphics2D.drawString(string, (int)((double)n - rectangle2D.getWidth() - 10.0), 50);
        String string2 = "Best ML:" + MathUtil.format2Digits(d8);
        Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string2, graphics2D);
        graphics2D.drawString(string2, (int)((double)n - rectangle2D2.getWidth() - 10.0), (int)(50.0 - rectangle2D.getHeight()));
        return bufferedImage;
    }
}

