/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.range;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.range.AbstractRangeSelection;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.SwingUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

public class JFreeRangeSelection
extends AbstractRangeSelection {
    public JFreeRangeSelection() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BoundedLongRangeModel boundedLongRangeModel = JFreeRangeSelection.this.getModel();
                long l = boundedLongRangeModel.getValue();
                long l2 = l + boundedLongRangeModel.getExtent();
                Rectangle2D rectangle2D = SwingUtil.componentDrawingArea(JFreeRangeSelection.this);
                double d = JFreeRangeSelection.this.getMousePosition().getX();
                long l3 = (long)MathUtil.convertFromTo(d, rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth(), boundedLongRangeModel.getMinimum(), boundedLongRangeModel.getMaximum());
                if (mouseEvent.getButton() == 1) {
                    if ((l3 = MathUtil.floor(l3, boundedLongRangeModel.getIncrement())) >= l2) {
                        boundedLongRangeModel.setValue(l3);
                    } else {
                        boundedLongRangeModel.setRangeProperties(l3, l2 - l3, boundedLongRangeModel.getMinimum(), boundedLongRangeModel.getMaximum(), boundedLongRangeModel.getIncrement(), boundedLongRangeModel.getValueIsAdjusting());
                    }
                } else if (mouseEvent.getButton() == 3) {
                    if ((l3 = MathUtil.ceil(l3, boundedLongRangeModel.getIncrement())) <= l) {
                        boundedLongRangeModel.setValue(l3);
                    } else {
                        boundedLongRangeModel.setExtent(l3 - l);
                    }
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }
}

