/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.range;

import edu.geophys.commons.detection.AbstractDetection;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.range.AbstractRangeSelection;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.commons.util.SwingUtil;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;

public class TimeAxisEventMarkers
extends AbstractRangeSelection {
    private static final long serialVersionUID = 3622854106357530217L;
    private boolean showEventMarkers = false;
    private BoundedRangeModel scrollBarModel = null;

    public TimeAxisEventMarkers() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BoundedLongRangeModel boundedLongRangeModel = TimeAxisEventMarkers.this.getModel();
                Rectangle2D rectangle2D = SwingUtil.componentDrawingArea(TimeAxisEventMarkers.this);
                double d = TimeAxisEventMarkers.this.getMousePosition().getX();
                long l = (long)MathUtil.convertFromTo(d, rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth(), boundedLongRangeModel.getMinimum(), boundedLongRangeModel.getMaximum());
                if (mouseEvent.getButton() == 1) {
                    boundedLongRangeModel.setValue(MathUtil.floor(l, boundedLongRangeModel.getIncrement()));
                } else if (mouseEvent.getButton() == 3) {
                    boundedLongRangeModel.setValue(MathUtil.ceil(l, boundedLongRangeModel.getIncrement()) - boundedLongRangeModel.getExtent());
                }
            }
        });
        SuiteManager.INSTANCE.getGlobalEventWindowModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("eventMarkers")) {
                    TimeAxisEventMarkers.this.repaint();
                } else if (propertyChangeEvent.getPropertyName().equals("scrollbarPosition")) {
                    TimeAxisEventMarkers.this.scrollBarModel = (BoundedRangeModel)propertyChangeEvent.getNewValue();
                    TimeAxisEventMarkers.this.repaint();
                }
            }
        });
    }

    protected final int getBound(Rectangle2D rectangle2D, long l) {
        return (int)MathUtil.convertFromTo(l, this.getModel().getMinimum(), this.getModel().getMaximum(), rectangle2D.getX(), rectangle2D.getX() + rectangle2D.getWidth());
    }

    @Override
    protected void drawSelectionMarker(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        int n;
        int n2 = this.getBound(rectangle2D, this.getModel().getValue());
        int n3 = this.getBound(rectangle2D, this.getModel().getValue() + this.getModel().getExtent()) - n2 - 1;
        if (n3 < 1) {
            n3 = 1;
        }
        graphics2D.setColor(this.getSelectionBackground());
        graphics2D.fillRect(n2, (int)rectangle2D.getY(), n3, (int)rectangle2D.getHeight() - 1);
        if (this.scrollBarModel != null && (n = this.scrollBarModel.getMaximum() - this.scrollBarModel.getMinimum()) > 0) {
            int n4 = n2 + (int)((float)n3 * (float)this.scrollBarModel.getValue() / (float)n);
            int n5 = 1 + (int)((float)n3 * (float)this.scrollBarModel.getExtent() / (float)n);
            if (n5 < 1) {
                n5 = 1;
            }
            graphics2D.setColor(this.getInnerSelectionBackground());
            graphics2D.fillRect(n4, (int)rectangle2D.getY(), n5, (int)rectangle2D.getHeight() - 1);
        }
        graphics2D.setColor(this.getSelectionForeground());
        graphics2D.drawRect(n2, (int)rectangle2D.getY(), n3, (int)rectangle2D.getHeight() - 1);
        n = (int)(rectangle2D.getWidth() / 100.0);
        graphics2D.drawLine(n2 - n + n3 / 2, (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0), n2 + n + n3 / 2, (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0));
        if (this.isShowEventMarkers()) {
            for (AbstractDetection abstractDetection : SuiteManager.INSTANCE.getEventFileManager().getAllDetectionEntries()) {
                n2 = this.getBound(rectangle2D, abstractDetection.getIndexTimeMs());
                n3 = this.getBound(rectangle2D, abstractDetection.getEndTimeMs()) - n2 - 1;
                if (n3 < 1) {
                    n3 = 1;
                }
                graphics2D.setColor(abstractDetection.getColor());
                graphics2D.fillRect(n2, (int)rectangle2D.getY(), n3, (int)rectangle2D.getHeight() - 1);
            }
        }
    }

    public boolean isShowEventMarkers() {
        return this.showEventMarkers;
    }

    public void setShowEventMarkers(boolean bl) {
        this.showEventMarkers = bl;
    }
}

