/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.range;

import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.MathUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Calendar;
import javax.swing.JComponent;

public class TimeAxisPainter
extends JComponent {
    private int fontSize = 0;
    private final TimeAxisPainterModel _bufferModel = new TimeAxisPainterModel();
    private Color _foreground = Color.BLACK;
    private TimeAxisPainterModel model;

    public TimeAxisPainter(TimeAxisPainterModel timeAxisPainterModel) {
        this.model = timeAxisPainterModel;
    }

    public final Color getForegroundColor() {
        return this._foreground;
    }

    @Override
    public final void setForeground(Color color) {
        this._foreground = color;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.paint((Graphics2D)graphics.create(), this.getWidth(), this.getHeight());
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        if (this.fontSize != 0) {
            graphics2D.setFont(new Font("Arial", 0, this.fontSize));
        }
        int n3 = graphics2D.getFontMetrics().getHeight();
        int n4 = (int)Math.floor((double)n3 * 0.3333333333333333);
        int n5 = (int)Math.floor((double)n3 * 0.8333333333333334);
        String string = "";
        this._bufferModel.epochStart = this.model.epochStart;
        this._bufferModel.epochEnd = this.model.epochEnd;
        graphics2D.setColor(this._foreground);
        int n6 = (int)DateTimeUtil.incrementS(100.0 * ((this._bufferModel.epochEnd - this._bufferModel.epochStart) / (double)(n - 1)));
        int n7 = n6 / 2;
        if (n7 < 1) {
            n7 = 1;
        }
        int n8 = (int)Math.rint(MathUtil.ceil(this._bufferModel.epochStart, (double)n7));
        while ((double)n8 <= this._bufferModel.epochEnd) {
            int n9 = (int)Math.rint(MathUtil.convertFromTo(n8, this._bufferModel.epochStart, this._bufferModel.epochEnd, 0.0, n - 1));
            if (n8 == n8 / n6 * n6) {
                graphics2D.drawLine(n9, 0, n9, n5);
                if (n8 == n8 / n6 / 2 * n6 * 2) {
                    DateTimeUtil.epochToCalendar(n8, calendar);
                    string = calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 ? DateTimeUtil.formatDateISO(calendar) : DateTimeUtil.formatTime(calendar);
                    graphics2D.drawString(string, n9 + 3, n3);
                }
            } else {
                graphics2D.drawLine(n9, 0, n9, n4);
            }
            n8 += n7;
        }
        graphics2D.drawLine(0, 0, n - 1, 0);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        this.fontSize = n;
    }

    public static class TimeAxisPainterModel {
        double epochStart;
        double epochEnd;

        public final void setEpochEnd(double d) {
            this.epochEnd = d;
        }

        public final void setEpochStart(double d) {
            this.epochStart = d;
        }

        public boolean equals(TimeAxisPainterModel timeAxisPainterModel) {
            return Math.abs(this.epochStart - timeAxisPainterModel.epochStart) < 0.001 && Math.abs(this.epochEnd - timeAxisPainterModel.epochEnd) < 0.001;
        }
    }
}

