/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.sonogram;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.ui.sonogram.ArraySonogramModel;
import edu.geophys.commons.ui.sonogram.SonogramModel;

public class DefaultArraySonogramModel
implements ArraySonogramModel {
    private SonogramModel westModel = null;
    private SonogramModel northModel = null;
    private SonogramModel centerModel = null;
    private SonogramModel eastModel = null;
    private SonogramModel referenceModel = null;
    private SNS array = null;

    private void selectReferenceModel() {
        this.referenceModel = this.centerModel;
        if (this.referenceModel == null) {
            this.referenceModel = this.northModel;
        }
        if (this.referenceModel == null) {
            this.referenceModel = this.westModel;
        }
        if (this.referenceModel == null) {
            this.referenceModel = this.eastModel;
        }
    }

    @Override
    public SNS getArray() {
        return this.array;
    }

    @Override
    public void setArray(SNS sNS) {
        this.array = sNS;
    }

    @Override
    public final boolean isHealthy() {
        return this.centerModel != null && this.centerModel.isHealthy() || this.northModel != null && this.northModel.isHealthy() || this.eastModel != null && this.eastModel.isHealthy() || this.westModel != null && this.westModel.isHealthy();
    }

    @Override
    public final SonogramModel getWest() {
        return this.westModel;
    }

    @Override
    public final boolean setWest(SonogramModel sonogramModel) {
        return this.setComponents(sonogramModel, this.northModel, this.centerModel, this.eastModel);
    }

    @Override
    public final SonogramModel getNorth() {
        return this.northModel;
    }

    @Override
    public final boolean setNorth(SonogramModel sonogramModel) {
        return this.setComponents(this.westModel, sonogramModel, this.centerModel, this.eastModel);
    }

    @Override
    public final SonogramModel getCenter() {
        return this.centerModel;
    }

    @Override
    public final boolean setCenter(SonogramModel sonogramModel) {
        return this.setComponents(this.westModel, this.northModel, sonogramModel, this.eastModel);
    }

    @Override
    public final SonogramModel getEast() {
        return this.eastModel;
    }

    @Override
    public final boolean setEast(SonogramModel sonogramModel) {
        return this.setComponents(this.westModel, this.northModel, this.centerModel, sonogramModel);
    }

    @Override
    public boolean setComponents(SonogramModel sonogramModel, SonogramModel sonogramModel2, SonogramModel sonogramModel3, SonogramModel sonogramModel4) {
        this.westModel = sonogramModel;
        this.northModel = sonogramModel2;
        this.centerModel = sonogramModel3;
        this.eastModel = sonogramModel4;
        this.selectReferenceModel();
        return true;
    }

    @Override
    public double getEndEpochTime() {
        return this.referenceModel.getEndEpochTime();
    }

    @Override
    public int getFrequencyWidth() {
        return this.referenceModel.getFrequencyWidth();
    }

    @Override
    public double getStartEpochTime() {
        return this.referenceModel.getStartEpochTime();
    }

    @Override
    public String getStationID() {
        return this.referenceModel.getStationID();
    }

    @Override
    public int getTimeWidth() {
        return this.referenceModel.getTimeWidth();
    }

    @Override
    public int getValue(int n, int n2) {
        return this.referenceModel.getValue(n, n2);
    }

    @Override
    public double getEpochTimeIncrement() {
        return this.referenceModel.getEpochTimeIncrement();
    }

    @Override
    public int[][] getRawSonogram() {
        if (this.centerModel != null && this.northModel != null && this.eastModel != null && this.westModel != null) {
            int[][] nArray = new int[2 * this.getFrequencyWidth()][2 * this.getTimeWidth()];
            int n = 0;
            int n2 = 0;
            while (n < this.getFrequencyWidth()) {
                int n3 = 0;
                int n4 = 0;
                while (n3 < this.getTimeWidth()) {
                    nArray[n2][n4] = this.getWest().getValue(n3, n);
                    nArray[n2][n4 + 1] = this.getNorth().getValue(n3, n);
                    nArray[n2 + 1][n4] = this.getCenter().getValue(n3, n);
                    nArray[n2 + 1][n4 + 1] = this.getEast().getValue(n3, n);
                    ++n3;
                    n4 += 2;
                }
                ++n;
                n2 += 2;
            }
            return nArray;
        }
        return new int[10][10];
    }

    @Override
    public int[] getNpsdf() {
        return this.referenceModel.getNpsdf();
    }

    @Override
    public int[] getNsigf() {
        return this.referenceModel.getNsigf();
    }

    @Override
    public int[] getNdmaxf() {
        return this.referenceModel.getNdmaxf();
    }

    @Override
    public int[] getNdminf() {
        return this.referenceModel.getNdminf();
    }
}

