/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.sonogram;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.sonogram.AbstractSonogramComponent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class PatternMarkerRenderer {
    private static final AlphaComposite SELECTION_COMPOSITE = AlphaComposite.getInstance(3, 0.6f);
    private AbstractSonogramComponent parent = null;
    private BoundedLongRangeModel selection = null;
    private Color color = null;

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(SELECTION_COMPOSITE);
        graphics2D.setColor(this.parent.getSelectionColor());
        Rectangle2D rectangle2D = this.parent.getAreaInSonogram(this.selection);
        if (rectangle2D != null) {
            graphics2D.fillRect((int)rectangle2D.getX() + 10, (int)rectangle2D.getY(), 2, (int)rectangle2D.getHeight());
        }
        graphics2D.dispose();
    }

    public void setSelection(BoundedLongRangeModel boundedLongRangeModel) {
        this.selection = boundedLongRangeModel;
    }

    public final void setParent(AbstractSonogramComponent abstractSonogramComponent) {
        this.parent = abstractSonogramComponent;
    }

    public AbstractSonogramComponent getParent() {
        return this.parent;
    }

    public BoundedLongRangeModel getSelection() {
        return this.selection;
    }

    public Color getSelectionColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

