/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.ui.time;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.ui.time.JTimeAxis;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.MathUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;

public class JCursorTimeAxis
extends JTimeAxis {
    public static final String PROPERTY_CURSOR_COLOR = "cursorColor";
    private static final AlphaComposite CURSOR_COMPOSITE = AlphaComposite.getInstance(3, 0.8f);
    private Color cursorColor = Color.RED;
    private boolean ignoringCursorExtend = true;

    public boolean isIgnoringCursorExtend() {
        return this.ignoringCursorExtend;
    }

    public void setIgnoringCursorExtend(boolean bl) {
        this.ignoringCursorExtend = bl;
    }

    public JCursorTimeAxis() {
    }

    public JCursorTimeAxis(JTimeAxis.Alignment alignment) {
        super(alignment);
    }

    public final Color getCursorColor() {
        return this.cursorColor;
    }

    public final void setCursorColor(Color color) {
        Color color2 = this.cursorColor;
        this.cursorColor = color;
        this.repaint();
        this.firePropertyChange(PROPERTY_CURSOR_COLOR, color2, this.cursorColor);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getInsets().left, this.getInsets().top, this.getWidth() - (this.getInsets().left + this.getInsets().right), this.getHeight() - (this.getInsets().top + this.getInsets().bottom));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(graphics);
        graphics2D.clip(double_);
        this.drawSelectionMark(graphics2D, double_);
        graphics2D.dispose();
    }

    private void drawSelectionMark(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        BoundedLongRangeModel boundedLongRangeModel = this.getModel();
        if (boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent() > boundedLongRangeModel.getMinimum() && boundedLongRangeModel.getValue() < boundedLongRangeModel.getMaximum()) {
            Color color = graphics2D.getColor();
            Composite composite = graphics2D.getComposite();
            Rectangle rectangle = new Rectangle();
            rectangle.y = (int)rectangle2D.getMinY();
            rectangle.height = (int)rectangle2D.getHeight();
            rectangle.x = (int)Math.round(MathUtil.convertFromTo(boundedLongRangeModel.getValue(), boundedLongRangeModel.getMinimum(), boundedLongRangeModel.getMaximum(), 0.0, rectangle2D.getWidth()));
            rectangle.width = this.ignoringCursorExtend ? 1 : (int)Math.round(MathUtil.convertFromTo(boundedLongRangeModel.getValue() + boundedLongRangeModel.getExtent(), boundedLongRangeModel.getMinimum(), boundedLongRangeModel.getMaximum(), 0.0, rectangle2D.getWidth())) - rectangle.x;
            rectangle.x += (int)rectangle2D.getMinX();
            String string = DateTimeUtil.formatTimeHighPrecision(boundedLongRangeModel.getValue());
            Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            int n = (int)Math.floor(rectangle2D.getHeight() - rectangle2D2.getHeight());
            int n2 = graphics2D.getFontMetrics().getAscent();
            this.selectionStartX = rectangle.getMinX() + 2.0 + rectangle2D2.getWidth() < rectangle2D.getMaxX() ? (int)rectangle.getMinX() + 2 : (int)(rectangle.getMinX() - 2.0 - rectangle2D2.getWidth());
            this.selectionEndX = this.selectionStartX + (int)rectangle2D2.getWidth();
            graphics2D.drawString(string, this.selectionStartX, n2 + n);
            graphics2D.setColor(this.cursorColor);
            graphics2D.setComposite(CURSOR_COMPOSITE);
            graphics2D.fill(rectangle);
            graphics2D.setComposite(composite);
            graphics2D.setColor(color);
        }
    }
}

