/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Csv {
    private static final String SEPARATOR = ",";
    private static final String KEY_VAL_REGEX = "^\\s*([\\p{IsAlphabetic}\\p{IsDigit}_\\+\\-]+)\\s*=([^#]+)";
    private static final Pattern KEY_VAL_PTRN = Pattern.compile("^\\s*([\\p{IsAlphabetic}\\p{IsDigit}_\\+\\-]+)\\s*=([^#]+)");
    private final List<String[]> data = new LinkedList<String[]>();
    private final Map<String, String> dict = new HashMap<String, String>();

    private Csv() {
    }

    private void initFromLines(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            this.interpreteLine(string);
        }
    }

    private void initFromFile(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            this.interpreteLine(string2);
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
    }

    private void interpreteLine(String string) {
        String string2 = string.strip();
        if (string2.startsWith("#") || string2.isBlank()) {
            return;
        }
        if (this.tryInterpreteAsDict(string2)) {
            return;
        }
        if (this.tryInterpreteAsData(string2)) {
            return;
        }
    }

    private boolean tryInterpreteAsData(String string) {
        String[] stringArray = string.replaceFirst("#.*$", "").split(SEPARATOR);
        if (stringArray.length > 0) {
            this.data.add(stringArray);
            return true;
        }
        return false;
    }

    private boolean tryInterpreteAsDict(String string) {
        Matcher matcher = KEY_VAL_PTRN.matcher(string);
        if (matcher.find()) {
            this.dict.put(matcher.group(1), matcher.group(2).strip());
            return true;
        }
        return false;
    }

    public String getVal(String string) {
        return this.dict.getOrDefault(string, null);
    }

    public String getValCaseInsensitive(String string) {
        String string2 = Csv.simplify(string);
        for (String string3 : this.dict.keySet()) {
            if (!string2.equals(Csv.simplify(string3))) continue;
            return this.dict.get(string3);
        }
        return null;
    }

    private static String simplify(String string) {
        return string.strip().toLowerCase().replace("_", "");
    }

    public List<String[]> getData() {
        return this.data;
    }

    public abstract class CSVReader {
        public static Csv fromFile(String string) throws IOException {
            Csv csv = new Csv();
            csv.initFromFile(string);
            return csv;
        }

        public static Csv fromString(String string) throws IOException {
            Csv csv = new Csv();
            String[] stringArray = string.split("\\r?\\n|\\r");
            csv.initFromLines(stringArray);
            return csv;
        }
    }
}

