/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTimeUtil {
    public static final double ONE_SECOND_DOUBLE = 1.0;
    public static final double ONE_MINUTE_DOUBLE = 60.0;
    public static final double ONE_HOUR_DOUBLE = 3600.0;
    public static final double ONE_DAY_DOUBLE = 86400.0;
    public static final long ONE_SECOND_LONG = 1000L;
    public static final long ONE_MINUTE_LONG = 60000L;
    public static final long ONE_HOUR_LONG = 3600000L;
    public static final long ONE_DAY_LONG = 86400000L;
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final String FORMAT_STRING_DATE_ISO = "yyyy-MM-dd";
    public static final String FORMAT_STRING_TIME = "HH:mm:ss";
    public static final String FORMAT_STRING_TIME_HIGH_PRECISION = "HH:mm:ss.SSS";
    public static final String FORMAT_STRING_DATE_LEGACY = "yyyy/MM/dd";
    public static final String FORMAT_STRING_DATE_CSS = "dd-MMM-yy";
    public static final String FORMAT_STRING_HYPOPROT = "dd.MM.yyyy  <HH:mm:ss>";
    public static final String FORMAT_STRING_HYPOPROT_NOBRACKETS = "dd.MM.yyyy HH:mm:ss";
    public static final String FORMAT_STRING_DATETIME_ONLYNUMBERS = "yyyyMMddHHmmss";
    public static final String FORMAT_STRING_DATETIME_ONLYNUMBERS_HIGH_PRECISION = "yyyyMMddHHmmssSSS";
    private static final DateFormat FORMAT_DATE_ISO = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat FORMAT_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat FORMAT_TIME_HIGH_PRECISION = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final DateFormat FORMAT_DATETIME_ISO = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat FORMAT_DATETIME_ISO_HIGH_PRECISION = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateFormat FORMAT_DATE_LEGACY = new SimpleDateFormat("yyyy/MM/dd");
    private static final DateFormat FORMAT_DATETIME_LEGACY = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final DateFormat FORMAT_UTC_DATE_CSS = new SimpleDateFormat("dd-MMM-yy");
    private static final DateFormat FORMAT_HYPOPROT_UTC = new SimpleDateFormat("dd.MM.yyyy  <HH:mm:ss>");
    private static final DateFormat FORMAT_HYPOPROT_UTC_NOBRACKETS = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static final DateFormat FORMAT_DATETIME_ONLYNUMBERS = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final DateFormat FORMAT_DATETIME_ONLYNUMBERS_HIGH_PRECISION = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final DateFormat FORMAT_DATETIME_ISO_ONE_FIELD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final DateFormat FORMAT_DATETIME_ISO_ONE_FIELD_HIGH_PRECISION = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    @Deprecated
    public static final long doubleSecondsToLongMilliseconds(double d) {
        return DateTimeUtil.convertDoubleSToLongMs(d);
    }

    public static final long convertDoubleSToLongMs(double d) {
        double d2 = Math.floor(d);
        double d3 = d - d2;
        long l = (long)Math.floor(d2 *= 1000.0) + (long)Math.floor(d3 *= 1000.0);
        return l;
    }

    @Deprecated
    public static final double longMillisecondsToDoubleSeconds(long l) {
        return DateTimeUtil.convertLongMsToDoubleS(l);
    }

    public static final double convertLongMsToDoubleS(long l) {
        long l2 = l / 1000L;
        double d = l2;
        double d2 = l - l2 * 1000L;
        return d += (d2 /= 1000.0);
    }

    public static final double longMillisecondsToDoubleSeconds(long l, double d) {
        return DateTimeUtil.convertLongMsToDoubleS(l) + d;
    }

    public static final double calendarToEpoch(Calendar calendar) {
        return DateTimeUtil.convertLongMsToDoubleS(calendar.getTimeInMillis());
    }

    public static final double calendarToEpoch(Calendar calendar, double d) {
        return DateTimeUtil.longMillisecondsToDoubleSeconds(calendar.getTimeInMillis(), d);
    }

    public static final Calendar epochToCalendar(double d) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TIMEZONE_UTC);
        return DateTimeUtil.epochToCalendar(d, gregorianCalendar);
    }

    public static final Calendar epochToCalendar(double d, Calendar calendar) {
        Calendar calendar2 = calendar;
        calendar2.setTimeZone(TIMEZONE_UTC);
        calendar2.setTimeInMillis(DateTimeUtil.convertDoubleSToLongMs(d));
        calendar2.get(5);
        return calendar2;
    }

    public static final Calendar epochLongToCalendar(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return DateTimeUtil.epochLongToCalendar(l, gregorianCalendar);
    }

    public static final Calendar epochLongToCalendar(long l, Calendar calendar) {
        calendar.setTimeZone(TIMEZONE_UTC);
        calendar.setTimeInMillis(l);
        calendar.get(5);
        return calendar;
    }

    public static final String formatDateISO(long l) {
        return FORMAT_DATE_ISO.format(l);
    }

    public static final String formatDateISO(Calendar calendar) {
        return FORMAT_DATE_ISO.format(calendar.getTimeInMillis());
    }

    public static final String formatDateISO(double d) {
        return FORMAT_DATE_ISO.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatTime(long l) {
        return FORMAT_TIME.format(l);
    }

    public static final String formatTime(Calendar calendar) {
        return FORMAT_TIME.format(calendar.getTimeInMillis());
    }

    public static final String formatTime(double d) {
        return FORMAT_TIME.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatTimeHighPrecision(long l) {
        return FORMAT_TIME_HIGH_PRECISION.format(l);
    }

    public static final String formatTimeHighPrecision(Calendar calendar) {
        return FORMAT_TIME_HIGH_PRECISION.format(calendar.getTimeInMillis());
    }

    public static final String formatTimeHighPrecision(double d) {
        return FORMAT_TIME_HIGH_PRECISION.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatDateTimeISO(long l) {
        return FORMAT_DATETIME_ISO.format(l);
    }

    public static final String formatDateTimeISO(Calendar calendar) {
        return FORMAT_DATETIME_ISO.format(calendar.getTimeInMillis());
    }

    public static final String formatDateTimeISO(double d) {
        return FORMAT_DATETIME_ISO.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatDateTimeISOHighPrecision(long l) {
        return FORMAT_DATETIME_ISO_HIGH_PRECISION.format(l);
    }

    public static final String formatDateTimeISOHighPrecision(Calendar calendar) {
        return FORMAT_DATETIME_ISO_HIGH_PRECISION.format(calendar.getTimeInMillis());
    }

    public static final String formatDateTimeISOHighPrecision(double d) {
        return FORMAT_DATETIME_ISO_HIGH_PRECISION.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    @Deprecated
    public static final String formatDateLegacy(long l) {
        return FORMAT_DATE_LEGACY.format(l);
    }

    @Deprecated
    public static final String formatDateLegacy(Calendar calendar) {
        return FORMAT_DATE_LEGACY.format(calendar.getTimeInMillis());
    }

    @Deprecated
    public static final String formatDateLegacy(double d) {
        return FORMAT_DATE_LEGACY.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    @Deprecated
    public static final String formatDateTimeLegacy(long l) {
        return FORMAT_DATETIME_LEGACY.format(l);
    }

    @Deprecated
    public static final String formatDateTimeLegacy(Calendar calendar) {
        return FORMAT_DATETIME_LEGACY.format(calendar.getTimeInMillis());
    }

    @Deprecated
    public static final String formatDateTimeLegacy(double d) {
        return FORMAT_DATETIME_LEGACY.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatDateCSS(long l) {
        return FORMAT_UTC_DATE_CSS.format(l).toUpperCase();
    }

    public static final String formatDateCSS(Calendar calendar) {
        return FORMAT_UTC_DATE_CSS.format(calendar.getTimeInMillis()).toUpperCase();
    }

    public static final String formatDateCSS(double d) {
        return FORMAT_UTC_DATE_CSS.format(DateTimeUtil.convertDoubleSToLongMs(d)).toUpperCase();
    }

    public static final String formatDateTimeUTCHypoProt(long l) {
        return FORMAT_HYPOPROT_UTC.format(l);
    }

    public static final String formatDateTimeUTCHypoProt(Calendar calendar) {
        return FORMAT_HYPOPROT_UTC.format(calendar.getTimeInMillis());
    }

    public static final String formatDateTimeUTCHypoProt(double d) {
        return FORMAT_HYPOPROT_UTC.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatDateTimeUTCHypoProtNoBrackets(long l) {
        return FORMAT_HYPOPROT_UTC_NOBRACKETS.format(l);
    }

    public static final String formatDateTimeUTCHypoProtNoBrackets(Calendar calendar) {
        return FORMAT_HYPOPROT_UTC_NOBRACKETS.format(calendar.getTimeInMillis());
    }

    public static final String formatDateTimeUTCHypoProtNoBrackets(double d) {
        return FORMAT_HYPOPROT_UTC_NOBRACKETS.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatDateTimeOnlynumbers(long l) {
        return FORMAT_DATETIME_ONLYNUMBERS.format(l);
    }

    public static final String formatDateTimeOnlynumbers(Calendar calendar) {
        return FORMAT_DATETIME_ONLYNUMBERS.format(calendar.getTimeInMillis());
    }

    public static final String formatDateTimeOnlynumbers(double d) {
        return FORMAT_DATETIME_ONLYNUMBERS.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatDateTimeOnlynumbersHighPrecision(long l) {
        return FORMAT_DATETIME_ONLYNUMBERS_HIGH_PRECISION.format(l);
    }

    public static final String formatDateTimeOnlynumbersHighPrecision(Calendar calendar) {
        return FORMAT_DATETIME_ONLYNUMBERS_HIGH_PRECISION.format(calendar.getTimeInMillis());
    }

    public static final String formatDateTimeOnlynumbersHighPrecision(double d) {
        return FORMAT_DATETIME_ONLYNUMBERS_HIGH_PRECISION.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatDateTimeISOOneField(long l) {
        return FORMAT_DATETIME_ISO_ONE_FIELD.format(l);
    }

    public static final String formatDateTimeISOOneField(Calendar calendar) {
        return FORMAT_DATETIME_ISO_ONE_FIELD.format(calendar.getTimeInMillis());
    }

    public static final String formatDateTimeISOOneField(double d) {
        return FORMAT_DATETIME_ISO_ONE_FIELD.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final String formatDateTimeISOOneFieldHighPrecision(long l) {
        return FORMAT_DATETIME_ISO_ONE_FIELD_HIGH_PRECISION.format(l);
    }

    public static final String formatDateTimeISOOneFieldHighPrecision(Calendar calendar) {
        return FORMAT_DATETIME_ISO_ONE_FIELD_HIGH_PRECISION.format(calendar.getTimeInMillis());
    }

    public static final String formatDateTimeISOOneFieldHighPrecision(double d) {
        return FORMAT_DATETIME_ISO_ONE_FIELD_HIGH_PRECISION.format(DateTimeUtil.convertDoubleSToLongMs(d));
    }

    public static final Calendar parseDateTime(String string) throws ParseException {
        String string2;
        GregorianCalendar gregorianCalendar = null;
        ParseException parseException = null;
        try {
            gregorianCalendar = new GregorianCalendar(TIMEZONE_UTC);
            string2 = string.replaceAll("[tT]", " ");
            gregorianCalendar.setTime(FORMAT_DATETIME_ISO.parse(string2));
        }
        catch (ParseException parseException2) {
            parseException = parseException2;
            gregorianCalendar = null;
        }
        if (gregorianCalendar == null) {
            try {
                gregorianCalendar = new GregorianCalendar(TIMEZONE_UTC);
                string2 = string.replaceAll("[tT]", " ");
                gregorianCalendar.setTime(FORMAT_DATETIME_ISO_HIGH_PRECISION.parse(string2));
            }
            catch (ParseException parseException3) {
                parseException = parseException3;
                gregorianCalendar = null;
            }
        }
        if (gregorianCalendar == null) {
            try {
                gregorianCalendar = new GregorianCalendar(TIMEZONE_UTC);
                gregorianCalendar.setTime(FORMAT_DATETIME_LEGACY.parse(string));
            }
            catch (ParseException parseException4) {
                gregorianCalendar = null;
            }
        }
        if (gregorianCalendar == null) {
            try {
                gregorianCalendar = new GregorianCalendar(TIMEZONE_UTC);
                double d = Double.valueOf(string);
                gregorianCalendar.setTimeInMillis((long)(1000.0 * d));
            }
            catch (NumberFormatException numberFormatException) {
                gregorianCalendar = null;
            }
        }
        if (gregorianCalendar == null) {
            throw parseException;
        }
        return gregorianCalendar;
    }

    public static final Calendar parseDateTimeHypoProt(String string) throws ParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TIMEZONE_UTC);
        gregorianCalendar.setTime(FORMAT_HYPOPROT_UTC_NOBRACKETS.parse(string));
        return gregorianCalendar;
    }

    @Deprecated
    public static final long determineIncermentMilliSeconds(long l) {
        return DateTimeUtil.incrementMs(l);
    }

    public static final long incrementMs(long l) {
        long l2 = l <= 1000L ? 1000L : (l <= 2000L ? 2000L : (l <= 5000L ? 5000L : (l <= 12000L ? 10000L : (l <= 30000L ? 30000L : (l <= 60000L ? 60000L : (l <= 120000L ? 120000L : (l <= 300000L ? 300000L : (l <= 600000L ? 600000L : (l <= 1200000L ? 1200000L : (l <= 3600000L ? 3600000L : (l <= 0x6DDD00L ? 0x6DDD00L : (l <= 14400000L ? 14400000L : (l <= 28800000L ? 28800000L : (l <= 86400000L ? 86400000L : (l <= 172800000L ? 172800000L : (l <= 432000000L ? 432000000L : (l <= 864000000L ? 864000000L : (l <= 2592000000L ? 2592000000L : (l <= 5184000000L ? 5184000000L : (l <= 10368000000L ? 10368000000L : (l <= 20736000000L ? 20736000000L : 41472000000L)))))))))))))))))))));
        return l2;
    }

    @Deprecated
    public static final double determineIncerment(double d) {
        return DateTimeUtil.incrementS(d);
    }

    public static final double incrementS(double d) {
        return DateTimeUtil.convertLongMsToDoubleS(DateTimeUtil.incrementMs(DateTimeUtil.convertDoubleSToLongMs(d)));
    }

    public static long nowMs() {
        return Instant.now().toEpochMilli();
    }

    static {
        FORMAT_DATE_ISO.setTimeZone(TIMEZONE_UTC);
        FORMAT_TIME.setTimeZone(TIMEZONE_UTC);
        FORMAT_TIME_HIGH_PRECISION.setTimeZone(TIMEZONE_UTC);
        FORMAT_DATETIME_ISO.setTimeZone(TIMEZONE_UTC);
        FORMAT_DATETIME_ISO_HIGH_PRECISION.setTimeZone(TIMEZONE_UTC);
        FORMAT_DATE_LEGACY.setTimeZone(TIMEZONE_UTC);
        FORMAT_DATETIME_LEGACY.setTimeZone(TIMEZONE_UTC);
        FORMAT_UTC_DATE_CSS.setTimeZone(TIMEZONE_UTC);
        FORMAT_HYPOPROT_UTC.setTimeZone(TIMEZONE_UTC);
        FORMAT_HYPOPROT_UTC_NOBRACKETS.setTimeZone(TIMEZONE_UTC);
        FORMAT_DATETIME_ONLYNUMBERS.setTimeZone(TIMEZONE_UTC);
        FORMAT_DATETIME_ONLYNUMBERS_HIGH_PRECISION.setTimeZone(TIMEZONE_UTC);
        FORMAT_DATETIME_ISO_ONE_FIELD.setTimeZone(TIMEZONE_UTC);
        FORMAT_DATETIME_ISO_ONE_FIELD_HIGH_PRECISION.setTimeZone(TIMEZONE_UTC);
    }
}

