/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class FileUtil {
    public static void skipFully(InputStream inputStream, long l) throws IOException {
        long l2;
        for (long i = l; i != 0L; i -= l2) {
            l2 = inputStream.skip(i);
            if (l2 != 0L) continue;
            throw new EOFException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            file2.createNewFile();
        }
        FileChannel fileChannel = null;
        FileInputStream fileInputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileChannel = fileInputStream.getChannel();
            fileOutputStream = new FileOutputStream(file2);
            abstractInterruptibleChannel = fileOutputStream.getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(float[] fArray, String string) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < fArray.length; ++i) {
                bufferedWriter.write(Float.toString(fArray[i]));
                bufferedWriter.newLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[] getFloatSamplesFromASCII(String string, int n) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(new DataInputStream(new FileInputStream(new File(string)))));
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n2 == n) {
                    arrayList.add(Float.valueOf(Float.parseFloat(string2)));
                    continue;
                }
                ++n2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        float[] fArray = new float[arrayList.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = arrayList.get(i) != null ? ((Float)arrayList.get(i)).floatValue() : 0.0f;
        }
        return fArray;
    }

    public static double[] getDoubleSamplesFromASCII(String string) {
        Object object;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            String string2;
            object = new BufferedReader(new InputStreamReader(new DataInputStream(new FileInputStream(new File(string)))));
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                arrayList.add(Double.parseDouble(string2));
            }
            ((BufferedReader)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = new double[arrayList.size()];
        for (int i = 0; i < ((double[])object).length; ++i) {
            object[i] = arrayList.get(i) != null ? (Object)((Double)arrayList.get(i)) : (Object)0.0;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readASCIIFile(String string) {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            String string3;
            StringBuilder stringBuilder = new StringBuilder();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3 + "\n");
            }
            string2 = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        bufferedReader.close();
        return string2;
    }

    public static void printComponent(JComponent jComponent, String string) {
        FileUtil.printComponent(jComponent, string, true);
    }

    public static void printComponent(JComponent jComponent, String string, boolean bl) {
        FileUtil.printComponent(jComponent, string, bl, jComponent.getWidth(), jComponent.getHeight());
    }

    public static void printComponent(JComponent jComponent, String string, boolean bl, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n3 = jComponent.getSize().width;
        int n4 = jComponent.getSize().height;
        jComponent.setSize(n, n2);
        jComponent.setPreferredSize(jComponent.getSize());
        jComponent.paint(graphics2D);
        graphics2D.dispose();
        jComponent.setSize(n3, n4);
        jComponent.setPreferredSize(jComponent.getSize());
        File file = new File(SuiteManager.INSTANCE.getKnowledgebase().getTmpFolder().getAbsolutePath() + File.separator + string);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            LogUtil.info(FileUtil.class, "Snapshot saved in " + file.getAbsolutePath(), bl);
        }
        catch (IOException iOException) {
            LogUtil.error(FileUtil.class, "Could not export component to png, " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public static void writeMatrix(double[][] dArray, int[] nArray, String string, boolean bl) {
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        try {
            printWriter = new PrintWriter(new File(string));
            if (bl) {
                printWriter2 = new PrintWriter(new File(string + ".labels"));
            }
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    printWriter.write(dArray[i][j] + "\t");
                }
                printWriter.write("\n");
                if (!bl) continue;
                printWriter2.write(nArray[i] + "\n");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        printWriter.close();
        if (bl) {
            printWriter2.close();
        }
    }

    public static double[][] readMatrix(String string, int n) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split("\t");
                if (n == 0) {
                    n = stringArray.length;
                }
                double[] dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Double.parseDouble(stringArray[i]);
                }
                arrayList.add(dArray);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return (double[][])arrayList.toArray((T[])new double[arrayList.size()][n]);
    }

    public static File[] listFilesMatching(File file, String string) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is no directory.");
        }
        final Pattern pattern = Pattern.compile(string);
        return file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return pattern.matcher(string).matches();
            }
        });
    }

    public static boolean urlExists(String string) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            return httpURLConnection.getResponseCode() == 200;
        }
        catch (Exception exception) {
            LogUtil.error(FileUtil.class, "Could not load url: " + exception.getMessage());
            return false;
        }
    }
}

