/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.PlatformUtil;
import edu.geophys.commons.util.TextAreaAppender;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class LogUtil {
    public static final Logger ROOT_LOGGER = Logger.getRootLogger();
    private static final String SYS_PROPERTY_KEY_LOG_LEVEL = "geophys.log.level";
    public static String LOG_FILE = "No log was written.";
    private static FileAppender logfileAppender;
    static final PatternLayout layout;
    static final PatternLayout swingLayout;
    static boolean headLess;

    public static final boolean isDebug() {
        return Level.DEBUG.isGreaterOrEqual((Priority)ROOT_LOGGER.getEffectiveLevel());
    }

    public static final void setToDebugLevel() {
        ROOT_LOGGER.setLevel(Level.DEBUG);
        if (logfileAppender == null && PlatformUtil.getLogDirectory().isDirectory()) {
            LOG_FILE = PlatformUtil.getLogDirectory().getAbsolutePath() + File.separator + DateTimeUtil.formatDateTimeOnlynumbers(System.currentTimeMillis()) + ".log";
            try {
                logfileAppender = new FileAppender((Layout)layout, LOG_FILE);
                ROOT_LOGGER.addAppender((Appender)logfileAppender);
            }
            catch (IOException iOException) {
                LogUtil.error(LogUtil.class, "error accessing log file: " + LOG_FILE, iOException);
            }
        }
    }

    public static final void setToLevel(Level level) {
        ROOT_LOGGER.setLevel(level);
    }

    public static final void debug(Class<?> clazz, String string) {
        Logger.getLogger(clazz).debug((Object)string);
    }

    public static final void info(Class<?> clazz, String string) {
        LogUtil.info(clazz, string, false);
    }

    public static final void info(Class<?> clazz, String string, boolean bl) {
        Logger.getLogger(clazz).info((Object)string);
        if (bl && !headLess) {
            JOptionPane.showMessageDialog(null, string, "Info", 1);
        }
    }

    public static final void warn(Class<?> clazz, String string) {
        LogUtil.warn(clazz, string, false);
    }

    public static final void warn(Class<?> clazz, String string, boolean bl) {
        Logger.getLogger(clazz).warn((Object)string);
        if (bl && !headLess) {
            JOptionPane.showMessageDialog(null, string, "Info", 2);
        }
    }

    public static final void error(Class<?> clazz, String string) {
        LogUtil.error(clazz, string, false);
    }

    public static final void error(Class<?> clazz, String string, boolean bl) {
        Logger.getLogger(clazz).error((Object)string);
        if (bl && !headLess) {
            JOptionPane.showMessageDialog(null, string, "Error", 0);
        }
    }

    public static final void fatal(Class<?> clazz, String string) {
        LogUtil.fatal(clazz, string, false);
    }

    public static final void fatal(Class<?> clazz, String string, boolean bl) {
        Logger.getLogger(clazz).fatal((Object)string);
        if (bl && !headLess) {
            JOptionPane.showMessageDialog(null, string, "Info", 0);
        }
    }

    public static final void debug(Class<?> clazz, String string, Throwable throwable) {
        Logger.getLogger(clazz).debug((Object)string, throwable);
    }

    public static final void info(Class<?> clazz, String string, Throwable throwable) {
        Logger.getLogger(clazz).info((Object)string, throwable);
    }

    public static final void warn(Class<?> clazz, String string, Throwable throwable) {
        Logger.getLogger(clazz).warn((Object)string, throwable);
    }

    public static final void error(Class<?> clazz, String string, Throwable throwable) {
        Logger.getLogger(clazz).error((Object)string, throwable);
    }

    public static final void fatal(Class<?> clazz, String string, Throwable throwable) {
        Logger.getLogger(clazz).fatal((Object)string, throwable);
    }

    static {
        layout = new PatternLayout("%d{ISO8601} %-5p [%t] %c: %m%n");
        swingLayout = new PatternLayout("%d{HH:mm:ss} %-5p %m%n");
        headLess = GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance();
        Filter filter = new Filter(){
            private int counter = 0;
            private String lastMessage = "";

            public int decide(LoggingEvent loggingEvent) {
                int n;
                if (loggingEvent.getMessage() != null && ((String)loggingEvent.getMessage()).equals(this.lastMessage)) {
                    n = this.counter % 100 == 0 || this.counter % 100 == 1 ? 0 : -1;
                    ++this.counter;
                } else {
                    n = 0;
                    this.counter = 0;
                }
                this.lastMessage = (String)loggingEvent.getMessage();
                return n;
            }
        };
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout);
        consoleAppender.addFilter(filter);
        TextAreaAppender textAreaAppender = new TextAreaAppender(swingLayout, Level.WARN);
        textAreaAppender.addFilter(filter);
        TextAreaAppender.setTextArea(SuiteManager.INSTANCE.getErrorConsoleUtil().getTextArea());
        ROOT_LOGGER.addAppender((Appender)consoleAppender);
        ROOT_LOGGER.addAppender((Appender)textAreaAppender);
        ROOT_LOGGER.setLevel(Level.INFO);
    }
}

