/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import Jama.Matrix;
import edu.geophys.commons.util.PCACalc;

public class PCAHelper {
    private double[][] pcs;
    private double[] evs;

    public double[][] doPCA(float[] fArray, float[] fArray2) {
        this.pcs = new double[2][10];
        if (fArray.length > 0 && fArray.length == fArray2.length) {
            int n;
            double[][] dArray = new double[2][fArray.length];
            float f = 0.0f;
            float f2 = 0.0f;
            for (n = 0; n < fArray.length; ++n) {
                f += fArray[n];
                f2 += fArray2[n];
            }
            f /= (float)fArray.length;
            f2 /= (float)fArray2.length;
            for (n = 0; n < fArray.length; ++n) {
                dArray[0][n] = fArray[n] - f;
                dArray[1][n] = fArray2[n] - f2;
            }
            PCACalc pCACalc = new PCACalc(PCACalc.PcaMode.Normal, dArray.length);
            pCACalc.calcPCA(new Matrix(dArray).transpose());
            this.pcs = new Matrix(pCACalc.getPcs()).transpose().getArray();
        }
        return this.pcs;
    }

    public float[][] doPCA(float[][] fArray, int n) {
        int n2;
        int n3 = fArray.length;
        int n4 = fArray[0].length;
        double[][] dArray = new double[n3][n4];
        float[] fArray2 = new float[n4];
        int n5 = 0;
        while (n5 < n4) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n6 = n5;
                fArray2[n6] = fArray2[n6] + fArray[n2][n5];
            }
            int n7 = n5++;
            fArray2[n7] = fArray2[n7] / (float)n3;
        }
        for (n5 = 0; n5 < n4; ++n5) {
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2][n5] = fArray[n2][n5] - fArray2[n5];
            }
        }
        PCACalc pCACalc = new PCACalc(PCACalc.PcaMode.SVD, n);
        Matrix matrix = new Matrix(dArray);
        pCACalc.calcPCA(matrix);
        Matrix matrix2 = new Matrix(pCACalc.getPcs());
        this.pcs = matrix2.getArray();
        this.evs = pCACalc.getEvs();
        Matrix matrix3 = matrix.times(matrix2);
        Matrix matrix4 = matrix3.times(matrix2.transpose());
        double[][] dArray2 = matrix4.getArray();
        float[][] fArray3 = new float[dArray2.length][dArray2[0].length];
        for (int i = 0; i < fArray3.length; ++i) {
            for (int j = 0; j < fArray3[i].length; ++j) {
                fArray3[i][j] = (float)dArray2[i][j];
            }
        }
        return fArray3;
    }

    public float[][] do3dPca(float[] fArray, float[] fArray2, float[] fArray3) {
        float[][] fArray4 = new float[10][10];
        if (fArray.length > 0 && fArray2.length > 0 && fArray3.length > 0) {
            int n;
            double[][] dArray = new double[3][fArray.length];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            for (n = 0; n < fArray.length; ++n) {
                f += fArray[n];
                f2 += fArray2[n];
                f3 += fArray3[n];
            }
            f /= (float)fArray.length;
            f2 /= (float)fArray2.length;
            f3 /= (float)fArray3.length;
            for (n = 0; n < fArray.length; ++n) {
                dArray[0][n] = fArray[n] - f;
                dArray[1][n] = fArray2[n] - f2;
                dArray[2][n] = fArray3[n] - f3;
            }
            PCACalc pCACalc = new PCACalc(PCACalc.PcaMode.Normal, dArray.length);
            Matrix matrix = new Matrix(dArray).transpose();
            pCACalc.calcPCA(matrix);
            Matrix matrix2 = new Matrix(pCACalc.getPcs());
            this.pcs = matrix2.getArray();
            this.evs = pCACalc.getEvs();
            Matrix matrix3 = matrix.times(matrix2);
            double[][] dArray2 = matrix3.transpose().getArray();
            fArray4 = new float[dArray2.length][dArray2[0].length];
            for (int i = 0; i < fArray4.length; ++i) {
                for (int j = 0; j < fArray4[i].length; ++j) {
                    fArray4[i][j] = (float)dArray2[i][j];
                }
            }
        }
        return fArray4;
    }

    public double[][] getPcs() {
        return this.pcs;
    }

    public void setPcs(double[][] dArray) {
        this.pcs = dArray;
    }

    public double[] getEvs() {
        return this.evs;
    }

    public void setEvs(double[] dArray) {
        this.evs = dArray;
    }
}

