/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.TreeMap;

public final class PlatformUtil {
    private static final String NEW_LINE = System.getProperties().getProperty("line.separator");
    private static final String USER_NAME = System.getProperties().getProperty("user.name");
    private static final String USER_HOME = System.getProperties().getProperty("user.home");
    private static final String USER_CONF_PATH = System.getProperties().getProperty("user.home") + PlatformUtil.getSeparator() + PlatformUtil.getUserConfName();
    private static final String DEMO_DATA_DIR = "ExampleData";
    private static final String PLAIN_LOG_NAME = "log";
    private static File LOG_DIRECTORY;

    public static File initializeDirectory(String string) {
        File file = new File(string);
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("could not create directory \"" + file.getAbsolutePath() + "\"");
        }
        return file;
    }

    public static File initializeDirectory(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("could not create directory \"" + file.getAbsolutePath() + "\"");
        }
        return file;
    }

    private static void initialize() {
        PlatformUtil.initializeDirectory(USER_CONF_PATH);
        LOG_DIRECTORY = PlatformUtil.initializeDirectory(USER_CONF_PATH + PlatformUtil.getSeparator() + PLAIN_LOG_NAME);
    }

    public static File getLogDirectory() {
        return LOG_DIRECTORY;
    }

    public static boolean isLinux() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.startsWith("linux");
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.startsWith("windows");
    }

    public static boolean isVista() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.contains("vista");
    }

    public static boolean isMac() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.contains("mac");
    }

    private static String getUserConfName() {
        if (PlatformUtil.isLinux()) {
            return ".NanoseismicSuiteDemo1_26";
        }
        return "NanoseismicSuiteDemo1_26";
    }

    public static String getUserHome() {
        return USER_HOME;
    }

    public static String getUserName() {
        return USER_NAME;
    }

    public static String getUserConfPath() {
        return USER_CONF_PATH;
    }

    public static String getApplicationConfPath(String string) {
        return PlatformUtil.initializeDirectory(PlatformUtil.getUserConfPath() + PlatformUtil.getSeparator() + string.toLowerCase()).getAbsolutePath();
    }

    public static String getSeparator() {
        return File.separator;
    }

    public static String getNewLine() {
        return NEW_LINE;
    }

    public static File getSafeCanonicalPath(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            LogUtil.warn(PlatformUtil.class, "Could not determine canonical path of " + file.getName() + ", using: " + file.getAbsolutePath());
            return file;
        }
    }

    public static Map<String, File> findDemoData() {
        TreeMap<String, File> treeMap = new TreeMap<String, File>();
        File file = PlatformUtil.getApplicationDir();
        File file2 = new File(file, DEMO_DATA_DIR);
        if (!file2.isDirectory()) {
            return treeMap;
        }
        for (File file3 : file2.listFiles()) {
            String string = file3.getName();
            File file4 = null;
            if (file3.isDirectory()) {
                for (File file5 : file3.listFiles()) {
                    if (!file5.getName().toLowerCase().equals("header.fhd")) continue;
                    file4 = file5;
                }
            }
            if (file4 == null) continue;
            treeMap.put(string, file4);
        }
        return treeMap;
    }

    public static File getApplicationDir() {
        try {
            File file = PlatformUtil.getSafeCanonicalPath(new File(SuiteManager.class.getProtectionDomain().getCodeSource().getLocation().toURI()));
            if (file.getParentFile().getName().toLowerCase().contentEquals("lib")) {
                file = file.getParentFile().getParentFile();
            }
            return file;
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    static {
        PlatformUtil.initialize();
    }
}

