/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.commons.util;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public final class SwingUtil {
    public static final Rectangle2D componentDrawingArea(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        Rectangle2D.Double double_ = new Rectangle2D.Double(insets.left, insets.top, jComponent.getWidth() - (insets.left + insets.right), jComponent.getHeight() - (insets.top + insets.bottom));
        return double_;
    }

    public static void setRenderingQuality(Graphics2D graphics2D, RenderQuality renderQuality) {
        if (renderQuality.ordinal() > RenderQuality.VERY_LOW.ordinal()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            SwingUtil.setAntialiasing(graphics2D, renderQuality.ordinal() > RenderQuality.MEDIUM.ordinal());
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, renderQuality.ordinal() > RenderQuality.LOW.ordinal() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            SwingUtil.setAntialiasing(graphics2D, false);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public static void setAntialiasing(Graphics2D graphics2D, boolean bl) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static final double absolute2Relative(int n, int n2) {
        return (double)n2 / (double)n;
    }

    public static final int relative2Absolute(int n, float f) {
        return Math.round((float)n * f);
    }

    public static final int relative2Absolute(int n, double d) {
        return (int)Math.round((double)n * d);
    }

    public static final void relative2Absolute(int n, float[] fArray, int[] nArray) {
        for (int i = 0; i < fArray.length; ++i) {
            nArray[i] = SwingUtil.relative2Absolute(n, fArray[i]);
        }
    }

    public static final void relative2Absolute(int n, double[] dArray, int[] nArray) {
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = SwingUtil.relative2Absolute(n, dArray[i]);
        }
    }

    public static enum RenderQuality {
        VERY_LOW(false),
        LOW(false),
        MEDIUM(true),
        HIGH(true);

        private final boolean antialiasing;

        private RenderQuality(boolean bl) {
            this.antialiasing = bl;
        }

        public boolean isAntialiasing() {
            return this.antialiasing;
        }
    }
}

