/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ProxySurface;
import jogamp.nativewindow.windows.GDI;

public class GDISurface
extends ProxySurface {
    protected long windowHandle;
    protected long surfaceHandle;

    public GDISurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l, int n, int n2, ProxySurface.UpstreamSurfaceHook upstreamSurfaceHook) {
        super(abstractGraphicsConfiguration, n, n2, upstreamSurfaceHook);
        this.windowHandle = l;
        this.surfaceHandle = 0L;
    }

    @Override
    protected void invalidateImpl() {
        if (0L != this.surfaceHandle) {
            throw new NativeWindowException("didn't release surface Handle: " + this);
        }
        this.windowHandle = 0L;
    }

    @Override
    public final void setSurfaceHandle(long l) {
        this.windowHandle = l;
    }

    public final void setWindowHandle(long l) {
        this.windowHandle = l;
    }

    public final long getWindowHandle() {
        return this.windowHandle;
    }

    @Override
    protected final int lockSurfaceImpl() {
        if (0L == this.windowHandle) {
            throw new NativeWindowException("null window handle: " + this);
        }
        if (0L != this.surfaceHandle) {
            throw new InternalError("surface not released");
        }
        this.surfaceHandle = GDI.GetDC(this.windowHandle);
        return 0L != this.surfaceHandle ? 3 : 1;
    }

    @Override
    protected final void unlockSurfaceImpl() {
        if (0L != this.surfaceHandle) {
            if (0 == GDI.ReleaseDC(this.windowHandle, this.surfaceHandle)) {
                throw new NativeWindowException("DC not released: " + this + ", isWindow " + GDI.IsWindow(this.windowHandle) + ", werr " + GDI.GetLastError() + ", thread: " + Thread.currentThread().getName());
            }
            this.surfaceHandle = 0L;
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return this.surfaceHandle;
    }

    @Override
    public final String toString() {
        ProxySurface.UpstreamSurfaceHook upstreamSurfaceHook = this.getUpstreamSurfaceHook();
        String string = null != upstreamSurfaceHook ? upstreamSurfaceHook.getClass().getName() + ": " + upstreamSurfaceHook : "nil";
        return this.getClass().getSimpleName() + "[config " + this.getPrivateGraphicsConfiguration() + ", displayHandle 0x" + Long.toHexString(this.getDisplayHandle()) + ", windowHandle 0x" + Long.toHexString(this.windowHandle) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()) + ", size " + this.getWidth() + "x" + this.getHeight() + ", surfaceLock " + this.surfaceLock + ", upstreamSurfaceHook " + string + "]";
    }
}

