/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.ProxySurface;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLUpstreamSurfaceHook;

public abstract class EGLDrawable
extends GLDrawableImpl {
    private boolean ownEGLSurface = false;

    protected EGLDrawable(EGLDrawableFactory eGLDrawableFactory, NativeSurface nativeSurface) throws GLException {
        super(eGLDrawableFactory, nativeSurface, false);
    }

    @Override
    public abstract GLContext createContext(GLContext var1);

    protected abstract long createSurface(EGLGraphicsConfiguration var1, long var2);

    private final void recreateSurface() {
        int n;
        EGLUpstreamSurfaceHook eGLUpstreamSurfaceHook;
        NativeSurface nativeSurface;
        long l;
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.surface.getGraphicsConfiguration();
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": createSurface using " + eGLGraphicsConfiguration);
        }
        if (0L != this.surface.getSurfaceHandle()) {
            EGL.eglDestroySurface(eGLGraphicsDevice.getHandle(), this.surface.getSurfaceHandle());
        }
        if (0L == (l = this.createSurface(eGLGraphicsConfiguration, (nativeSurface = (eGLUpstreamSurfaceHook = (EGLUpstreamSurfaceHook)((ProxySurface)this.surface).getUpstreamSurfaceHook()).getUpstreamSurface()).getSurfaceHandle()))) {
            NativeWindow nativeWindow;
            n = EGL.eglGetError();
            if (12299 == n && nativeSurface instanceof NativeWindow && (nativeWindow = (NativeWindow)nativeSurface).getWindowHandle() != nativeWindow.getSurfaceHandle()) {
                if (DEBUG) {
                    System.err.println(EGLDrawable.getThreadName() + ": Info: Creation of window surface w/ surface handle failed: " + eGLGraphicsConfiguration + ", error " + EGLDrawable.toHexString(n) + ", retry w/ windowHandle");
                }
                if (0L == (l = this.createSurface(eGLGraphicsConfiguration, nativeWindow.getWindowHandle()))) {
                    n = EGL.eglGetError();
                }
            }
        } else {
            n = 12288;
        }
        if (0L == l) {
            throw new GLException("Creation of window surface failed: " + eGLGraphicsConfiguration + ", " + this.surface + ", error " + EGLDrawable.toHexString(n));
        }
        if (DEBUG) {
            System.err.println(EGLDrawable.getThreadName() + ": setSurface using component: handle " + EGLDrawable.toHexString(this.surface.getSurfaceHandle()) + " -> " + EGLDrawable.toHexString(l));
        }
        ((MutableSurface)this.surface).setSurfaceHandle(l);
    }

    @Override
    protected final void updateHandle() {
        if (this.ownEGLSurface) {
            this.recreateSurface();
        }
    }

    @Override
    protected final void setRealizedImpl() {
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.surface.getGraphicsConfiguration();
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)eGLGraphicsConfiguration.getScreen().getDevice();
        if (this.realized) {
            boolean bl;
            long l = eGLGraphicsDevice.getHandle();
            if (0L == l) {
                throw new GLException("Invalid EGL display in EGLGraphicsDevice " + eGLGraphicsDevice);
            }
            int[] nArray = new int[1];
            boolean bl2 = bl = 0L != this.surface.getSurfaceHandle();
            if (bl && !(bl = EGL.eglQuerySurface(l, this.surface.getSurfaceHandle(), 12328, nArray, 0)) && DEBUG) {
                System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealizedImpl eglQuerySuface failed: " + EGLDrawable.toHexString(EGL.eglGetError()) + ", " + this.surface);
            }
            if (bl) {
                if (DEBUG) {
                    System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealizedImpl re-using component's EGLSurface: handle " + EGLDrawable.toHexString(this.surface.getSurfaceHandle()));
                }
                this.ownEGLSurface = false;
            } else {
                if (!(this.surface instanceof ProxySurface)) {
                    throw new InternalError("surface not ProxySurface: " + this.surface.getClass().getName() + ", " + this.surface);
                }
                ProxySurface.UpstreamSurfaceHook upstreamSurfaceHook = ((ProxySurface)this.surface).getUpstreamSurfaceHook();
                if (null == upstreamSurfaceHook) {
                    throw new InternalError("null upstreamHook of: " + this.surface);
                }
                if (!(upstreamSurfaceHook instanceof EGLUpstreamSurfaceHook)) {
                    throw new InternalError("upstreamHook not EGLUpstreamSurfaceHook: Surface: " + this.surface.getClass().getName() + ", " + this.surface + "; UpstreamHook: " + upstreamSurfaceHook.getClass().getName() + ", " + upstreamSurfaceHook);
                }
                if (null == ((EGLUpstreamSurfaceHook)upstreamSurfaceHook).getUpstreamSurface()) {
                    throw new InternalError("null upstream surface");
                }
                this.ownEGLSurface = true;
                if (DEBUG) {
                    System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealizedImpl owning EGLSurface");
                }
            }
        } else if (this.ownEGLSurface && this.surface.getSurfaceHandle() != 0L) {
            if (DEBUG) {
                System.err.println(EGLDrawable.getThreadName() + ": EGLDrawable.setRealized(false): ownSurface " + this.ownEGLSurface + ", " + eGLGraphicsDevice + ", eglSurface: " + EGLDrawable.toHexString(this.surface.getSurfaceHandle()));
            }
            if (!EGL.eglDestroySurface(eGLGraphicsDevice.getHandle(), this.surface.getSurfaceHandle())) {
                throw new GLException("Error destroying window surface (eglDestroySurface)");
            }
            ((MutableSurface)this.surface).setSurfaceHandle(0L);
        }
    }

    @Override
    protected final void swapBuffersImpl() {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)this.surface.getGraphicsConfiguration().getScreen().getDevice();
        if (!EGL.eglSwapBuffers(eGLGraphicsDevice.getHandle(), this.surface.getSurfaceHandle())) {
            throw new GLException("Error swapping buffers, eglError " + EGLDrawable.toHexString(EGL.eglGetError()) + ", " + this);
        }
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper() {
        if (this.getGLProfile().usesNativeGLES2()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(2);
        }
        if (this.getGLProfile().usesNativeGLES1()) {
            return this.getFactoryImpl().getGLDynamicLookupHelper(1);
        }
        throw new GLException("Unsupported: " + this.getGLProfile());
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[realized " + this.isRealized() + ",\n\tfactory    " + this.getFactory() + ",\n\tsurface    " + this.getNativeSurface() + ",\n\teglSurface " + EGLDrawable.toHexString(this.surface.getSurfaceHandle()) + ",\n\teglConfig  " + this.surface.getGraphicsConfiguration() + ",\n\trequested  " + this.getRequestedGLCapabilities() + ",\n\tchosen     " + this.getChosenGLCapabilities() + "]";
    }
}

