/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv;

import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.PlatformUtil;
import edu.geophys.seisserv.SeisServApplication;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public final class SeisServ {
    public static final String APPLICATION_NAME = "SeisServ";
    public static final String APPLICATION_CONF_PATH = PlatformUtil.getApplicationConfPath((String)SeisServ.getApplicationName());
    private static SeisServApplication app;

    private static String getApplicationName() {
        return APPLICATION_NAME;
    }

    private static String getConfigurationDirectory() {
        return APPLICATION_CONF_PATH;
    }

    public static SeisServApplication getApplication() {
        return app;
    }

    public static void main(final String[] stringArray) {
        Locale.setDefault(Locale.UK);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        app = new SeisServApplication(stringArray);
                        app.createAndShowGui();
                    }
                    catch (Throwable throwable) {
                        LogUtil.fatal(SeisServ.class, (String)"unkown error caused the application to crash", (Throwable)throwable);
                        JOptionPane.showMessageDialog(null, "An unkown error caused the application to crash, please see log\n" + LogUtil.LOG_FILE + "\n for detailed information and send the log per mail to the developers.", "Error", 0);
                    }
                }
            });
        }
        catch (Exception exception) {
            LogUtil.fatal(SeisServ.class, (String)("Unkown error caused the application to crash, " + exception.getLocalizedMessage()), (Throwable)exception);
            JOptionPane.showMessageDialog(null, "An unkown error caused the application to crash, please see log\n" + LogUtil.LOG_FILE + "\n for detailed information and send the log per mail to the developers, " + exception.getLocalizedMessage(), "Error", 0);
        }
    }
}

