/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public abstract class AbstractServerStatusPanel
extends JPanel {
    private StateEnum state = StateEnum.STOPPED;
    private final String serviceName;
    private String message = "";
    private JButton button;
    private JLabel messageLabel;
    private JLabel stateLabel;

    public AbstractServerStatusPanel(String string) {
        this.serviceName = string;
        this.initComponents();
    }

    private void setState(StateEnum stateEnum) {
        this.state = stateEnum;
        switch (this.state) {
            case STARTING: {
                this.stateLabel.setText("Starting...");
                this.button.setText("Stop Service");
                this.onStart();
                break;
            }
            case STOPPING: {
                this.stateLabel.setText("Stopping...");
                this.button.setText("Stop Service");
                this.onStop();
                break;
            }
            case STARTED: {
                this.stateLabel.setText("Started");
                this.button.setText("Stop Service");
                break;
            }
            case STOPPED: {
                this.stateLabel.setText("Stopped");
                this.button.setText("Start Service");
            }
        }
    }

    public final void setStart() {
        this.setState(StateEnum.STARTING);
    }

    public final void setStopping() {
        this.setState(StateEnum.STOPPING);
    }

    public final void setStarted() {
        this.setState(StateEnum.STARTED);
    }

    public final void setStopped() {
        this.setState(StateEnum.STOPPED);
    }

    public final void setMessage(String string) {
        this.message = string;
        this.messageLabel.setText(this.message);
    }

    protected abstract void onStart();

    protected abstract void onStop();

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.stateLabel = new JLabel();
        this.button = new JButton();
        this.messageLabel = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder(this.serviceName));
        jLabel.setText("Status:");
        this.stateLabel.setHorizontalAlignment(4);
        this.stateLabel.setText("Stopped");
        this.button.setText("Start Service");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractServerStatusPanel.this.buttonActionPerformed(actionEvent);
            }
        });
        this.messageLabel.setText(this.message);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.button, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel).addGap(18, 18, 18).addComponent(this.stateLabel)).addComponent(this.messageLabel, -1, 326, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.stateLabel).addComponent(this.button)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.messageLabel, -1, 23, Short.MAX_VALUE).addGap(12, 12, 12)));
    }

    private void buttonActionPerformed(ActionEvent actionEvent) {
        if (this.state != StateEnum.STOPPED) {
            this.setState(StateEnum.STOPPING);
        } else {
            this.setState(StateEnum.STARTING);
        }
    }

    private static enum StateEnum {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

