/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing;

import edu.geophys.seisserv.SeisServConfiguration;
import edu.geophys.seisserv.swing.HeaderFileChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class JTabbedDataLoader
extends JDialog {
    private static final long serialVersionUID = 1296620742872509155L;
    private boolean load = false;
    private File headerFile;
    private int border = 10;
    private static final FileNameExtensionFilter[] HEADER_FILE_FILTERS = new FileNameExtensionFilter[]{new FileNameExtensionFilter("Fixed header files (*.fhd)", "fhd")};
    private JTabbedPane jTab;
    private SeisServConfiguration traceConfig;

    public JTabbedDataLoader(JFrame jFrame, SeisServConfiguration seisServConfiguration) {
        this.traceConfig = seisServConfiguration;
        this.jTab = new JTabbedPane();
        this.jTab.addTab("CSS", null, this.getHeaderPanel(), "Load css/sht header file");
        if (seisServConfiguration.getDataSource() != null) {
            switch (seisServConfiguration.getDataSource()) {
                default: 
            }
            this.jTab.setSelectedIndex(0);
        }
        this.add(this.jTab);
    }

    private JPanel getHeaderPanel() {
        File[] fileArray = this.traceConfig.getHeaderHistory();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : fileArray) {
            if (!file.exists()) continue;
            arrayList.add(file.getParent());
        }
        JPanel jPanel = new JPanel();
        final HeaderFileChooser headerFileChooser = new HeaderFileChooser(this.traceConfig.getLastOpenedHeader(), arrayList);
        for (FileNameExtensionFilter fileNameExtensionFilter : HEADER_FILE_FILTERS) {
            headerFileChooser.setFileFilter(fileNameExtensionFilter);
        }
        headerFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("CancelSelection")) {
                    JTabbedDataLoader.this.setVisible(false);
                    JTabbedDataLoader.this.dispose();
                }
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    JTabbedDataLoader.this.setHeaderFile(headerFileChooser.getSelectedFile().getAbsoluteFile());
                    JTabbedDataLoader.this.traceConfig.setDataSource(SeisServConfiguration.DATA_SOURCE.HEADER);
                    JTabbedDataLoader.this.setLoad(true);
                    JTabbedDataLoader.this.setVisible(false);
                    JTabbedDataLoader.this.dispose();
                }
            }
        });
        jPanel.add(headerFileChooser);
        return jPanel;
    }

    private void exit() {
        this.setVisible(false);
        this.dispose();
    }

    public void setLoad(boolean bl) {
        this.load = bl;
    }

    public boolean isLoad() {
        return this.load;
    }

    public void setHeaderFile(File file) {
        this.headerFile = file;
    }

    public File getHeaderFile() {
        return this.headerFile;
    }
}

