/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.knowledgebase.Knowledgebase;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.seisserv.SeisServApplication;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import layout.TableLayout;

public class StationSelectorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton applyButton;
    private JTable snsList;
    private SeisServApplication seisServ;
    private StationsKnowledge stationsKnowledge;
    private int checkboxWidth = 20;
    private int border = 3;

    public void loadSNS() {
        Knowledgebase knowledgebase = SuiteManager.INSTANCE.getKnowledgebase();
        if (knowledgebase != null) {
            this.stationsKnowledge = knowledgebase.getStationsKnowledge();
            SNS[] sNSArray = this.stationsKnowledge.getAllSNS();
            Object[][] objectArray = new Object[sNSArray.length][2];
            Object[] objectArray2 = new Object[]{"", "select active stations"};
            for (int i = 0; i < sNSArray.length; ++i) {
                objectArray[i][1] = sNSArray[i].getID();
                objectArray[i][0] = sNSArray[i].isEnabled();
            }
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2);
            this.snsList.setModel(defaultTableModel);
        } else {
            Object[][] objectArray = new Object[1][2];
            objectArray[0][0] = false;
            objectArray[0][1] = "no stations loaded";
            Object[] objectArray3 = new Object[]{"", "select active stations"};
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray3);
            this.snsList.setModel(defaultTableModel);
        }
        this.snsList.getColumnModel().getColumn(0).setMaxWidth(this.checkboxWidth);
        this.snsList.getColumnModel().getColumn(0).setMinWidth(this.checkboxWidth);
    }

    public StationSelectorPanel(SeisServApplication seisServApplication) {
        this.seisServ = seisServApplication;
        this.snsList = new JTable(){

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        this.snsList.setDefaultEditor(Object.class, null);
        this.loadSNS();
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StationSelectorPanel.this.applyButtonActionPerformed(actionEvent);
            }
        });
        this.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{this.border, -1.0, this.border}, {this.border, -1.0, this.border, -3.0, this.border}}));
        this.add((Component)new JScrollPane(this.snsList), "1, 1");
        this.add((Component)this.applyButton, "1, 3");
    }

    private void applyButtonActionPerformed(ActionEvent actionEvent) {
        if (this.stationsKnowledge == null) {
            return;
        }
        TableModel tableModel = this.snsList.getModel();
        int n = tableModel.getRowCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string = (String)tableModel.getValueAt(i, 1);
            boolean bl2 = (Boolean)tableModel.getValueAt(i, 0);
            SNS sNS = this.stationsKnowledge.getSNSById(string);
            if (sNS.isEnabled() == bl2) continue;
            sNS.setEnabled(bl2);
            bl = true;
        }
        if (bl) {
            if (this.stationsKnowledge.getAllActiveSNS().length > 0) {
                SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().setValuesByValue(this.stationsKnowledge);
                SuiteManager.INSTANCE.getKnowledgebase().store();
                this.seisServ.activeChanged();
            } else {
                LogUtil.warn(this.getClass(), (String)"<html><center>No active stations selected</center></html>", (boolean)true);
            }
        }
    }
}

