/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing.knowledgebase;

import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.seisserv.swing.knowledgebase.KnowledgeContainer;
import edu.geophys.seisserv.swing.knowledgebase.KnowledgePanel;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class JCampaignKnowledgePanel
extends JPanel
implements KnowledgePanel {
    private final JLabel layerMainPanel = new JLabel();
    private static final DefaultFormatterFactory dateFormaterFactory = new DefaultFormatterFactory(new DateFormatter(DateTimeUtil.FORMAT_DATETIME_ISO));
    private boolean editingEnabled = false;
    private KnowledgeContainer model = null;
    private JFormattedTextField ftfEnd;
    private JFormattedTextField ftfHalfsize;
    private JFormattedTextField ftfHeight;
    private JFormattedTextField ftfLat;
    private JFormattedTextField ftfLon;
    private JFormattedTextField ftfStart;
    private JFormattedTextField ftfXOffset;
    private JFormattedTextField ftfYOffset;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField tfName;

    public JCampaignKnowledgePanel() {
        this.initComponents();
    }

    @Override
    public KnowledgeContainer getModel() {
        return this.model;
    }

    @Override
    public boolean isEditingEnabled() {
        return this.editingEnabled;
    }

    @Override
    public void setEditingEnabled(boolean bl) {
        this.editingEnabled = bl;
        this.ftfStart.setEnabled(bl);
        this.ftfEnd.setEnabled(bl);
        this.tfName.setEnabled(bl);
        this.ftfLat.setEnabled(bl);
        this.ftfLon.setEnabled(bl);
        this.ftfHeight.setEnabled(bl);
        this.ftfXOffset.setEnabled(bl);
        this.ftfYOffset.setEnabled(bl);
        this.ftfHalfsize.setEnabled(bl);
    }

    @Override
    public void setModel(KnowledgeContainer knowledgeContainer) {
        this.model = knowledgeContainer;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(DateTimeUtil.TIMEZONE_UTC);
        gregorianCalendar.setTimeInMillis(this.model.getCampaignKnowledge().getCampaignEpochStart());
        this.ftfStart.setValue(gregorianCalendar.getTime());
        gregorianCalendar = new GregorianCalendar(DateTimeUtil.TIMEZONE_UTC);
        gregorianCalendar.setTimeInMillis(this.model.getCampaignKnowledge().getCampaignEpochEnd());
        this.ftfEnd.setValue(gregorianCalendar.getTime());
        this.tfName.setText(this.model.getCampaignKnowledge().getCampaignName());
        this.ftfLat.setValue(this.model.getCampaignKnowledge().getReferencePoint().getLatitude());
        this.ftfLon.setValue(this.model.getCampaignKnowledge().getReferencePoint().getLongitude());
        this.ftfHeight.setValue(this.model.getCampaignKnowledge().getReferencePoint().getHeight());
        this.ftfXOffset.setValue(this.model.getCampaignKnowledge().getStationMap().getXOffset());
        this.ftfYOffset.setValue(this.model.getCampaignKnowledge().getStationMap().getYOffset());
        this.ftfHalfsize.setValue(this.model.getCampaignKnowledge().getStationMap().getHalfsize());
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.ftfStart = new JFormattedTextField();
        this.ftfEnd = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.tfName = new JTextField();
        this.jPanel3 = new JPanel();
        this.ftfLat = new JFormattedTextField();
        this.ftfLon = new JFormattedTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.ftfHeight = new JFormattedTextField();
        this.jLabel6 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jPanel4 = new JPanel();
        this.ftfXOffset = new JFormattedTextField();
        this.ftfYOffset = new JFormattedTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.ftfHalfsize = new JFormattedTextField();
        this.jLabel9 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Campaign duration"));
        this.ftfStart.setFormatterFactory(dateFormaterFactory);
        this.ftfStart.setHorizontalAlignment(11);
        this.ftfStart.setFocusLostBehavior(0);
        this.ftfStart.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JCampaignKnowledgePanel.this.ftfStartPropertyChange(propertyChangeEvent);
            }
        });
        this.ftfEnd.setFormatterFactory(dateFormaterFactory);
        this.ftfEnd.setHorizontalAlignment(11);
        this.ftfEnd.setFocusLostBehavior(0);
        this.ftfEnd.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JCampaignKnowledgePanel.this.ftfEndPropertyChange(propertyChangeEvent);
            }
        });
        this.jLabel1.setText("Start:");
        this.jLabel2.setText("End:");
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ftfEnd, -1, 438, Short.MAX_VALUE).addComponent(this.ftfStart, -1, 438, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ftfStart, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ftfEnd, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Campaign common properties"));
        this.jLabel10.setText("Name:");
        this.tfName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JCampaignKnowledgePanel.this.tfNameFocusLost(focusEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLabel10).addGap(46, 46, 46).addComponent(this.tfName, -1, 398, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.tfName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addContainerGap(15, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Map reference point"));
        this.ftfLat.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00000"))));
        this.ftfLat.setHorizontalAlignment(11);
        this.ftfLat.setFocusLostBehavior(0);
        this.ftfLat.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JCampaignKnowledgePanel.this.ftfLatPropertyChange(propertyChangeEvent);
            }
        });
        this.ftfLon.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00000"))));
        this.ftfLon.setHorizontalAlignment(11);
        this.ftfLon.setFocusLostBehavior(0);
        this.ftfLon.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JCampaignKnowledgePanel.this.ftfLonPropertyChange(propertyChangeEvent);
            }
        });
        this.jLabel4.setText("Latitude:");
        this.jLabel5.setText("Longitude:");
        this.ftfHeight.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00### km"))));
        this.ftfHeight.setHorizontalAlignment(11);
        this.ftfHeight.setFocusLostBehavior(0);
        this.ftfHeight.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JCampaignKnowledgePanel.this.ftfHeightPropertyChange(propertyChangeEvent);
            }
        });
        this.jLabel6.setText("Height:");
        this.jLabel11.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setText("Note: Changing this values does not update the coordinates relative to it!");
        GroupLayout groupLayout3 = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11, -1, 482, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftfLat, -1, 86, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftfLon, -1, 86, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftfHeight, -1, 86, Short.MAX_VALUE))).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.ftfLat, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.ftfLon, -2, -1, -2).addComponent(this.ftfHeight, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE).addComponent(this.jLabel11).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Epimap offset from map reference point"));
        this.ftfXOffset.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00### km"))));
        this.ftfXOffset.setHorizontalAlignment(11);
        this.ftfXOffset.setFocusLostBehavior(0);
        this.ftfXOffset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JCampaignKnowledgePanel.this.ftfXOffsetPropertyChange(propertyChangeEvent);
            }
        });
        this.ftfYOffset.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00### km"))));
        this.ftfYOffset.setHorizontalAlignment(11);
        this.ftfYOffset.setFocusLostBehavior(0);
        this.ftfYOffset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JCampaignKnowledgePanel.this.ftfYOffsetPropertyChange(propertyChangeEvent);
            }
        });
        this.jLabel7.setText("x-Offset:");
        this.jLabel8.setText("y-Offset:");
        this.ftfHalfsize.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0.00### km"))));
        this.ftfHalfsize.setHorizontalAlignment(11);
        this.ftfHalfsize.setFocusLostBehavior(0);
        this.ftfHalfsize.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JCampaignKnowledgePanel.this.ftfHalfsizePropertyChange(propertyChangeEvent);
            }
        });
        this.jLabel9.setText("Halfsize:");
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftfXOffset, -1, 85, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftfYOffset, -1, 85, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ftfHalfsize, -1, 85, Short.MAX_VALUE).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.ftfXOffset, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.ftfYOffset, -2, -1, -2).addComponent(this.ftfHalfsize, -2, -1, -2).addComponent(this.jLabel9)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout5 = new GroupLayout(this);
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.layerMainPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.layerMainPanel, -2, -1, -2).addContainerGap(13, Short.MAX_VALUE)));
    }

    private void ftfEndPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.model.getCampaignKnowledge().setCampaignEpochEnd(((Date)this.ftfEnd.getValue()).getTime());
        }
    }

    private void ftfStartPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.model.getCampaignKnowledge().setCampaignEpochStart(((Date)this.ftfStart.getValue()).getTime());
        }
    }

    private void ftfLatPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.model.getCampaignKnowledge().getReferencePoint().setLatitude(Double.valueOf(this.ftfLat.getValue().toString()).doubleValue());
        }
    }

    private void ftfLonPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.model.getCampaignKnowledge().getReferencePoint().setLongitude(Double.valueOf(this.ftfLon.getValue().toString()).doubleValue());
        }
    }

    private void ftfHeightPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.model.getCampaignKnowledge().getReferencePoint().setHeight(Double.valueOf(this.ftfHeight.getValue().toString()).doubleValue());
        }
    }

    private void ftfXOffsetPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.model.getCampaignKnowledge().getStationMap().setXOffset(Double.valueOf(this.ftfXOffset.getValue().toString()).doubleValue());
        }
    }

    private void ftfYOffsetPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.model.getCampaignKnowledge().getStationMap().setYOffset(Double.valueOf(this.ftfYOffset.getValue().toString()).doubleValue());
        }
    }

    private void ftfHalfsizePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.model.getCampaignKnowledge().getStationMap().setHalfsize(Double.valueOf(this.ftfHalfsize.getValue().toString()).doubleValue());
        }
    }

    private void tfNameFocusLost(FocusEvent focusEvent) {
        this.model.getCampaignKnowledge().setCampaignName(this.tfName.getText());
    }
}

