/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.seisserv.swing.knowledgebase;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.seisserv.swing.knowledgebase.JCampaignKnowledgePanel;
import edu.geophys.seisserv.swing.knowledgebase.JStationsKnowledgePanel;
import edu.geophys.seisserv.swing.knowledgebase.KnowledgeContainer;
import edu.geophys.seisserv.swing.knowledgebase.KnowledgePanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;

public class JKnowledgebaseEditor
extends JDialog {
    private boolean editingEnabled = false;
    private KnowledgeContainer model = null;
    private final LinkedHashMap<String, JPanel> tabs = new LinkedHashMap();
    private boolean changed = false;
    private JButton btnCloseCancel;
    private JButton btnEditSave;
    private JPanel buttonPanel;
    private JTabbedPane tabbedPane;
    private JPanel tabbedPanePanel;

    public JKnowledgebaseEditor(Frame frame, boolean bl) {
        super(frame, bl);
        this.tabs.put("Campaign", new JCampaignKnowledgePanel());
        this.tabs.put("Stations", new JStationsKnowledgePanel());
        this.initComponents();
        for (Map.Entry<String, JPanel> entry : this.tabs.entrySet()) {
            JScrollPane jScrollPane = new JScrollPane(entry.getValue(), 20, 30);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
            this.tabbedPane.addTab(entry.getKey(), jScrollPane);
        }
        this.revertChanges();
        this.setEditingEnabled(false);
    }

    private void revertChanges() {
        this.model = new KnowledgeContainer(new CampaignKnowledge(), new StationsKnowledge());
        this.model.getCampaignKnowledge().setValuesByValue(SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge());
        this.model.getStationsKnowledge().setValuesByValue(SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge());
        this.updateChildModels();
    }

    private void commitChanges() {
        SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().setValuesByValue(this.model.getCampaignKnowledge());
        for (SNS sNS : this.model.getStationsKnowledge().getAllSNS()) {
            if (sNS.getCenter() == null) {
                LogUtil.warn(this.getClass(), (String)("Detected invalid SNS " + sNS.getID() + " without mandatory center station."), (boolean)true);
            }
            for (Site site : sNS.getAllSites()) {
                if (site.getId() != null && !site.getId().isEmpty() && site.getTraceZ() != null && !site.getTraceZ().isEmpty()) continue;
                LogUtil.warn(this.getClass(), (String)("Detected invalid Site in SNS " + sNS.getID() + " without mandatory site id or traceZ."), (boolean)true);
            }
        }
        SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().setValuesByValue(this.model.getStationsKnowledge());
        SuiteManager.INSTANCE.getKnowledgebase().store();
        this.revertChanges();
        this.changed = true;
    }

    private void updateChildModels() {
        for (JPanel jPanel : this.tabs.values()) {
            if (!(jPanel instanceof KnowledgePanel)) continue;
            KnowledgePanel knowledgePanel = (KnowledgePanel)((Object)jPanel);
            knowledgePanel.setModel(this.model);
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isEditingEnabled() {
        return this.editingEnabled;
    }

    public void setEditingEnabled(boolean bl) {
        this.editingEnabled = bl;
        if (this.editingEnabled) {
            this.btnEditSave.setText("Apply");
            this.btnCloseCancel.setText("Cancel");
        } else {
            this.btnEditSave.setText("Edit");
            this.btnCloseCancel.setText("Close");
        }
        for (JPanel jPanel : this.tabs.values()) {
            if (!(jPanel instanceof KnowledgePanel)) continue;
            KnowledgePanel knowledgePanel = (KnowledgePanel)((Object)jPanel);
            knowledgePanel.setEditingEnabled(this.editingEnabled);
        }
    }

    private void initComponents() {
        this.tabbedPanePanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.buttonPanel = new JPanel();
        this.btnCloseCancel = new JButton();
        this.btnEditSave = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Knowledgebase Editor");
        this.setIconImage(null);
        this.setLocationByPlatform(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = new Dimension(1200, 700);
        if (dimension.height > dimension2.height && dimension.width > dimension2.width) {
            this.setMinimumSize(dimension2);
        } else {
            this.setMinimumSize(dimension);
        }
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JKnowledgebaseEditor.this.formWindowClosing(windowEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.tabbedPanePanel);
        this.tabbedPanePanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 610, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 405, Short.MAX_VALUE));
        this.btnCloseCancel.setText("Close");
        this.btnCloseCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JKnowledgebaseEditor.this.btnCloseCancelActionPerformed(actionEvent);
            }
        });
        this.btnEditSave.setText("Edit");
        this.btnEditSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JKnowledgebaseEditor.this.btnEditSaveActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap(422, Short.MAX_VALUE).addComponent(this.btnEditSave, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCloseCancel, -2, 85, -2).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCloseCancel).addComponent(this.btnEditSave)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonPanel, -1, -1, Short.MAX_VALUE).addComponent(this.tabbedPanePanel, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addComponent(this.tabbedPanePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, -1, -2)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        int n;
        if (this.isEditingEnabled() && (n = JOptionPane.showConfirmDialog(this, "Do you really want to revert your changes?", "Revert Modifications", 0)) != 0) {
            return;
        }
        this.doClose();
    }

    private void btnCloseCancelActionPerformed(ActionEvent actionEvent) {
        if (this.isEditingEnabled()) {
            int n = JOptionPane.showConfirmDialog(this, "Do you really want to revert your changes?", "Revert Modifications", 0);
            if (n != 0) {
                return;
            }
            this.revertChanges();
            this.setEditingEnabled(false);
        } else {
            this.doClose();
        }
    }

    private void btnEditSaveActionPerformed(ActionEvent actionEvent) {
        if (this.isEditingEnabled()) {
            int n = JOptionPane.showConfirmDialog(this, "Do you really want to make your modifications permanent?", "Commit Modifications", 0);
            if (n != 0) {
                return;
            }
            this.commitChanges();
            this.setEditingEnabled(false);
        } else {
            this.setEditingEnabled(true);
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }
}

