/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ensemble;

import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.ui.SingleTracePaint;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.JFrameHelper;
import edu.geophys.commons.util.LoadHeaderUtil;
import edu.geophys.commons.util.MathUtil;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class FilterPicker5 {
    public double filterWindow = 4.0;
    public double longTermWindow = 5.0;
    public double threshold1 = 8.0;
    public double threshold2 = 8.0;
    public double tUpEvent = 0.5;
    private static final int INT_UNSET = -1073741823;
    private FilterPicker5_Memory mem = null;
    public static final int PICKS = 0;
    public static final int CHAR_FUNC = 1;
    public static final int TRIGGER = 2;
    private double deltaTime;
    public List<PickData> triggerPickData = new ArrayList<PickData>();
    private boolean useMemory = true;
    private static int index_recursive = 0;

    public final float[] apply(double d, float[] fArray, int n) {
        int n2;
        int n3;
        this.deltaTime = d;
        if (this.mem == null) {
            this.mem = new FilterPicker5_Memory(fArray);
        }
        float[] fArray2 = null;
        if (n == 2 || n == 1) {
            fArray2 = new float[fArray.length];
        }
        double d2 = 5.0 * this.threshold1;
        boolean bl = true;
        double d3 = -1.0;
        int n4 = -1;
        int n5 = -1;
        for (n3 = 0; n3 < fArray.length; ++n3) {
            double d4;
            int n6;
            n2 = 0;
            int n7 = this.mem.upEventBufPtr;
            this.mem.upEventBufPtr = (this.mem.upEventBufPtr + 1) % this.mem.nTUpEvent;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = fArray[n3];
            double d8 = d7 - this.mem.lastSample;
            for (n6 = this.mem.numRecursive - 1; n6 >= 0; --n6) {
                double d9;
                double d10 = this.mem.highPassConst[n6] * (this.mem.filteredSample[n6][0] + d8);
                d4 = d10 - this.mem.filteredSample[n6][0];
                this.mem.filteredSample[n6][0] = d10;
                this.mem.filteredSample[n6][1] = d10 = this.mem.highPassConst[n6] * (this.mem.filteredSample[n6][1] + d4);
                d10 = this.mem.filteredSample[n6][2] + this.mem.lowPassConst[n6] * (d10 - this.mem.filteredSample[n6][2]);
                this.mem.lastFilteredSample[n6] = this.mem.filteredSample[n6][2];
                this.mem.filteredSample[n6][2] = d10;
                this.mem.test[n6] = d9 = d10;
                this.mem.xRec[n6] = d9 * d9;
                double d11 = 0.0;
                if (this.mem.mean_stdDev_xRec[n6] <= (double)1.4E-45f) {
                    if (this.mem.enableTriggering && bl) {
                        System.out.println("ERROR: FilterPicker5: mem.mean_stdDev_xRec[k] <= Float.MIN_VALUE (this should not happen!) k=" + n6);
                        bl = false;
                    }
                } else {
                    double d12 = (this.mem.xRec[n6] - this.mem.mean_xRec[n6]) / this.mem.mean_stdDev_xRec[n6];
                    d11 = d12;
                    if (d11 > d2) {
                        d11 = d2;
                        this.mem.xRec[n6] = d2 * this.mem.mean_stdDev_xRec[n6] + this.mem.mean_xRec[n6];
                    }
                    if (d12 >= d5) {
                        d5 = d12;
                        d6 = d11;
                        this.mem.charFuntNumRecursiveIndex[this.mem.upEventBufPtr] = n6;
                    }
                    if (d12 >= this.threshold1) {
                        this.mem.charFuntNumRecursiveIndex[this.mem.upEventBufPtr] = n6;
                    }
                }
                this.mem.charFunctUncertainty[n6] = d11;
                boolean bl2 = this.mem.charFunctUncertaintyLast[n6] < this.mem.uncertaintyThreshold[n6] && this.mem.charFunctUncertainty[n6] >= this.mem.uncertaintyThreshold[n6];
                this.mem.charFunctUncertaintyLast[n6] = this.mem.charFunctUncertainty[n6];
                this.mem.indexUncertainty[n6][this.mem.upEventBufPtr] = bl2 ? n3 - 1 : this.mem.indexUncertainty[n6][n7];
                if (bl2) {
                    this.mem.polarityDerivativeSum[n6][this.mem.upEventBufPtr] = 0.0;
                    this.mem.polaritySumAbsDerivative[n6][this.mem.upEventBufPtr] = 0.0;
                } else {
                    this.mem.polarityDerivativeSum[n6][this.mem.upEventBufPtr] = this.mem.polarityDerivativeSum[n6][n7];
                    this.mem.polaritySumAbsDerivative[n6][this.mem.upEventBufPtr] = this.mem.polaritySumAbsDerivative[n6][n7];
                }
                double d13 = this.mem.filteredSample[n6][2] - this.mem.lastFilteredSample[n6];
                double[] dArray = this.mem.polarityDerivativeSum[n6];
                int n8 = this.mem.upEventBufPtr;
                dArray[n8] = dArray[n8] + d13;
                double[] dArray2 = this.mem.polaritySumAbsDerivative[n6];
                int n9 = this.mem.upEventBufPtr;
                dArray2[n9] = dArray2[n9] + Math.abs(d13);
            }
            if (this.mem.enableTriggering || this.mem.nTotal++ > this.mem.indexEnableTriggering) {
                this.mem.enableTriggering = true;
                this.mem.integralCharFunctClipped[this.mem.upEventBufPtr] = this.mem.integralCharFunctClipped[n7] - this.mem.charFunctClippedValue[this.mem.upEventBufPtr] + d6;
                this.mem.charFunctClippedValue[this.mem.upEventBufPtr] = d6;
                this.mem.charFunctValue[this.mem.upEventBufPtr] = d5;
                if (this.mem.allowNewPickIndex != -1073741823 && this.mem.integralCharFunctClipped[this.mem.upEventBufPtr] >= this.mem.criticalIntegralCharFunct) {
                    n6 = this.mem.upEventBufPtr;
                    d4 = this.mem.charFunctClippedValue[n6];
                    int n10 = 0;
                    while (n10++ < this.mem.nTUpEvent - 1 && n3 - n10 > this.mem.allowNewPickIndex) {
                        if (--n6 < 0) {
                            n6 += this.mem.nTUpEvent;
                        }
                        d4 += this.mem.charFunctClippedValue[n6];
                        if (!(this.mem.charFunctValue[n6] >= this.threshold1)) continue;
                        int n11 = n6 - 1;
                        if (n11 < 0) {
                            n11 += this.mem.nTUpEvent;
                        }
                        if (!(this.mem.charFunctValue[n11] < this.threshold1) || !(d4 >= this.mem.criticalIntegralCharFunct)) continue;
                        n2 = 1;
                        d3 = this.mem.charFunctValue[n6];
                        this.mem.triggerNumRecursiveIndex = this.mem.charFuntNumRecursiveIndex[n6];
                        n4 = n3 - n10;
                        n5 = this.mem.indexUncertainty[this.mem.triggerNumRecursiveIndex][n6];
                        int n12 = n6 + 1;
                        if (n12 >= this.mem.nTUpEvent) {
                            n12 -= this.mem.nTUpEvent;
                        }
                        this.mem.pickPolarity = 0;
                        if (this.mem.polarityDerivativeSum[this.mem.triggerNumRecursiveIndex][n12] > 0.0 && this.mem.polarityDerivativeSum[this.mem.triggerNumRecursiveIndex][n12] / this.mem.polaritySumAbsDerivative[this.mem.triggerNumRecursiveIndex][n12] > 0.667) {
                            this.mem.pickPolarity = 1;
                        } else if (this.mem.polarityDerivativeSum[this.mem.triggerNumRecursiveIndex][n12] < 0.0 && -this.mem.polarityDerivativeSum[this.mem.triggerNumRecursiveIndex][n12] / this.mem.polaritySumAbsDerivative[this.mem.triggerNumRecursiveIndex][n12] > 0.667) {
                            this.mem.pickPolarity = -1;
                        }
                        this.mem.allowNewPickIndex = -1073741823;
                        break;
                    }
                }
                if (n2 == 0 && this.mem.allowNewPickIndex == -1073741823) {
                    for (n6 = 0; n6 < this.mem.numRecursive && !(this.mem.charFunctUncertainty[n6] > this.mem.maxAllowNewPickThreshold); ++n6) {
                    }
                    if (n6 == this.mem.numRecursive) {
                        this.mem.allowNewPickIndex = n3;
                    }
                }
            }
            for (n6 = 0; n6 < this.mem.numRecursive; ++n6) {
                this.mem.mean_xRec[n6] = this.mem.mean_xRec[n6] * this.mem.longDecayConst + this.mem.xRec[n6] * this.mem.longDecayFactor;
                d4 = this.mem.xRec[n6] - this.mem.mean_xRec[n6];
                this.mem.mean_var_xRec[n6] = this.mem.mean_var_xRec[n6] * this.mem.longDecayConst + d4 * d4 * this.mem.longDecayFactor;
                this.mem.mean_stdDev_xRec[n6] = Math.sqrt(this.mem.mean_var_xRec[n6]);
                this.mem.uncertaintyThreshold[n6] = this.mem.uncertaintyThreshold[n6] * this.mem.longDecayConst + this.mem.charFunctUncertainty[n6] * this.mem.longDecayFactor;
                if (this.mem.uncertaintyThreshold[n6] > this.mem.maxUncertaintyThreshold) {
                    this.mem.uncertaintyThreshold[n6] = this.mem.maxUncertaintyThreshold;
                    continue;
                }
                if (!(this.mem.uncertaintyThreshold[n6] < this.mem.minUncertaintyThreshold)) continue;
                this.mem.uncertaintyThreshold[n6] = this.mem.minUncertaintyThreshold;
            }
            if (n == 2) {
                fArray2[n3] = n2 != 0 ? 1.0f : 0.0f;
            } else if (n == 1) {
                fArray2[n3] = (float)d6;
            } else if (n2 != 0) {
                int n13 = n4;
                n6 = n5 - (n4 - n5);
                double d14 = this.deltaTime * (double)(n13 - n6);
                double d15 = this.mem.period[this.mem.triggerNumRecursiveIndex];
                if (d14 < d15 / 20.0) {
                    int n14 = (int)(0.5 * (d15 / 20.0 - d14) / this.deltaTime);
                    n6 -= n14;
                    n13 += n14;
                }
                PickData pickData = new PickData(n6, n13, this.mem.pickPolarity, d3, "_CF", d15);
                this.triggerPickData.add(pickData);
            }
            this.mem.lastSample = d7;
            this.mem.lastDiffSample = d8;
        }
        if (this.useMemory) {
            for (n3 = 0; n3 < this.mem.nTUpEvent; ++n3) {
                for (n2 = 0; n2 < this.mem.numRecursive; ++n2) {
                    int[] nArray = this.mem.indexUncertainty[n2];
                    int n15 = n3;
                    nArray[n15] = nArray[n15] - fArray.length;
                }
            }
            if (this.mem.allowNewPickIndex != -1073741823) {
                this.mem.allowNewPickIndex -= fArray.length;
            }
        } else {
            this.mem = null;
        }
        if (n == 2 || n == 1) {
            fArray = fArray2;
            ++index_recursive;
        }
        return fArray;
    }

    public static void main(String[] stringArray) throws ParseException {
        int n;
        LoadHeaderUtil.loadHeader((File)new File("/home/sick/geophys/knowbases/PISCO_94/header_a04.sht"));
        String string = "1994/02/02 08:54:10";
        String string2 = "04_C-SZ";
        double d = (double)DateTimeUtil.parseDateTime((String)string).getTimeInMillis() / 1000.0;
        DefaultTrace defaultTrace = SuiteManager.INSTANCE.getTraceProvider().requestTrace(d + 20.0, d + 30.0, 100.0f, new String[]{string2})[0];
        float[] fArray = MathUtil.subMeanZeroNaN((float[])defaultTrace.getSamples());
        FilterPicker5 filterPicker5 = new FilterPicker5();
        float[] fArray2 = filterPicker5.apply(0.01, fArray, 1);
        System.out.println(MathUtil.calcMaximum((float[])fArray2));
        float[] fArray3 = new float[fArray2.length];
        for (n = 0; n < fArray2.length; ++n) {
            if (!((double)fArray2[n] >= filterPicker5.threshold1)) continue;
            fArray3[n] = -1.0f;
        }
        System.out.println();
        for (n = 0; n < filterPicker5.triggerPickData.size(); ++n) {
            System.out.println(filterPicker5.triggerPickData.get((int)n).name);
            System.out.println(filterPicker5.triggerPickData.get((int)n).amplitude);
            System.out.println(filterPicker5.triggerPickData.get((int)n).amplitudeUnits);
            System.out.println(filterPicker5.triggerPickData.get((int)n).period);
            System.out.println(filterPicker5.triggerPickData.get((int)n).polarity);
            for (double d2 : filterPicker5.triggerPickData.get((int)n).indices) {
                System.out.print(d2 + "\t");
                fArray3[(int)d2] = 1.0f;
            }
            System.out.println();
        }
        JFrameHelper.showInFrame((JComponent[])new JComponent[]{new SingleTracePaint(fArray), new SingleTracePaint(fArray2, (float)filterPicker5.threshold1, true), new SingleTracePaint(fArray3)});
    }

    public class FilterPicker5_Memory {
        double longDecayFactor;
        double longDecayConst;
        int nLongTermWindow;
        int indexEnableTriggering;
        boolean enableTriggering;
        int nTotal;
        int numRecursive;
        int nTemp;
        double[] xRec;
        double[] test;
        double[][] filteredSample;
        double[] lastFilteredSample;
        double[] mean_xRec;
        double[] mean_stdDev_xRec;
        double[] mean_var_xRec;
        double[] period;
        double[] lowPassConst;
        double[] highPassConst;
        double window;
        double lastSample;
        double lastDiffSample;
        double[] charFunctUncertainty;
        double[] charFunctUncertaintyLast;
        double[] uncertaintyThreshold;
        double maxUncertaintyThreshold;
        double minUncertaintyThreshold;
        double maxAllowNewPickThreshold;
        int nTUpEvent;
        int[][] indexUncertainty;
        double[][] polarityDerivativeSum;
        double[][] polaritySumAbsDerivative;
        double criticalIntegralCharFunct;
        double[] integralCharFunctClipped;
        int allowNewPickIndex;
        double[] charFunctClippedValue;
        double[] charFunctValue;
        int[] charFuntNumRecursiveIndex;
        int upEventBufPtr;
        int pickPolarity;
        int triggerNumRecursiveIndex;

        public FilterPicker5_Memory(float[] fArray) {
            int n;
            this.longDecayFactor = FilterPicker5.this.deltaTime / FilterPicker5.this.longTermWindow;
            this.longDecayConst = 1.0 - this.longDecayFactor;
            this.indexEnableTriggering = this.nLongTermWindow = 1 + (int)(FilterPicker5.this.longTermWindow / FilterPicker5.this.deltaTime);
            this.enableTriggering = false;
            this.nTotal = -1;
            this.numRecursive = 1;
            this.nTemp = 1;
            int n2 = (int)(FilterPicker5.this.filterWindow / FilterPicker5.this.deltaTime);
            while (this.nTemp < n2) {
                ++this.numRecursive;
                this.nTemp *= 2;
            }
            n2 = this.nTemp;
            this.xRec = new double[this.numRecursive];
            this.test = new double[this.numRecursive];
            this.filteredSample = new double[this.numRecursive][3];
            this.lastFilteredSample = new double[this.numRecursive];
            this.mean_xRec = new double[this.numRecursive];
            this.mean_stdDev_xRec = new double[this.numRecursive];
            this.mean_var_xRec = new double[this.numRecursive];
            this.period = new double[this.numRecursive];
            this.lowPassConst = new double[this.numRecursive];
            this.highPassConst = new double[this.numRecursive];
            this.window = FilterPicker5.this.deltaTime / (Math.PI * 2);
            for (n2 = 0; n2 < this.numRecursive; ++n2) {
                this.mean_xRec[n2] = 0.0;
                this.mean_stdDev_xRec[n2] = 0.0;
                this.mean_var_xRec[n2] = 0.0;
                this.period[n2] = this.window * 2.0 * Math.PI;
                this.lowPassConst[n2] = FilterPicker5.this.deltaTime / (this.window + FilterPicker5.this.deltaTime);
                this.highPassConst[n2] = this.window / (this.window + FilterPicker5.this.deltaTime);
                this.window *= 2.0;
            }
            this.lastSample = Double.MAX_VALUE;
            this.lastDiffSample = 0.0;
            this.charFunctUncertainty = new double[this.numRecursive];
            this.charFunctUncertaintyLast = new double[this.numRecursive];
            this.uncertaintyThreshold = new double[this.numRecursive];
            for (n2 = 0; n2 < this.numRecursive; ++n2) {
                this.uncertaintyThreshold[n2] = FilterPicker5.this.threshold1 / 2.0;
            }
            this.maxUncertaintyThreshold = FilterPicker5.this.threshold1 / 2.0;
            this.minUncertaintyThreshold = 0.5;
            this.maxAllowNewPickThreshold = 2.0;
            this.nTUpEvent = (int)Math.round(FilterPicker5.this.tUpEvent / FilterPicker5.this.deltaTime) + 1;
            if (this.nTUpEvent < 1) {
                this.nTUpEvent = 1;
            }
            this.indexUncertainty = new int[this.numRecursive][this.nTUpEvent];
            this.polarityDerivativeSum = new double[this.numRecursive][this.nTUpEvent];
            this.polaritySumAbsDerivative = new double[this.numRecursive][this.nTUpEvent];
            this.criticalIntegralCharFunct = (double)this.nTUpEvent * FilterPicker5.this.threshold2;
            this.integralCharFunctClipped = new double[this.nTUpEvent];
            this.allowNewPickIndex = -1073741823;
            this.charFunctClippedValue = new double[this.nTUpEvent];
            this.charFunctValue = new double[this.nTUpEvent];
            this.charFuntNumRecursiveIndex = new int[this.nTUpEvent];
            for (n2 = 0; n2 < this.nTUpEvent; ++n2) {
                for (int i = 0; i < this.numRecursive; ++i) {
                    this.indexUncertainty[i][n2] = 0;
                }
                this.charFunctClippedValue[n2] = 0.0;
                this.charFunctValue[n2] = 0.0;
                this.charFuntNumRecursiveIndex[n2] = 0;
            }
            this.upEventBufPtr = 0;
            this.pickPolarity = 0;
            this.triggerNumRecursiveIndex = -1;
            n2 = this.nLongTermWindow < fArray.length ? this.nLongTermWindow : fArray.length;
            double d = 0.0;
            for (n = 0; n < n2; ++n) {
                d += (double)fArray[n];
            }
            d /= (double)n2;
            for (n = 0; n < this.numRecursive; ++n) {
                for (int i = 0; i < 3; ++i) {
                    this.filteredSample[n][i] = 0.0;
                }
            }
            this.lastSample = d;
        }
    }

    public class PickData {
        public static final String NO_AMP_UNITS = "";
        public static final String DATA_AMP_UNITS = "_DATA";
        public static final String CHAR_FUNCT_AMP_UNITS = "_CF";
        public static final String INDEP_VAR_UNITS = "_INDEP_VAR";
        public static final int POLARITY_POS = 1;
        public static final int POLARITY_UNKNOWN = 0;
        public static final int POLARITY_NEG = -1;
        public int polarity = 0;
        public double[] indices = new double[2];
        public double amplitude = 0.0;
        public String amplitudeUnits = "";
        public double period = 0.0;
        public String name = null;

        public PickData() {
        }

        public PickData(double d, double d2, int n, double d3, String string, double d4) {
            this.indices[0] = d;
            this.indices[1] = d2;
            this.polarity = n;
            this.amplitude = d3;
            this.amplitudeUnits = string;
            this.period = d4;
        }

        public PickData(double d, double d2, int n, double d3, String string) {
            this.indices[0] = d;
            this.indices[1] = d2;
            this.polarity = n;
            this.amplitude = d3;
            this.amplitudeUnits = string;
        }
    }
}

