/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ccode.CHypoLineRoutines56;
import edu.geophys.hypoline.sitecollection.SiteCollectionModel;
import edu.geophys.hypoline.ui.trace.SiteModel;
import java.util.List;

public class EpiCenter {
    private double x = Double.NaN;
    private double y = Double.NaN;
    private double lon = Double.NaN;
    private double lat = Double.NaN;
    private double onsetTime = Double.NaN;
    private double rsdp = -1.0;
    private float epi_z = 0.0f;
    private float simul_depth = 0.0f;
    private double onsetTimeOffset = 0.0;
    private final CampaignKnowledge ck = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();

    public void setLatLon(double d, double d2, boolean bl) {
        this.lat = d;
        this.lon = d2;
        if (bl) {
            this.updateXY();
        }
        this.calcSimul();
        this.calcPrsd();
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
            siteModel.setEpiDist(Math.sqrt(Math.pow(this.x - siteModel.getXOffsetKm(), 2.0) + Math.pow(this.y - siteModel.getYOffsetKm(), 2.0)));
            siteModel.updateRepaint();
            siteModel.getChild().setEpiDist(Math.sqrt(Math.pow(this.x - siteModel.getXOffsetKm(), 2.0) + Math.pow(this.y - siteModel.getYOffsetKm(), 2.0)));
            siteModel.getChild().updateRepaint();
        }
    }

    private void calcPrsd() {
        this.rsdp = 0.0;
        int n = 0;
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
            SiteModel siteModel2 = siteModel.getChild();
            if (Double.isNaN(siteModel2.getpPick())) continue;
            double d = siteModel2.getpPick() - siteModel2.getpSimulPick();
            this.rsdp += d * d;
            ++n;
        }
        this.rsdp = n > 0 ? (this.rsdp /= (double)n) : -1.0;
    }

    private void calcSimul() {
        if (!Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            Object object;
            List<SiteModel> list = HypoLineManager.INSTANCE.getSites();
            SiteCollectionModel siteCollectionModel = HypoLineManager.INSTANCE.getSiteCollectionModel();
            SiteModel siteModel = null;
            boolean bl = true;
            for (SiteModel siteModel2 : list) {
                object = siteModel2.getChild();
                if (!object.isActiveTrace() || !HypoLineManager.INSTANCE.getCurrentSitesDetail().contains(object)) continue;
                siteModel = siteModel2;
                bl = object.ispOrSActive();
            }
            if (siteModel == null) {
                for (SiteModel siteModel2 : list) {
                    object = siteModel2.getChild();
                    if (!Double.isNaN(object.getpPick())) {
                        siteModel = siteModel2;
                        bl = true;
                        break;
                    }
                    if (Double.isNaN(object.getsPick())) continue;
                    siteModel = siteModel2;
                    bl = false;
                    break;
                }
            }
            if (siteModel == null) {
                return;
            }
            String string = siteModel.getChild().getId();
            int n = siteCollectionModel.getSiteIndexById(string);
            object = HypoLineManager.INSTANCE.getRaytracer();
            ((CHypoLineRoutines56)object).episimul(bl ? 0 : 1, this.ck.getGlobalSamplerate(), (float)this.x, (float)this.y, this.simul_depth, n);
            int n2 = ((CHypoLineRoutines56)object).getTurnLayer(this.x, this.y, n);
            HypoLineManager.INSTANCE.getEpiMapDb().getEpiDepth().setTurnLayer(n2);
            this.onsetTime = bl ? siteModel.getChild().getpPick() - ((CHypoLineRoutines56)object).getPsimul()[n] - this.onsetTimeOffset : siteModel.getChild().getsPick() - ((CHypoLineRoutines56)object).getSsimul()[n] - this.onsetTimeOffset;
            for (SiteModel siteModel3 : list) {
                SiteModel siteModel4 = siteModel3.getChild();
                int n3 = siteCollectionModel.getSiteIndexById(siteModel4.getId());
                siteModel4.setpSimulPick(((CHypoLineRoutines56)object).getPsimul()[n3] + this.onsetTime + this.onsetTimeOffset);
                siteModel4.setsSimulPick(((CHypoLineRoutines56)object).getSsimul()[n3] + this.onsetTime + this.onsetTimeOffset);
            }
        }
    }

    public void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
        if (!this.isEpiCenterSet()) {
            this.onsetTime = Double.NaN;
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
                SiteModel siteModel2 = siteModel.getChild();
                siteModel2.setpSimulPick(-1.0);
                siteModel2.setsSimulPick(-1.0);
                siteModel2.updateRepaint();
            }
            this.setLatLon(Double.NaN, Double.NaN, false);
        } else {
            try {
                CoordinateUtil.AbsoluteResult absoluteResult = CoordinateUtil.convertRelativeToAbsolute((double)this.ck.getReferencePoint().getLatitude(), (double)this.ck.getReferencePoint().getLongitude(), (double)d, (double)d2);
                this.setLatLon(absoluteResult.latitude, absoluteResult.longitude, false);
            }
            catch (Exception exception) {
                LogUtil.debug(this.getClass(), (String)exception.getMessage());
            }
        }
    }

    public void updateXY() {
        CoordinateUtil.RelativeResult relativeResult = CoordinateUtil.convertAbsoluteToRelative((double)this.ck.getReferencePoint().getLatitude(), (double)this.ck.getReferencePoint().getLongitude(), (double)this.lat, (double)this.lon);
        this.x = relativeResult.xOffset;
        this.y = relativeResult.yOffset;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getOnsetTime() {
        return this.onsetTime + this.onsetTimeOffset;
    }

    public void setOnsetTime(double d) {
        this.onsetTime = d;
    }

    public double getRsdp() {
        if (this.isEpiCenterSet()) {
            return this.rsdp;
        }
        return -1.0;
    }

    public void setRsdp(double d) {
        this.rsdp = d;
    }

    public float getEpi_z() {
        return this.epi_z;
    }

    public void setEpi_z(float f) {
        this.epi_z = f;
        this.setSimul_depth(f);
    }

    public double getOnsetTimeOffset() {
        return this.onsetTimeOffset;
    }

    public void setOnsetTimeOffset(double d) {
        this.onsetTimeOffset = d;
    }

    public void updateOnsetTimeOffset(boolean bl) {
        this.onsetTimeOffset = bl ? (this.onsetTimeOffset += 1.0 / (double)this.ck.getGlobalSamplerate()) : (this.onsetTimeOffset -= 1.0 / (double)this.ck.getGlobalSamplerate());
    }

    public boolean isEpiCenterSet() {
        return !Double.isNaN(this.x) && !Double.isNaN(this.y);
    }

    public float getSimul_depth() {
        return this.simul_depth;
    }

    private void setSimul_depth(float f) {
        this.simul_depth = f;
        this.setLatLon(this.lat, this.lon, false);
    }

    protected void updateSimulation() {
        this.setLatLon(this.lat, this.lon, false);
    }
}

