/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.model.layer.Layer;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.PolyModel;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.SwingUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ccode.CHypoLineRoutines56;
import edu.geophys.hypoline.epimap.BeamModel;
import edu.geophys.hypoline.epimap.EpiCenter;
import edu.geophys.hypoline.epimap.EpiDepthView;
import edu.geophys.hypoline.epimap.EpiMapInterface;
import edu.geophys.hypoline.epimap.EpiMapView;
import edu.geophys.hypoline.epimap.HypolinesModel;
import edu.geophys.hypoline.epimap.MapPoint;
import edu.geophys.hypoline.epimap.MapStationsModel;
import edu.geophys.hypoline.epimap.PatchMapModel;
import edu.geophys.hypoline.sitecollection.SiteCollectionModel;
import edu.geophys.hypoline.ui.trace.SiteModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EpiMapDatabase {
    private EpiMapView epiMap = new EpiMapView(this, false);
    private EpiMapView epiZoom = new EpiMapView(this, true);
    private EpiDepthView epiDepth = new EpiDepthView(this);
    private Stroke spCircleStroke1 = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{15.0f}, 0.0f);
    private Stroke spCircleStroke2 = new BasicStroke(1.0f, 0, 2);
    private Stroke spCircleStroke3 = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{15.0f}, 0.0f);
    private Stroke hypolinesStroke = new BasicStroke(2.0f);
    private SiteModel activeSite = null;
    private StationsKnowledge sk = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
    private CampaignKnowledge ck = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
    private float samprate = this.ck.getGlobalSamplerate();
    private int POINTS = 400;
    private Map<SNS, Double> maxApertureDistanceMap = new HashMap<SNS, Double>();
    private float tmax = 0.0f;
    private float tdepth = 0.0f;
    private EpiCenter epiCenter = new EpiCenter();
    private Rectangle2D.Double mapBorders = null;
    private int hypolinerepaintCounter = 0;
    private int circlerepaintCounter = 0;
    private boolean showHypoLines = true;
    private boolean showCircles = true;
    private boolean showBeams = true;

    public EpiMapDatabase() {
        this.epiMap.setChildMap(this.epiZoom);
        Rectangle2D.Double double_ = this.getOptimalMapBorders();
        this.epiMap.updateLocation(double_);
        HypolinesModel hypolinesModel = new HypolinesModel();
        this.epiMap.getHypolinesPainter().setModel(hypolinesModel);
        HypolinesModel hypolinesModel2 = new HypolinesModel();
        this.epiZoom.getHypolinesPainter().setModel(hypolinesModel2);
    }

    public void initApertureDistances() {
        for (SNS sNS : this.sk.getAllActiveSNS()) {
            double d = -1.7976931348623157E308;
            for (Site site : sNS.getAllSites()) {
                for (Site site2 : sNS.getAllSites()) {
                    double d2;
                    double d3 = Math.abs(site.getXOffsetKm() - site2.getXOffsetKm());
                    double d4 = Math.sqrt(d3 * d3 + (d2 = Math.abs(site.getYOffsetKm() - site2.getYOffsetKm())) * d2);
                    if (!(d4 > d)) continue;
                    d = d4;
                }
            }
            this.maxApertureDistanceMap.put(sNS, d);
        }
    }

    public Rectangle2D.Double getOptimalMapBorders() {
        double d;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = Double.MAX_VALUE;
        double d5 = -1.7976931348623157E308;
        for (Site site : this.sk.getAllSites()) {
            if (site.getXOffsetKm() > d3) {
                d3 = site.getXOffsetKm();
            }
            if (site.getXOffsetKm() < d2) {
                d2 = site.getXOffsetKm();
            }
            if (site.getYOffsetKm() > d5) {
                d5 = site.getYOffsetKm();
            }
            if (!(site.getYOffsetKm() < d4)) continue;
            d4 = site.getYOffsetKm();
        }
        double d6 = d3 - d2;
        double d7 = d5 - d4;
        double d8 = d = d6 > d7 ? d6 : d7;
        if (d <= Double.MIN_VALUE) {
            d = 1.0;
        }
        double d9 = d / 10.0;
        this.mapBorders = new Rectangle2D.Double(d2 -= d9, -(d5 += d9), d += 2.0 * d9, d);
        return this.mapBorders;
    }

    public void setActiveStation(SiteModel siteModel) {
        this.activeSite = siteModel;
        for (EpiMapView epiMapView : new EpiMapView[]{this.epiMap, this.epiZoom}) {
            block5: for (PolyModel polyModel : ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines) {
                if (polyModel.getStation1().equals("")) continue;
                if (polyModel.getStation1().equals(siteModel.getId()) || polyModel.getStation2().equals(siteModel.getId())) {
                    polyModel.setLineColor(ThemeManager.getInstance().getTheme().getHypolineRed());
                    continue;
                }
                switch (polyModel.getType()) {
                    case PP_HYPERBOLA: {
                        polyModel.setLineColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
                        continue block5;
                    }
                    case SP_CIRCLE: {
                        polyModel.setLineColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
                        continue block5;
                    }
                }
                LogUtil.warn(this.getClass(), (String)"undefined polygon type");
                polyModel.setLineColor(Color.PINK);
            }
            epiMapView.setRenderingQuality(epiMapView.getRenderingQuality());
        }
    }

    public void paintAllStations() {
        this.paintStationsMap(this.epiMap);
        this.paintStationsMap(this.epiZoom);
        this.paintStations(this.epiDepth, true);
        this.epiMap.setRenderingQuality(this.epiMap.getRenderingQuality());
        this.epiZoom.setRenderingQuality(this.epiZoom.getRenderingQuality());
    }

    public void updateZoomWindow() {
        this.paintStationsMap(this.epiZoom);
        this.paintStations(this.epiDepth, true);
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
            SiteModel siteModel2 = siteModel.getChild();
            this.updatePPick(siteModel2, new EpiMapView[]{this.epiZoom});
            this.updateSPick(siteModel2, new EpiMapView[]{this.epiZoom});
        }
    }

    public void updatePPick(SiteModel siteModel) {
        this.updatePPick(siteModel, new EpiMapView[]{this.epiMap, this.epiZoom}, true);
    }

    public void updateSPick(SiteModel siteModel) {
        this.updateSPick(siteModel, new EpiMapView[]{this.epiMap, this.epiZoom}, true);
    }

    public void updatePPick(SiteModel siteModel, EpiMapView[] epiMapViewArray) {
        this.updatePPick(siteModel, epiMapViewArray, false);
    }

    public void updatePPick(SiteModel siteModel, EpiMapView[] epiMapViewArray, boolean bl) {
        if (!Double.isNaN(siteModel.getpPick()) || bl) {
            this.initTimes();
            for (EpiMapView epiMapView : epiMapViewArray) {
                if (this.showHypoLines) {
                    for (Object object : HypoLineManager.INSTANCE.getSites()) {
                        var10_15 = object.getChild();
                        if (((Object)((Object)var10_15)).equals((Object)siteModel)) continue;
                        LogUtil.debug(this.getClass(), (String)(siteModel.getId() + " " + var10_15.getId() + " " + siteModel.getpPick() + " " + var10_15.getpPick() + " " + (siteModel.isActiveTrace() || var10_15.isActiveTrace())));
                        this.paintHypoLines(epiMapView, siteModel.getId(), var10_15.getId(), siteModel.getpPick(), var10_15.getpPick(), siteModel.isActiveTrace() || var10_15.isActiveTrace());
                    }
                } else {
                    Object object;
                    ArrayList<SiteModel> arrayList = new ArrayList<SiteModel>();
                    object = ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines.iterator();
                    while (object.hasNext()) {
                        var10_15 = (PolyModel)object.next();
                        if (var10_15.getStation2().equals("") || var10_15.getStation1().equals("")) continue;
                        arrayList.add(var10_15);
                    }
                    ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines.removeAll(arrayList);
                }
                if (epiMapView.getMapBackground().equals((Object)EpiMapView.MAPBG.PATCHMAP)) {
                    this.updatePatchMap(epiMapView);
                } else if (epiMapView.getMapBackground().equals((Object)EpiMapView.MAPBG.RESIDUALMAP)) {
                    this.updateResidualMap(epiMapView);
                }
                epiMapView.setRenderingQuality(SwingUtil.RenderQuality.HIGH);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (PolyModel polyModel : ((HypolinesModel)this.epiMap.getHypolinesPainter().getModel()).hypolines) {
                if (polyModel.getStation1().equals("") || polyModel.getStation2().equals("")) continue;
                switch (polyModel.getValid()) {
                    case Valid: {
                        ++n;
                        break;
                    }
                    case Outside: {
                        ++n2;
                        break;
                    }
                    case Invalid: {
                        ++n3;
                        break;
                    }
                }
            }
            this.epiMap.getHlValidRect().updateValues(n, n2, n3);
        }
    }

    public void updatePBeamPick(SiteModel siteModel) {
    }

    public void updateSPick(SiteModel siteModel, EpiMapView[] epiMapViewArray) {
        this.updateSPick(siteModel, epiMapViewArray, false);
    }

    public void updateSPick(SiteModel siteModel, EpiMapView[] epiMapViewArray, boolean bl) {
        if (!Double.isNaN(siteModel.getsPick()) || bl) {
            this.initTimes();
            for (EpiMapView object2 : epiMapViewArray) {
                if (this.showCircles) {
                    this.paintCircles(object2, siteModel.getId(), siteModel.getpPick(), siteModel.getsPick(), siteModel);
                } else {
                    Iterator<PolyModel> iterator = new ArrayList();
                    for (PolyModel polyModel : ((HypolinesModel)object2.getHypolinesPainter().getModel()).hypolines) {
                        if (!polyModel.getStation2().equals("") && !polyModel.getStation1().equals("")) continue;
                        iterator.add(polyModel);
                    }
                    ((HypolinesModel)object2.getHypolinesPainter().getModel()).hypolines.removeAll((Collection<?>)((Object)iterator));
                }
                if (object2.getMapBackground().equals((Object)EpiMapView.MAPBG.PATCHMAP)) {
                    this.updatePatchMap(object2);
                } else if (object2.getMapBackground().equals((Object)EpiMapView.MAPBG.RESIDUALMAP)) {
                    this.updateResidualMap(object2);
                }
                object2.setRenderingQuality(SwingUtil.RenderQuality.HIGH);
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SiteModel siteModel2 : HypoLineManager.INSTANCE.getSites()) {
                if (Double.isNaN(siteModel2.getChild().getpPick()) || Double.isNaN(siteModel2.getChild().getsPick())) continue;
                arrayList.add(siteModel2.getChild().getId());
            }
            for (PolyModel polyModel : ((HypolinesModel)this.epiMap.getHypolinesPainter().getModel()).hypolines) {
                if (polyModel.getStation1().equals("") || !polyModel.getStation2().equals("") || !arrayList.contains(polyModel.getStation1())) continue;
                switch (polyModel.getValid()) {
                    case Valid: {
                        ++n;
                        break;
                    }
                    case Outside: {
                        ++n2;
                        break;
                    }
                    case Invalid: {
                        ++n3;
                        break;
                    }
                }
            }
            this.epiMap.getCircleValidRect().updateValues(n, n2, n3);
        }
    }

    public void updateDepth(float f) {
        if (f >= 0.0f) {
            this.epiCenter.setEpi_z(f);
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
                SiteModel siteModel2 = siteModel.getChild();
                this.updatePPick(siteModel2, new EpiMapView[]{this.epiMap, this.epiZoom});
                this.updateSPick(siteModel2, new EpiMapView[]{this.epiMap, this.epiZoom});
            }
        }
        this.updateEpiCenter();
    }

    public void reset() {
        ((HypolinesModel)this.epiMap.getHypolinesPainter().getModel()).hypolines.removeAll(((HypolinesModel)this.epiMap.getHypolinesPainter().getModel()).hypolines);
        ((HypolinesModel)this.epiZoom.getHypolinesPainter().getModel()).hypolines.removeAll(((HypolinesModel)this.epiZoom.getHypolinesPainter().getModel()).hypolines);
        this.resetEpiCenter();
    }

    public void resetEpiCenter() {
        this.epiCenter.setXY(Double.NaN, Double.NaN);
        this.updateEpiCenter();
    }

    public void updateEpiCenter() {
        for (EpiMapInterface epiMapInterface : new EpiMapInterface[]{this.epiZoom, this.epiMap, this.epiDepth}) {
            epiMapInterface.updateLocation(epiMapInterface.getMapModel());
        }
        HypoLineManager.INSTANCE.getStatusPanel().setEpicenter(this.epiCenter);
    }

    public void updateDepth() {
        this.updateDepth(this.epiCenter.getEpi_z());
    }

    public void paintStationsDepth() {
        this.paintStations(this.epiDepth, true);
    }

    public void paintStationsMap(EpiMapView epiMapView) {
        this.paintStations(epiMapView, false);
    }

    private void paintStations(EpiMapInterface epiMapInterface, boolean bl) {
        MapStationsModel mapStationsModel = new MapStationsModel();
        MapStationsModel mapStationsModel2 = new MapStationsModel();
        mapStationsModel.setPaintUnderlyingRectangle(epiMapInterface.getMapImage() != null);
        double d = HypoLineManager.INSTANCE.getLayerModelController().getCorrectedZeroElevation();
        for (SiteModel siteModel : HypoLineManager.INSTANCE.getSites()) {
            MapStationsModel.StationState stationState;
            double d2 = this.transformPointX(epiMapInterface.getMapModel(), siteModel.getXOffsetKm());
            double d3 = this.transformPointY(epiMapInterface.getMapModel(), -siteModel.getYOffsetKm());
            double d4 = this.transformPointY(epiMapInterface.getMapModelZ(), d - siteModel.getZOffsetKm());
            SiteModel siteModel2 = siteModel.getChild();
            String string = siteModel2.getId();
            Double d5 = this.maxApertureDistanceMap.get(siteModel.getSns());
            if (d5 == null) continue;
            double d6 = d5 / epiMapInterface.getMapModel().getWidth() * (double)epiMapInterface.getWidth();
            if (d6 < 50.0) {
                string = siteModel2.getSns().getCenter().getId().equals(string) ? siteModel2.getSns().getID() : "";
            }
            boolean bl2 = !siteModel.getSns().getAllSatellites().isEmpty();
            MapStationsModel.StationState stationState2 = stationState = bl2 ? MapStationsModel.StationState.BLUE : MapStationsModel.StationState.GREEN;
            if (Double.isNaN(siteModel2.getpBeamAngle()) && Double.isNaN(siteModel2.getsBeamAngle()) || bl || !this.showBeams) {
                if (!bl) {
                    mapStationsModel.set(siteModel2.getId(), string, d2, d3, stationState);
                    continue;
                }
                mapStationsModel.set(siteModel2.getId(), string, d2, d4, stationState);
                mapStationsModel2.set(siteModel2.getId(), string, d3, d4, stationState);
                continue;
            }
            BeamModel beamModel = null;
            BeamModel beamModel2 = null;
            double d7 = 5.0 * d5;
            if (d7 == 0.0) {
                d7 = 1.0;
            }
            d7 /= epiMapInterface.getMapModel().width;
            double d8 = 44.0f / this.samprate;
            if (d8 < (double)0.18f) {
                d8 = 0.18f;
            }
            double d9 = Math.atan2((d8 /= epiMapInterface.getMapModel().width) / 2.0, d7);
            if (!Double.isNaN(siteModel2.getpBeamAngle())) {
                beamModel = new BeamModel(new MapPoint(d2, d3), Math.toRadians(90.0 - siteModel2.getpBeamAngle()), d7, d8, d9);
                beamModel.setpOrSBeam(true);
                if (HypoLineManager.INSTANCE.getCurrentSitesDetail().contains((Object)siteModel2)) {
                    beamModel.setActiveBeam(true);
                }
            }
            if (!Double.isNaN(siteModel2.getsBeamAngle())) {
                beamModel2 = new BeamModel(new MapPoint(d2, d3), Math.toRadians(90.0 - siteModel2.getsBeamAngle()), d7, d8, d9);
                beamModel2.setpOrSBeam(false);
                if (HypoLineManager.INSTANCE.getCurrentSitesDetail().contains((Object)siteModel2)) {
                    beamModel2.setActiveBeam(true);
                }
            }
            mapStationsModel.set(siteModel2.getId(), string, d2, d3, beamModel, beamModel2, stationState);
        }
        epiMapInterface.getMapStationsPainter().setModel(mapStationsModel);
        epiMapInterface.getMapStationsPainter2().setModel(mapStationsModel2);
        epiMapInterface.getMapBeamPainter().setModel(mapStationsModel);
        epiMapInterface.getCursorModel().setMapStations(mapStationsModel);
    }

    public void updatePatchMap(EpiMapView epiMapView) {
        Object object;
        PatchMapModel patchMapModel = new PatchMapModel();
        double d = -1.7976931348623157E308;
        int n = patchMapModel.steps;
        double[][] dArray = new double[n][n];
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 1.0 / (double)n, 1.0 / (double)n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (PolyModel polyModel : ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines) {
            if (polyModel.getStation1().equals("") && polyModel.getStation2().equals("")) continue;
            PathIterator pathIterator = polyModel.getPath().getPathIterator(null);
            while (!pathIterator.isDone()) {
                object = new double[2];
                pathIterator.currentSegment((double[])object);
                if (object[0] != 0.0 && object[1] != 0.0) {
                    arrayList.add(object);
                }
                pathIterator.next();
            }
        }
        for (int i = 0; i < n; ++i) {
            double_.y = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = 0;
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Rectangle2D.Double double_2 = new Rectangle2D.Double(double_.x - 2.0 * double_.height, double_.y - 2.0 * double_.width, double_.height * 4.0, double_.width * 4.0);
                    double[] dArray2 = (double[])object.next();
                    if (!double_2.contains(dArray2[0], dArray2[1])) continue;
                    ++n2;
                }
                dArray[i][j] = n2;
                if ((double)n2 >= d) {
                    d = n2;
                }
                double_.y += double_.height;
            }
            double_.x += double_.width;
        }
        patchMapModel.setMaxValue(d);
        patchMapModel.setValues(dArray);
        epiMapView.getPatchmapPainter().setPatchModel(patchMapModel);
    }

    public void updateResidualMap(EpiMapView epiMapView) {
        Rectangle2D.Double double_ = epiMapView.getMapModel();
        PatchMapModel patchMapModel = new PatchMapModel();
        double[] dArray = new double[]{Double.MAX_VALUE, 0.0, 0.0};
        double d = -1.7976931348623157E308;
        int n = patchMapModel.steps;
        double[][] dArray2 = new double[n][n];
        EpiCenter epiCenter = new EpiCenter();
        epiCenter.setEpi_z(this.epiCenter.getEpi_z());
        for (int i = 0; i < n; ++i) {
            LogUtil.info(this.getClass(), (String)("Residual calculation step " + i + " of " + n));
            for (int j = 0; j < n; ++j) {
                double d2 = double_.x + (double)i / (double)n * double_.width;
                double d3 = -double_.y - (double)j / (double)n * double_.height;
                double d4 = 0.0;
                epiCenter.setXY(d2, d3);
                d4 += epiCenter.getRsdp();
                d4 = Math.log10(d4);
                if (d4 < dArray[0]) {
                    dArray[0] = d4;
                    dArray[1] = d2;
                    dArray[2] = d3;
                }
                if (d4 > d) {
                    d = d4;
                }
                dArray2[i][j] = d4;
            }
        }
        patchMapModel.setMaxValue(d);
        patchMapModel.setMinValue(dArray[0]);
        patchMapModel.setValues(dArray2);
        epiMapView.getPatchmapPainter().setPatchModel(patchMapModel);
        epiMapView.setMinResidual(dArray);
    }

    public void initTimes() {
        List list = HypoLineManager.INSTANCE.getLayerModelController().getCurrentLayerModel().getLayers();
        int n = list.size();
        float f = (float)this.epiMap.getMapModel().width;
        this.tmax = 2.4f * f / (float)((Layer)list.get(n - 1)).getVp();
        this.tdepth = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            if (f2 > (float)((Layer)list.get(n - 1)).getD() && ((Layer)list.get(n - 1)).getD() != -1.0) {
                this.tdepth += (float)((Layer)list.get(n - 1)).getD() / (float)((Layer)list.get(n - 1)).getVp();
                f2 -= (float)((Layer)list.get(n - 1)).getD();
                continue;
            }
            this.tdepth += f2 / (float)((Layer)list.get(n - 1)).getVp();
            break;
        }
        this.tmax += this.tdepth * 1.5f;
        LogUtil.debug(this.getClass(), (String)("T: " + this.tmax + " " + this.tdepth));
    }

    public void paintHypoLines(EpiMapView epiMapView, String string, String string2, double d, double d2, boolean bl) {
        Object object;
        Object object2;
        boolean bl2 = false;
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            bl2 = true;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        PolyModel polyModel = new PolyModel(0.0f, 0.0f, 1, string, string2, PolyModel.PolyType.PP_HYPERBOLA);
        if (bl2) {
            int n;
            object2 = HypoLineManager.INSTANCE.getRaytracer();
            object = HypoLineManager.INSTANCE.getSiteCollectionModel();
            int n2 = ((SiteCollectionModel)object).getSiteIndexById(string);
            int n3 = ((SiteCollectionModel)object).getSiteIndexById(string2);
            float f = ((SiteCollectionModel)object).getSiteEastingsKm()[n2];
            float f2 = -((SiteCollectionModel)object).getSiteNorthingsKm()[n2];
            int n4 = ((SiteCollectionModel)object).getSiteZClassByIndex()[n2];
            float f3 = ((SiteCollectionModel)object).getSiteEastingsKm()[n3];
            float f4 = -((SiteCollectionModel)object).getSiteNorthingsKm()[n3];
            int n5 = ((SiteCollectionModel)object).getSiteZClassByIndex()[n3];
            float[] fArray = new float[this.POINTS];
            float[] fArray2 = new float[this.POINTS];
            ((CHypoLineRoutines56)object2).setEpiz_force(this.epiCenter.getEpi_z());
            ((CHypoLineRoutines56)object2).hyperbola(f, f2, n4, f3, f4, n5, fArray, fArray2, this.POINTS, d, d2, this.tmax, this.tdepth);
            boolean bl5 = true;
            int n6 = 0;
            for (n = 0; n < fArray.length; ++n) {
                if (!this.validPoint(fArray[n], fArray2[n])) continue;
                bl4 = true;
                fArray[n] = (float)this.transformPointX(epiMapView.getMapModel(), fArray[n]);
                fArray2[n] = (float)this.transformPointY(epiMapView.getMapModel(), fArray2[n]);
                if (bl5) {
                    n6 = n;
                    bl5 = false;
                }
                if (bl3 || !(fArray[n] < 1.0f) || !(fArray2[n] < 1.0f) || !(fArray[n] > 0.0f) || !(fArray2[n] > 0.0f)) continue;
                bl3 = true;
            }
            polyModel = new PolyModel(fArray[n6], fArray2[n6], this.POINTS, string, string2, PolyModel.PolyType.PP_HYPERBOLA);
            if (bl) {
                polyModel.setLineColor(ThemeManager.getInstance().getTheme().getHypolineRed());
            } else {
                polyModel.setLineColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
            }
            polyModel.setStroke(this.hypolinesStroke);
            for (n = n6 + 1; n < this.POINTS; ++n) {
                if (!this.validPoint(fArray[n], fArray2[n])) continue;
                polyModel.lineTo(fArray[n], fArray2[n]);
            }
        }
        object2 = new ArrayList();
        for (PolyModel polyModel2 : ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines) {
            if (polyModel2.getStation1().equals(string) && polyModel2.getStation2().equals(string2) || polyModel2.getStation1().equals(string2) && polyModel2.getStation2().equals(string)) {
                object2.add(polyModel2);
            }
            if (this.activeSite == null || polyModel2.getStation1().equals(this.activeSite.getId()) || polyModel2.getStation2().equals(this.activeSite.getId())) continue;
            polyModel2.setLineColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
        }
        ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines.removeAll((Collection<?>)object2);
        if (bl2) {
            object = bl4 ? (bl3 ? PolyModel.ValidStatus.Valid : PolyModel.ValidStatus.Outside) : PolyModel.ValidStatus.Invalid;
            polyModel.setValid((PolyModel.ValidStatus)object);
        }
        ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines.add(polyModel);
    }

    public void paintCircles(EpiMapView epiMapView, String string, double d, double d2, SiteModel siteModel) {
        Object object;
        Object object2;
        boolean bl = false;
        float f = 2.0f / this.samprate;
        boolean bl2 = false;
        if (d <= 0.0 || d2 <= 0.0) {
            bl2 = true;
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2) && d2 - (double)f > d) {
            bl = true;
        }
        PolyModel polyModel = new PolyModel(0.0f, 0.0f, 1, string, "", PolyModel.PolyType.SP_CIRCLE);
        PolyModel polyModel2 = new PolyModel(0.0f, 0.0f, 1, string, "", PolyModel.PolyType.SP_CIRCLE);
        PolyModel polyModel3 = new PolyModel(0.0f, 0.0f, 1, string, "", PolyModel.PolyType.SP_CIRCLE);
        boolean bl3 = true;
        if (bl) {
            int n;
            object2 = HypoLineManager.INSTANCE.getRaytracer();
            object = HypoLineManager.INSTANCE.getSiteCollectionModel();
            int n2 = ((SiteCollectionModel)object).getSiteIndexById(string);
            float f2 = ((SiteCollectionModel)object).getSiteEastingsKm()[n2];
            float f3 = -((SiteCollectionModel)object).getSiteNorthingsKm()[n2];
            int n3 = ((SiteCollectionModel)object).getSiteZClassByIndex()[n2];
            float[] fArray = new float[this.POINTS];
            float[] fArray2 = new float[this.POINTS];
            float[] fArray3 = new float[this.POINTS];
            float[] fArray4 = new float[this.POINTS];
            float[] fArray5 = new float[this.POINTS];
            float[] fArray6 = new float[this.POINTS];
            ((CHypoLineRoutines56)object2).setEpiz_force(this.epiCenter.getEpi_z());
            ((CHypoLineRoutines56)object2).calcRadius(n2, d, d2 - (double)f, this.samprate);
            ((CHypoLineRoutines56)object2).circle(f2, f3, fArray, fArray2, this.POINTS, ((CHypoLineRoutines56)object2).getSPradius());
            ((CHypoLineRoutines56)object2).calcRadius(n2, d, d2, this.samprate);
            ((CHypoLineRoutines56)object2).circle(f2, f3, fArray3, fArray4, this.POINTS, ((CHypoLineRoutines56)object2).getSPradius());
            siteModel.setOnsetTimeSP(((CHypoLineRoutines56)object2).getSPtd());
            siteModel.setTstpDist(((CHypoLineRoutines56)object2).getSPradius());
            ((CHypoLineRoutines56)object2).calcRadius(n2, d, d2 + (double)f, this.samprate);
            ((CHypoLineRoutines56)object2).circle(f2, f3, fArray5, fArray6, this.POINTS, ((CHypoLineRoutines56)object2).getSPradius());
            boolean bl4 = true;
            int n4 = 0;
            boolean bl5 = true;
            int n5 = 0;
            boolean bl6 = true;
            int n6 = 0;
            for (n = 0; n < fArray.length; ++n) {
                if (this.validPoint(fArray[n], fArray2[n])) {
                    fArray[n] = (float)this.transformPointX(epiMapView.getMapModel(), fArray[n]);
                    fArray2[n] = (float)this.transformPointY(epiMapView.getMapModel(), fArray2[n]);
                    if (bl3 && (fArray[n] > 1.0f || fArray2[n] > 1.0f || fArray[n] < 0.0f || fArray2[n] < 0.0f)) {
                        bl3 = false;
                    }
                    if (bl4) {
                        n4 = n;
                        bl4 = false;
                    }
                }
                if (this.validPoint(fArray3[n], fArray4[n])) {
                    fArray3[n] = (float)this.transformPointX(epiMapView.getMapModel(), fArray3[n]);
                    fArray4[n] = (float)this.transformPointY(epiMapView.getMapModel(), fArray4[n]);
                    if (bl5) {
                        n5 = n;
                        bl5 = false;
                    }
                }
                if (!this.validPoint(fArray5[n], fArray6[n])) continue;
                fArray5[n] = (float)this.transformPointX(epiMapView.getMapModel(), fArray5[n]);
                fArray6[n] = (float)this.transformPointY(epiMapView.getMapModel(), fArray6[n]);
                if (!bl6) continue;
                n6 = n;
                bl6 = false;
            }
            polyModel = new PolyModel(fArray[n4], fArray2[n4], this.POINTS, string, "", PolyModel.PolyType.SP_CIRCLE);
            polyModel2 = new PolyModel(fArray3[n4], fArray4[n4], this.POINTS, string, "", PolyModel.PolyType.SP_CIRCLE);
            polyModel3 = new PolyModel(fArray5[n4], fArray6[n4], this.POINTS, string, "", PolyModel.PolyType.SP_CIRCLE);
            if (siteModel.isActiveTrace()) {
                polyModel.setLineColor(ThemeManager.getInstance().getTheme().getHypolineRed());
                polyModel2.setLineColor(ThemeManager.getInstance().getTheme().getHypolineRed());
                polyModel3.setLineColor(ThemeManager.getInstance().getTheme().getHypolineRed());
            } else {
                polyModel.setLineColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
                polyModel2.setLineColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
                polyModel3.setLineColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
            }
            polyModel.setStroke(this.spCircleStroke1);
            for (n = n4 + 1; n < this.POINTS; ++n) {
                if (!this.validPoint(fArray[n], fArray2[n])) continue;
                polyModel.lineTo(fArray[n], fArray2[n]);
            }
            polyModel.closePath();
            polyModel2.setStroke(this.spCircleStroke2);
            for (n = n5 + 1; n < this.POINTS; ++n) {
                if (!this.validPoint(fArray3[n], fArray4[n])) continue;
                polyModel2.lineTo(fArray3[n], fArray4[n]);
            }
            polyModel2.closePath();
            polyModel3.setStroke(this.spCircleStroke3);
            for (n = n6 + 1; n < this.POINTS; ++n) {
                if (!this.validPoint(fArray5[n], fArray6[n])) continue;
                polyModel3.lineTo(fArray5[n], fArray6[n]);
            }
            polyModel3.closePath();
        }
        object2 = new ArrayList();
        block8: for (PolyModel polyModel4 : ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines) {
            if (polyModel4.getStation1().equals(string) && polyModel4.getStation2().equals("") || polyModel4.getStation1().equals("") && polyModel4.getStation2().equals(string)) {
                object2.add(polyModel4);
            }
            if (this.activeSite == null || polyModel4.getStation1().equals(this.activeSite.getId()) || polyModel4.getStation2().equals(this.activeSite.getId())) continue;
            switch (polyModel4.getType()) {
                case PP_HYPERBOLA: {
                    polyModel4.setLineColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
                    continue block8;
                }
                case SP_CIRCLE: {
                    polyModel4.setLineColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
                    continue block8;
                }
            }
            polyModel4.setLineColor(Color.PINK);
        }
        ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines.removeAll((Collection<?>)object2);
        if (!bl2) {
            object = bl ? (bl3 ? PolyModel.ValidStatus.Valid : PolyModel.ValidStatus.Outside) : PolyModel.ValidStatus.Invalid;
            polyModel.setValid((PolyModel.ValidStatus)object);
            polyModel2.setValid((PolyModel.ValidStatus)object);
            polyModel3.setValid((PolyModel.ValidStatus)object);
        }
        ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines.add(polyModel);
        ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines.add(polyModel2);
        ((HypolinesModel)epiMapView.getHypolinesPainter().getModel()).hypolines.add(polyModel3);
    }

    public void updateSimulation() {
        this.epiCenter.updateSimulation();
    }

    private boolean validPoint(double d, double d2) {
        return Math.abs(d) > 0.001 || Math.abs(d2) > 0.001;
    }

    public double transformPointX(Rectangle2D.Double double_, double d) {
        return (d - double_.x) / double_.width;
    }

    public double transformPointY(Rectangle2D.Double double_, double d) {
        return (d - double_.y) / double_.height;
    }

    public EpiMapView getEpiMap() {
        return this.epiMap;
    }

    public void setEpiMap(EpiMapView epiMapView) {
        this.epiMap = epiMapView;
    }

    public void setEpiZoom(EpiMapView epiMapView) {
        this.epiZoom = epiMapView;
    }

    public EpiMapView getEpiZoom() {
        return this.epiZoom;
    }

    public EpiDepthView getEpiDepth() {
        return this.epiDepth;
    }

    public void setEpiDepth(EpiDepthView epiDepthView) {
        this.epiDepth = epiDepthView;
    }

    public EpiCenter getEpiCenter() {
        return this.epiCenter;
    }

    public void setEpiCenter(EpiCenter epiCenter) {
        this.epiCenter = epiCenter;
    }

    public SiteModel getActiveSite() {
        return this.activeSite;
    }

    public void setActiveSite(SiteModel siteModel) {
        this.activeSite = siteModel;
    }

    public Map<SNS, Double> getMaxApertureDistanceMap() {
        return this.maxApertureDistanceMap;
    }

    public void setMaxApertureDistanceMap(Map<SNS, Double> map) {
        this.maxApertureDistanceMap = map;
    }

    public boolean isShowHypoLines() {
        return this.showHypoLines;
    }

    public void setShowHypoLines(boolean bl) {
        this.showHypoLines = bl;
    }

    public boolean isShowCircles() {
        return this.showCircles;
    }

    public void setShowCircles(boolean bl) {
        this.showCircles = bl;
    }

    public boolean isShowBeams() {
        return this.showBeams;
    }

    public void setShowBeams(boolean bl) {
        this.showBeams = bl;
    }
}

