/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.util.SwingUtil;
import edu.geophys.hypoline.epimap.EpiMapView;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;

public class EpiMapMouseAdapter
implements MouseListener,
MouseMotionListener {
    private int startDragX = 0;
    private int startDragY = 0;
    private EpiMapView map;
    private boolean dragged = false;

    public EpiMapMouseAdapter(EpiMapView epiMapView) {
        this.map = epiMapView;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.dragged) {
            return;
        }
        this.moveMap(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.map.getMapSquareSize();
        double d = SwingUtil.absolute2Relative((int)n, (int)mouseEvent.getX());
        double d2 = SwingUtil.absolute2Relative((int)n, (int)mouseEvent.getY());
        Rectangle2D.Double double_ = this.map.getZoomModel();
        if (mouseEvent.getButton() == 1) {
            double_.x = d;
            double_.y = d2;
        } else if (mouseEvent.getButton() == 3) {
            double_.height = double_.width = Math.max(Math.abs(d - double_.x), Math.abs(d2 - double_.y));
        }
        this.map.zoomModelChanged();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        this.dragged = true;
        this.startDragX = mouseEvent.getX();
        this.startDragY = mouseEvent.getY();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.dragged) {
            return;
        }
        this.dragged = false;
        this.moveMap(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void moveMap(MouseEvent mouseEvent) {
        double d = mouseEvent.getX() - this.startDragX;
        double d2 = mouseEvent.getY() - this.startDragY;
        this.startDragX = mouseEvent.getX();
        this.startDragY = mouseEvent.getY();
        Rectangle2D.Double double_ = this.map.getMapModel();
        d = d / (double)this.map.getWidth() * double_.width;
        d2 = d2 / (double)this.map.getHeight() * double_.height;
        this.map.updateLocation(new Rectangle2D.Double(double_.x - d, double_.y - d2, double_.width, double_.height));
        this.map.newLocation();
    }
}

