/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ColorProvider;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.PolyModel;
import edu.geophys.commons.ui.PolyPainter;
import edu.geophys.commons.ui.map.DetectionThresholdCalculation;
import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.FileUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.ScaleCalc;
import edu.geophys.commons.util.SwingUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.epimap.EpiMapDatabase;
import edu.geophys.hypoline.epimap.EpiMapInterface;
import edu.geophys.hypoline.epimap.EpiMapMouseAdapter;
import edu.geophys.hypoline.epimap.HypolinesPainter;
import edu.geophys.hypoline.epimap.JMapScalebar;
import edu.geophys.hypoline.epimap.MapCirclePainter;
import edu.geophys.hypoline.epimap.MapCursorModel;
import edu.geophys.hypoline.epimap.MapCursorPainter;
import edu.geophys.hypoline.epimap.MapPoint;
import edu.geophys.hypoline.epimap.MapZoomFramePainter;
import edu.geophys.hypoline.epimap.PatchmapPainter;
import edu.geophys.hypoline.epimap.ValidRectanglePainter;
import edu.geophys.hypoline.protocol.ProtEntry;
import edu.geophys.hypoline.ui.Legend;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import layout.TableLayout;

public class EpiMapView
extends EpiMapInterface {
    private static final long serialVersionUID = 1L;
    private final JMapScalebar mapScalebar = new JMapScalebar();
    private final PatchmapPainter patchmapPainter = new PatchmapPainter();
    private final HypolinesPainter hypolinesPainter = new HypolinesPainter();
    private final List<MapCirclePainter> allMapCirclePainters = new ArrayList<MapCirclePainter>();
    private final MapCursorPainter mapCursorMePainter;
    private final MapZoomFramePainter mapZoomFramePainter = new MapZoomFramePainter();
    private boolean showAllEpiCenters = false;
    private final ValidRectanglePainter hlValidRect = new ValidRectanglePainter(true);
    private final ValidRectanglePainter circleValidRect = new ValidRectanglePainter(false);
    private boolean registerErrorPolygon = false;
    private PolyModel errorPolygon = null;
    private int innerPadding = 5;
    private Font defaultFont = new Font("Lucida", 0, 11);
    private String captionMapLogoText = "EpiMap";
    private String captionZoomLogoText = "EpiZoom";
    private String captionMeFormat = "recti %.4f";
    private EpiMapView childMap;
    private EpiMapView thisMap;
    private EpiMapDatabase epiMapDatabase;
    private boolean drawPoly = true;
    private boolean drawBeams = true;
    private double[] minResidual;
    public MAPBG mapBackground = MAPBG.NONE;
    private DetectionThresholdCalculation detthres = null;
    private BufferedImage bi = null;
    private boolean xyOrLatLon = false;
    private boolean isZoomMap = false;
    private SwingUtil.RenderQuality renderingQuality = SwingUtil.RenderQuality.MEDIUM;
    private final MapCursorModel cursorMeModel = new MapCursorModel(Double.NaN, Double.NaN);
    private final Rectangle2D.Double zoomModel = new Rectangle2D.Double(0.4, 0.4, 0.2, 0.2);
    private final EpiMapMouseAdapter normalMouseListener = new EpiMapMouseAdapter(this);
    private final MouseWheelListener mouseWheel = new MouseWheelListener(){

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation();
            if (n < 0) {
                EpiMapView.this.zoom(false, mouseWheelEvent.getPoint());
            } else {
                EpiMapView.this.zoom(true, mouseWheelEvent.getPoint());
            }
        }
    };
    private final MouseListener zoomMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                if (!EpiMapView.this.registerErrorPolygon) {
                    int n = EpiMapView.this.getMapSquareSize();
                    EpiMapView.this.cursorModel.setAbsoluteLocation(mouseEvent.getPoint(), n, n);
                    EpiMapView.this.cursorModelChanged();
                } else {
                    MapPoint mapPoint = new MapPoint();
                    mapPoint.setAbsoluteLocation(mouseEvent.getPoint(), EpiMapView.this.getMapSquareSize(), EpiMapView.this.getMapSquareSize());
                    if (EpiMapView.this.errorPolygon == null) {
                        EpiMapView.this.errorPolygon = new PolyModel((float)mapPoint.getX(), (float)mapPoint.getY(), 400, "ErrorPolygon", "", PolyModel.PolyType.OTHER);
                    } else {
                        EpiMapView.this.errorPolygon.lineTo((float)mapPoint.getX(), (float)mapPoint.getY());
                    }
                    EpiMapView.this.setRenderingQuality(SwingUtil.RenderQuality.HIGH);
                }
            } else if (mouseEvent.getButton() == 3) {
                if (!EpiMapView.this.registerErrorPolygon) {
                    EpiMapView.this.epiMapDatabase.resetEpiCenter();
                } else {
                    EpiMapView.this.registerErrorPolygon = false;
                    EpiMapView.this.errorPolygon.closePath();
                    EpiMapView.this.setRenderingQuality(SwingUtil.RenderQuality.HIGH);
                }
            }
        }
    };
    private final KeyListener zoomKeyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    if (keyEvent.isControlDown()) {
                        EpiMapView.this.epiMapDatabase.getEpiCenter().updateOnsetTimeOffset(false);
                        break;
                    }
                    EpiMapView.this.cursorModel.x -= 0.001;
                    break;
                }
                case 39: {
                    if (keyEvent.isControlDown()) {
                        EpiMapView.this.epiMapDatabase.getEpiCenter().updateOnsetTimeOffset(true);
                        break;
                    }
                    EpiMapView.this.cursorModel.x += 0.001;
                    break;
                }
                case 38: {
                    EpiMapView.this.cursorModel.y -= 0.001;
                    break;
                }
                case 40: {
                    EpiMapView.this.cursorModel.y += 0.001;
                    break;
                }
                case 88: {
                    EpiMapView.this.xyOrLatLon = !EpiMapView.this.xyOrLatLon;
                    break;
                }
                case 72: {
                    EpiMapView.this.epiMapDatabase.setShowHypoLines(!EpiMapView.this.epiMapDatabase.isShowHypoLines());
                    EpiMapView.this.epiMapDatabase.updateDepth();
                    break;
                }
                case 67: {
                    EpiMapView.this.epiMapDatabase.setShowCircles(!EpiMapView.this.epiMapDatabase.isShowCircles());
                    EpiMapView.this.epiMapDatabase.updateDepth();
                    break;
                }
                case 83: {
                    EpiMapView.this.epiMapDatabase.setShowBeams(!EpiMapView.this.epiMapDatabase.isShowBeams());
                    EpiMapView.this.epiMapDatabase.paintAllStations();
                    break;
                }
                case 70: {
                    HypoLineManager.INSTANCE.getHlApp().getMainFrame().getFirst().switchPopoutStatus();
                    break;
                }
                case 80: {
                    if (EpiMapView.this.getMapBackground().equals((Object)MAPBG.PATCHMAP)) {
                        EpiMapView.this.setMapBackground(MAPBG.NONE);
                        break;
                    }
                    EpiMapView.this.setMapBackground(MAPBG.PATCHMAP);
                    break;
                }
                case 79: {
                    FileUtil.printComponent((JComponent)((Object)EpiMapView.this.epiMapDatabase.getEpiZoom()), (String)(DateTimeUtil.formatDateTimeOnlynumbers((long)new Date().getTime()) + "-epizoom.png"), (boolean)true, (int)2048, (int)2048);
                    break;
                }
                case 73: {
                    EpiMapView.this.showEpiCenterInputSelection();
                    break;
                }
                case 65: {
                    if (!EpiMapView.this.showAllEpiCenters) {
                        EpiMapView.this.allMapCirclePainters.clear();
                        HypoLineManager.INSTANCE.getProtFileManager().load();
                        CampaignKnowledge campaignKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
                        for (ProtEntry protEntry : HypoLineManager.INSTANCE.getProtFileManager().getProtEntries()) {
                            Object object;
                            double d = Double.NaN;
                            double d2 = Double.NaN;
                            try {
                                object = CoordinateUtil.convertAbsoluteToRelative((double)campaignKnowledge.getReferencePoint().getLatitude(), (double)campaignKnowledge.getReferencePoint().getLongitude(), (double)protEntry.getHypoX().getLat(), (double)protEntry.getHypoX().getLon());
                                d = object.xOffset;
                                d2 = object.yOffset;
                            }
                            catch (Exception exception) {
                                LogUtil.error(this.getClass(), (String)("Could not calculate epicenter for prot entry no. " + protEntry.getEntry() + " " + DateTimeUtil.formatDateTimeISO((long)protEntry.getDate()) + " " + protEntry.getHypoX().getLat() + " " + protEntry.getHypoX().getLon()));
                            }
                            if (Double.isNaN(d) || Double.isNaN(d2)) continue;
                            object = ThemeManager.getInstance().getTheme().getPlotForegroundColor();
                            MapCirclePainter mapCirclePainter = new MapCirclePainter((Color)object);
                            mapCirclePainter.setXrel(d);
                            mapCirclePainter.setYrel(d2);
                            mapCirclePainter.setMag(protEntry.getHypoX().getMagnitude());
                            mapCirclePainter.updateValues(EpiMapView.this.mapModel);
                            EpiMapView.this.allMapCirclePainters.add(mapCirclePainter);
                        }
                    } else {
                        EpiMapView.this.allMapCirclePainters.clear();
                    }
                    EpiMapView.this.showAllEpiCenters = !EpiMapView.this.showAllEpiCenters;
                    break;
                }
                case 112: {
                    Legend.legendf1(Legend.WindowName.EPIZOOM);
                    break;
                }
                default: {
                    return;
                }
            }
            EpiMapView.this.cursorModelChanged();
        }
    };
    private final KeyListener normalKeyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    EpiMapView.this.zoomModel.x -= 0.001;
                    break;
                }
                case 39: {
                    EpiMapView.this.zoomModel.x += 0.001;
                    break;
                }
                case 38: {
                    EpiMapView.this.zoomModel.y -= 0.001;
                    break;
                }
                case 40: {
                    EpiMapView.this.zoomModel.y += 0.001;
                    break;
                }
                case 88: {
                    EpiMapView.this.centerZoomModel();
                    break;
                }
                case 90: {
                    EpiMapView.this.zoomModel.width /= 2.0;
                    EpiMapView.this.zoomModel.height /= 2.0;
                    EpiMapView.this.zoomModel.x += EpiMapView.this.zoomModel.width / 2.0;
                    EpiMapView.this.zoomModel.y += EpiMapView.this.zoomModel.height / 2.0;
                    break;
                }
                case 85: {
                    EpiMapView.this.zoomModel.x -= EpiMapView.this.zoomModel.width / 2.0;
                    EpiMapView.this.zoomModel.y -= EpiMapView.this.zoomModel.height / 2.0;
                    EpiMapView.this.zoomModel.width *= 2.0;
                    EpiMapView.this.zoomModel.height *= 2.0;
                    break;
                }
                case 72: {
                    EpiMapView.this.epiMapDatabase.setShowHypoLines(!EpiMapView.this.epiMapDatabase.isShowHypoLines());
                    EpiMapView.this.epiMapDatabase.updateDepth();
                    break;
                }
                case 67: {
                    EpiMapView.this.epiMapDatabase.setShowCircles(!EpiMapView.this.epiMapDatabase.isShowCircles());
                    EpiMapView.this.epiMapDatabase.updateDepth();
                    break;
                }
                case 83: {
                    EpiMapView.this.epiMapDatabase.setShowBeams(!EpiMapView.this.epiMapDatabase.isShowBeams());
                    EpiMapView.this.epiMapDatabase.paintAllStations();
                    break;
                }
                case 112: {
                    Legend.legendf1(Legend.WindowName.EPIMAP);
                    break;
                }
                default: {
                    return;
                }
            }
            EpiMapView.this.zoomModelChanged();
        }
    };
    int repaintCount = 0;

    public void zoomModelChanged() {
        this.setRenderingQuality(this.getRenderingQuality());
        if (this.childMap != null) {
            this.updateChildMapLocation();
            this.epiMapDatabase.updateZoomWindow();
        }
    }

    public void cursorModelChanged() {
        int n = this.getMapSquareSize();
        Rectangle rectangle = this.mapCursorPainter.getPaintingArea(this.getX(), this.getY(), n, n);
        LogUtil.debug(((Object)((Object)this)).getClass(), (String)(this.cursorModel.getX() + " " + this.cursorModel.getY() + " " + this.mapModel.x + " " + this.mapModel.width + " " + this.mapModel.y + " " + this.mapModel.height));
        this.epiMapDatabase.getEpiCenter().setXY(this.cursorModel.getX() * this.mapModel.width + this.mapModel.x, -(this.cursorModel.getY() * this.mapModel.height + this.mapModel.y));
        this.repaint(this.mapCursorPainter.getPaintingArea(this.getX(), this.getY(), n, n));
        this.repaint(rectangle);
        for (MapCirclePainter mapCirclePainter : this.allMapCirclePainters) {
            Rectangle rectangle2 = this.mapCursorPainter.getPaintingArea(this.getX(), this.getY(), n, n);
            this.repaint(mapCirclePainter.getPaintingArea(this.getX(), this.getY(), n, n));
            this.repaint(rectangle2);
        }
        this.setRenderingQuality(SwingUtil.RenderQuality.HIGH);
        if (this.childMap == null) {
            this.epiMapDatabase.getEpiMap().updateLocation(this.epiMapDatabase.getEpiMap().getMapModel());
        }
        HypoLineManager.INSTANCE.getStatusPanel().setEpicenter(this.epiMapDatabase.getEpiCenter());
    }

    public EpiMapView(EpiMapDatabase epiMapDatabase, boolean bl) {
        this.mapCursorMePainter = new MapCursorPainter(new ColorProvider(){

            public Color get() {
                return ThemeManager.getInstance().getTheme().getMEColor();
            }
        });
        this.isZoomMap = bl;
        this.epiMapDatabase = epiMapDatabase;
        this.thisMap = this;
        this.init();
    }

    public void centerZoomModel() {
        this.zoomModel.x = this.epiMapDatabase.transformPointX(this.mapModel, this.epiMapDatabase.getEpiCenter().getX()) - this.zoomModel.width / 2.0;
        this.zoomModel.y = this.epiMapDatabase.transformPointY(this.mapModel, -this.epiMapDatabase.getEpiCenter().getY()) - this.zoomModel.height / 2.0;
    }

    public void zoom(boolean bl) {
        double d = this.mapModel.width;
        double d2 = this.mapModel.height;
        if (bl) {
            this.updateLocation(new Rectangle2D.Double(this.mapModel.x - d / 2.0, this.mapModel.y - d2 / 2.0, d * 2.0, d2 * 2.0));
        } else {
            this.updateLocation(new Rectangle2D.Double(this.mapModel.x + d / 4.0, this.mapModel.y + d2 / 4.0, d / 2.0, d2 / 2.0));
        }
        this.newLocation();
    }

    public void zoom(boolean bl, Point point) {
        double d = this.mapModel.width;
        double d2 = this.mapModel.height;
        double d3 = this.mapModel.x;
        double d4 = this.mapModel.y;
        double d5 = point.getX() * d / (double)this.getWidth();
        double d6 = point.getY() * d2 / (double)this.getHeight();
        double d7 = bl ? d * 2.0 : d / 2.0;
        double d8 = bl ? d * 2.0 : d / 2.0;
        double d9 = 1.0 - d7 / d;
        double d10 = 1.0 - d8 / d2;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3 + d9 * d5, d4 + d10 * d6, d7, d8);
        this.updateLocation(double_);
        this.newLocation();
    }

    public void newLocation() {
        this.epiMapDatabase.paintStationsMap(this.thisMap);
        this.epiMapDatabase.paintStationsMap(this.childMap);
        this.epiMapDatabase.paintStationsDepth();
        this.epiMapDatabase.updateDepth(this.epiMapDatabase.getEpiCenter().getEpi_z());
        this.setRenderingQuality(this.getRenderingQuality());
        this.childMap.setRenderingQuality(this.childMap.getRenderingQuality());
    }

    private void init() {
        this.setLayout(null);
        this.setFocusable(true);
        this.setOpaque(true);
        this.setFont(this.defaultFont);
        this.setZoomMap(this.isZoomMap);
        this.setRenderingQuality(SwingUtil.RenderQuality.HIGH);
        this.mapCursorPainter.setModel(this.cursorModel);
        this.mapCursorMePainter.setModel(this.cursorMeModel);
        this.mapZoomFramePainter.setModel(this.zoomModel);
        this.add(this.hlValidRect);
        this.add(this.circleValidRect);
        this.mapScalebar.setName("mapScalebar");
        this.mapScalebar.setFont(this.getFont());
        if (!this.isZoomMap) {
            this.mapScalebar.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    LogUtil.info(this.getClass(), (String)"change scale");
                    if (mouseEvent.getButton() == 3) {
                        EpiMapView.this.zoom(true);
                    } else if (mouseEvent.getButton() == 1) {
                        EpiMapView.this.zoom(false);
                    }
                }
            });
        }
        this.add(this.mapScalebar);
        this.hypolinesPainter.setUseBackBuffer(true);
    }

    protected void paintComponent(Graphics graphics) {
        LogUtil.debug(((Object)((Object)this)).getClass(), (String)("Epimap repaint: " + this.isZoomMap() + " " + this.repaintCount++));
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.doCustomPainting(graphics2D);
    }

    private void doCustomPainting(Graphics2D graphics2D) {
        Object object;
        int n = this.getMapSquareSize();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getLeading() + fontMetrics.getAscent() - fontMetrics.getDescent();
        if (this.getMapBackground().equals((Object)MAPBG.PATCHMAP) || this.getMapBackground().equals((Object)MAPBG.RESIDUALMAP)) {
            this.patchmapPainter.paint(graphics2D, 0, 0, n, n);
        } else if (this.isOpaque()) {
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getMapBackgroundColor());
            graphics2D.fill(graphics2D.getClip());
            graphics2D.setColor(this.getForeground());
        }
        if (this.bi != null) {
            graphics2D.drawImage(this.bi, null, 0, 0);
        }
        if (this.mapImage != null && this.mapImage.getImage() != null) {
            graphics2D.drawImage(this.mapImage.getImage(), this.mapImage.getxImgOffset(), this.mapImage.getyImgOffset(), this.mapImage.getNewWidth(), this.mapImage.getNewHeight(), (ImageObserver)((Object)this));
            object = graphics2D.getComposite();
            graphics2D.setColor(Color.WHITE);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setComposite((Composite)object);
        }
        this.mapStationsPainter.paint(graphics2D, 0, 0, n, n);
        if (this.drawBeams) {
            this.mapBeamPainter.paint(graphics2D, 0, 0, n, n);
        }
        if (this.drawPoly) {
            this.hypolinesPainter.paint(graphics2D, 0, 0, n, n);
            if (this.errorPolygon != null) {
                object = new PolyPainter();
                object.paint(graphics2D, 0, 0, n, n, (Object)this.errorPolygon);
            }
        }
        this.mapCursorPainter.paint(graphics2D, 0, 0, n, n);
        for (MapCirclePainter object2 : this.allMapCirclePainters) {
            object2.paint(graphics2D, 0, 0, n, n);
        }
        if (HypoLineManager.INSTANCE.getMasterEventManager().isInitialized() && !Double.isNaN(this.cursorMeModel.x) && !Double.isNaN(this.cursorMeModel.y)) {
            this.mapCursorMePainter.paint(graphics2D, 0, 0, n, n);
            for (double[] dArray : HypoLineManager.INSTANCE.getMasterEventManager().getMasterEventVectors()) {
                graphics2D.drawLine(this.cursorMeModel.getAbsoluteX(n), this.cursorMeModel.getAbsoluteY(n), (int)((double)this.cursorMeModel.getAbsoluteX(n) + dArray[0] / this.mapModel.width * (double)n), (int)((double)this.cursorMeModel.getAbsoluteY(n) - dArray[1] / this.mapModel.height * (double)n));
            }
            if (!this.isZoomMap) {
                object = String.format(this.captionMeFormat, Float.valueOf(HypoLineManager.INSTANCE.getMasterEventManager().getRecti()));
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getMEColor());
                graphics2D.drawString((String)object, (int)((double)this.getWidth() / 2.0) - (int)(fontMetrics.getStringBounds((String)object, graphics2D).getWidth() / 2.0), this.getHeight() - this.innerPadding);
            }
        }
        if (!this.isZoomMap) {
            this.mapZoomFramePainter.paint(graphics2D, 0, 0, n, n);
        }
        double d = ScaleCalc.mapScale((double)(this.mapModel.width / 5.0));
        this.mapScalebar.setBarLengthAndCaption(d / this.mapModel.width * (double)n, d);
        Dimension dimension = this.mapScalebar.getPreferredSize();
        this.mapScalebar.setBounds(this.innerPadding, this.getHeight() - dimension.height - this.innerPadding, dimension.width, dimension.height);
        Dimension dimension2 = this.hlValidRect.getPreferredSize();
        this.hlValidRect.setBounds(this.getWidth() - this.innerPadding - dimension2.width, this.innerPadding, dimension2.width, dimension2.height);
        Dimension dimension3 = this.circleValidRect.getPreferredSize();
        this.circleValidRect.setBounds(this.getWidth() - this.innerPadding - dimension3.width, this.innerPadding + dimension2.height * 2, dimension3.width, dimension3.height);
        SwingUtil.setRenderingQuality((Graphics2D)graphics2D, (SwingUtil.RenderQuality)this.renderingQuality);
        graphics2D.setColor(this.getForeground());
        graphics2D.drawString(this.isZoomMap ? this.captionZoomLogoText : this.captionMapLogoText, this.innerPadding, this.innerPadding + n2);
    }

    public final boolean isZoomMap() {
        return this.isZoomMap;
    }

    public final void setZoomMap(boolean bl) {
        this.isZoomMap = bl;
        this.removeMouseListener(!bl ? this.zoomMouseListener : this.normalMouseListener);
        this.addMouseListener(bl ? this.zoomMouseListener : this.normalMouseListener);
        if (!bl) {
            this.removeMouseMotionListener(this.normalMouseListener);
            this.removeMouseWheelListener(this.mouseWheel);
            this.addMouseMotionListener(this.normalMouseListener);
            this.addMouseWheelListener(this.mouseWheel);
        }
        this.removeKeyListener(!bl ? this.zoomKeyListener : this.normalKeyListener);
        this.addKeyListener(bl ? this.zoomKeyListener : this.normalKeyListener);
        this.repaint();
    }

    public final SwingUtil.RenderQuality getRenderingQuality() {
        return this.renderingQuality;
    }

    @Override
    public final void updateLocation(Rectangle2D.Double double_) {
        if (!this.isZoomMap && (double_.getWidth() < 0.1 || double_.getWidth() > 10000.0)) {
            LogUtil.warn(((Object)((Object)this)).getClass(), (String)"Zoom limit reached");
            return;
        }
        this.mapModel = double_;
        if (this.childMap != null) {
            this.updateChildMapLocation();
        }
        this.cursorModel.x = (this.epiMapDatabase.getEpiCenter().getX() - double_.x) / double_.width;
        this.cursorModel.y = (-this.epiMapDatabase.getEpiCenter().getY() - double_.y) / double_.height;
        for (MapCirclePainter mapCirclePainter : this.allMapCirclePainters) {
            mapCirclePainter.updateValues(double_);
        }
        if (HypoLineManager.INSTANCE != null && HypoLineManager.INSTANCE.getMasterEventManager().isInitialized()) {
            double d = HypoLineManager.INSTANCE.getMasterEventManager().getEpixme();
            double d2 = HypoLineManager.INSTANCE.getMasterEventManager().getEpiyme();
            this.cursorMeModel.x = (d - double_.x) / double_.width;
            this.cursorMeModel.y = (-d2 - double_.y) / double_.height;
        }
        if (this.mapImage != null && this.mapImage.getImage() != null) {
            this.mapImage.update((double)this.getMapSquareSize() / double_.width, -double_.x * (double)this.getMapSquareSize() / double_.width, double_.y * (double)this.getMapSquareSize() / double_.height + (double)this.getMapSquareSize(), this.getMapSquareSize());
        }
        this.bi = this.detthres != null ? this.detthres.calcDetectionThresholdImage(this.getMapSquareSize(), this.getMapSquareSize(), (double)this.getMapSquareSize() / double_.width, -double_.x * (double)this.getMapSquareSize() / double_.width, double_.y * (double)this.getMapSquareSize() / double_.height + (double)this.getMapSquareSize()) : null;
        this.setRenderingQuality(this.getRenderingQuality());
    }

    public final void setRenderingQuality(SwingUtil.RenderQuality renderQuality) {
        this.renderingQuality = renderQuality;
        switch (renderQuality) {
            case VERY_LOW: {
                this.mapStationsPainter.setRenderQuality(SwingUtil.RenderQuality.MEDIUM);
                this.mapBeamPainter.setRenderQuality(SwingUtil.RenderQuality.VERY_LOW);
                this.hypolinesPainter.setRenderQuality(SwingUtil.RenderQuality.VERY_LOW);
                this.mapCursorPainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                for (MapCirclePainter mapCirclePainter : this.allMapCirclePainters) {
                    mapCirclePainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                }
                this.mapCursorMePainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                this.mapZoomFramePainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                break;
            }
            case LOW: {
                this.mapStationsPainter.setRenderQuality(SwingUtil.RenderQuality.MEDIUM);
                this.mapBeamPainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                this.hypolinesPainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                this.mapCursorPainter.setRenderQuality(SwingUtil.RenderQuality.MEDIUM);
                for (MapCirclePainter mapCirclePainter : this.allMapCirclePainters) {
                    mapCirclePainter.setRenderQuality(SwingUtil.RenderQuality.MEDIUM);
                }
                this.mapCursorMePainter.setRenderQuality(SwingUtil.RenderQuality.MEDIUM);
                this.mapZoomFramePainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                break;
            }
            case MEDIUM: {
                this.mapStationsPainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                this.mapBeamPainter.setRenderQuality(SwingUtil.RenderQuality.MEDIUM);
                this.hypolinesPainter.setRenderQuality(SwingUtil.RenderQuality.MEDIUM);
                this.mapCursorPainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                for (MapCirclePainter mapCirclePainter : this.allMapCirclePainters) {
                    mapCirclePainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                }
                this.mapCursorMePainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                this.mapZoomFramePainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                break;
            }
            case HIGH: {
                this.mapStationsPainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                this.mapBeamPainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                this.hypolinesPainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                this.mapCursorPainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                for (MapCirclePainter mapCirclePainter : this.allMapCirclePainters) {
                    mapCirclePainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                }
                this.mapCursorMePainter.setRenderQuality(SwingUtil.RenderQuality.HIGH);
                this.mapZoomFramePainter.setRenderQuality(SwingUtil.RenderQuality.LOW);
                break;
            }
        }
        this.repaint();
    }

    public HypolinesPainter getHypolinesPainter() {
        return this.hypolinesPainter;
    }

    public EpiMapView getChildMap() {
        return this.childMap;
    }

    public void setChildMap(EpiMapView epiMapView) {
        this.childMap = epiMapView;
        if (epiMapView != null) {
            this.updateChildMapLocation();
        }
    }

    private void updateChildMapLocation() {
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.mapModel.x + this.zoomModel.x * this.mapModel.width, this.mapModel.y + this.zoomModel.y * this.mapModel.height, this.zoomModel.width * this.mapModel.width, this.zoomModel.height * this.mapModel.height);
        this.childMap.updateLocation(double_);
        this.epiMapDatabase.getEpiDepth().updateLocation(double_);
    }

    public void automaticCalc() {
        LogUtil.error(((Object)((Object)this)).getClass(), (String)"No grid loaded", (boolean)true);
    }

    public Rectangle2D.Double getZoomModel() {
        return this.zoomModel;
    }

    public ValidRectanglePainter getHlValidRect() {
        return this.hlValidRect;
    }

    public ValidRectanglePainter getCircleValidRect() {
        return this.circleValidRect;
    }

    public MapCursorModel getCursorMeModel() {
        return this.cursorMeModel;
    }

    public PatchmapPainter getPatchmapPainter() {
        return this.patchmapPainter;
    }

    public MAPBG getMapBackground() {
        return this.mapBackground;
    }

    public void setMapBackground(MAPBG mAPBG) {
        if (mAPBG.equals((Object)MAPBG.PATCHMAP)) {
            this.epiMapDatabase.updatePatchMap(this.thisMap);
        } else if (mAPBG.equals((Object)MAPBG.RESIDUALMAP)) {
            this.epiMapDatabase.updateResidualMap(this.thisMap);
        } else if (mAPBG.equals((Object)MAPBG.NONE)) {
            this.epiMapDatabase.getEpiDepth().getGridPainter().setImage(null);
        }
        if (mAPBG.equals((Object)MAPBG.PATCHMAP)) {
            this.hypolinesPainter.setOnlyCircles(true);
        } else {
            this.hypolinesPainter.setOnlyCircles(false);
        }
        this.mapBackground = mAPBG;
    }

    private void showEpiCenterInputSelection() {
        JSpinner jSpinner;
        JPanel jPanel = new JPanel((LayoutManager)new TableLayout((double[][])new double[][]{{-3.0, 10.0, -1.0}, {-1.0, -1.0}}));
        double d = this.epiMapDatabase.getEpiCenter().getLat();
        double d2 = this.epiMapDatabase.getEpiCenter().getLon();
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            jSpinner = CoordinateUtil.convertRelativeToAbsolute((double)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getReferencePoint().getLatitude(), (double)SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getReferencePoint().getLongitude(), (double)(this.mapModel.x + this.mapModel.getWidth() / 2.0), (double)(-this.mapModel.y - this.mapModel.getHeight() / 2.0));
            d = ((CoordinateUtil.AbsoluteResult)jSpinner).latitude;
            d2 = ((CoordinateUtil.AbsoluteResult)jSpinner).longitude;
        }
        jPanel.add((Component)new JLabel("New epicenter latitude"), "0, 0");
        jSpinner = new JSpinner();
        jSpinner.setModel(new SpinnerNumberModel(d, -90.0, 90.0, 0.1));
        jPanel.add((Component)jSpinner, "2, 0");
        jPanel.add((Component)new JLabel("New epicenter longitude"), "0, 1");
        JSpinner jSpinner2 = new JSpinner();
        jSpinner2.setModel(new SpinnerNumberModel(d2, -180.0, 180.0, 0.1));
        jPanel.add((Component)jSpinner2, "2, 1");
        int n = JOptionPane.showConfirmDialog(HypoLineManager.INSTANCE.getHlApp().getMainFrame(), jPanel, "Choose accurate epidepth", -1);
        if (n == 0) {
            this.epiMapDatabase.getEpiCenter().setLatLon((Double)jSpinner.getValue(), (Double)jSpinner2.getValue(), true);
            this.epiMapDatabase.updateEpiCenter();
        }
    }

    public double[] getMinResidual() {
        return this.minResidual;
    }

    public void setMinResidual(double[] dArray) {
        this.minResidual = dArray;
    }

    public PolyModel getErrorPolygon() {
        return this.errorPolygon;
    }

    public void setErrorPolygon(PolyModel polyModel) {
        this.errorPolygon = polyModel;
    }

    public static enum MAPBG {
        NONE,
        PATCHMAP,
        RESIDUALMAP,
        DETTHRES,
        SHOWGRID_IMG;

    }
}

