/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.AbstractPainter;
import edu.geophys.hypoline.epimap.MapStationsModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;

public class MapStationsPainter
extends AbstractPainter<MapStationsModel> {
    private static final int TRIANGLE_SIZE = 8;
    private int depthOffset = 0;
    private boolean epiDepthMode = false;
    private static GeneralPath TRIANGLE_CACHE = null;
    private static final BasicStroke STROKE = new BasicStroke(2.0f, 1, 0);
    private static final BasicStroke FATSTROKE = new BasicStroke(4.0f, 1, 0);

    private GeneralPath getTriangle() {
        if (TRIANGLE_CACHE != null) {
            return TRIANGLE_CACHE;
        }
        GeneralPath generalPath = new GeneralPath(0, 3);
        generalPath.moveTo(-4.0, 4.0);
        generalPath.lineTo(4.0, 4.0);
        generalPath.lineTo(0.0, -4.0);
        generalPath.closePath();
        TRIANGLE_CACHE = generalPath;
        return generalPath;
    }

    protected void doPaint(Graphics2D graphics2D, int n, int n2) {
        MapStationsModel mapStationsModel = (MapStationsModel)this.getModel();
        if (mapStationsModel == null) {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = (fontMetrics.getLeading() + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        graphics2D.translate(0, this.depthOffset);
        for (MapStationsModel.Station station : mapStationsModel.values()) {
            Object object;
            if (this.isEpiDepthMode() && station.getCaptionName().isEmpty()) continue;
            Point point = station.getMapPoint().getAbsolutePoint(n, n2 - this.depthOffset);
            if (this.isEpiDepthMode()) {
                point.y = (int)((double)point.y - 5.0);
            }
            graphics2D.translate(point.x, point.y);
            if (!this.isEpiDepthMode() && mapStationsModel.isPaintUnderlyingRectangle() && !station.getCaptionName().isEmpty()) {
                object = fontMetrics.getStringBounds(station.getCaptionName(), graphics2D);
                int n4 = (int)Math.max(16.0, ((RectangularShape)object).getHeight());
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getPlotBackgroundColor());
                graphics2D.fillRect(-8, -n4 / 2, (int)(16.0 + ((RectangularShape)object).getWidth()), n4);
            }
            object = null;
            switch (station.getState()) {
                case BLUE: {
                    object = ThemeManager.getInstance().getTheme().getZSatteliteColor();
                    break;
                }
                case GREEN: {
                    object = ThemeManager.getInstance().getTheme().getHCenterColor();
                    break;
                }
                default: {
                    object = ThemeManager.getInstance().getTheme().getAxisColor();
                }
            }
            if (this.isEpiDepthMode()) {
                graphics2D.setStroke(FATSTROKE);
                graphics2D.setColor(ThemeManager.getInstance().getTheme().getPlotBackgroundColor());
                graphics2D.draw(this.getTriangle());
                graphics2D.setStroke(STROKE);
                graphics2D.setColor((Color)object);
                graphics2D.draw(this.getTriangle());
            } else {
                graphics2D.setStroke(STROKE);
                graphics2D.setColor((Color)object);
                graphics2D.draw(this.getTriangle());
                graphics2D.drawString(station.getCaptionName(), 8, n3);
            }
            graphics2D.translate(-point.x, -point.y);
        }
        graphics2D.translate(0, -this.depthOffset);
    }

    public void enableEpiDepthMode(int n) {
        this.depthOffset = n;
        this.epiDepthMode = true;
    }

    public boolean isEpiDepthMode() {
        return this.epiDepthMode;
    }
}

