/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.resources.Colors;
import edu.geophys.commons.ui.AbstractPainter;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.epimap.PatchMapModel;
import java.awt.Graphics2D;

public class PatchmapPainter
extends AbstractPainter<Integer> {
    private PatchMapModel patchModel;

    protected void doPaint(Graphics2D graphics2D, int n, int n2) {
        if (this.patchModel != null) {
            double d = (double)n / (double)this.patchModel.steps;
            double d2 = (double)n2 / (double)this.patchModel.steps;
            double[][] dArray = this.patchModel.getValues();
            for (int i = 0; i < this.patchModel.steps; ++i) {
                for (int j = 0; j < this.patchModel.steps; ++j) {
                    double d3 = dArray[i][j];
                    if (d3 > this.patchModel.getMaxValue()) {
                        d3 = this.patchModel.getMaxValue();
                    }
                    graphics2D.setColor(Colors.SONOGRAM[(int)MathUtil.convertFromTo((double)d3, (double)this.patchModel.getMinValue(), (double)this.patchModel.getMaxValue(), (double)0.0, (double)(Colors.SONOGRAM.length - 1))]);
                    graphics2D.fillRect((int)((double)i * d), (int)((double)j * d2), (int)Math.ceil(d), (int)Math.ceil(d2));
                }
            }
        }
    }

    public PatchMapModel getPatchModel() {
        return this.patchModel;
    }

    public void setPatchModel(PatchMapModel patchMapModel) {
        this.patchModel = patchMapModel;
    }
}

