/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap;

import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.util.SwingUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class ValidRectanglePainter
extends JComponent {
    private static final long serialVersionUID = 1L;
    private boolean hlOrCircles;
    private int validLength = 0;
    private int outLength = 0;
    private int invalidLength = 0;
    private SwingUtil.RenderQuality renderQuality = SwingUtil.RenderQuality.VERY_LOW;

    public ValidRectanglePainter(boolean bl) {
        this.setOpaque(false);
        this.setBorder(null);
        this.hlOrCircles = bl;
        this.setPreferredSize(new Dimension(40, 5));
        this.setMinimumSize(this.getPreferredSize());
        this.setSize(this.getPreferredSize());
    }

    public void updateValues(int n, int n2, int n3) {
        int n4 = n + n2 + n3;
        if (n4 > 0) {
            this.validLength = (int)((double)n / (double)n4 * (double)this.getWidth());
            this.outLength = (int)((double)n2 / (double)n4 * (double)this.getWidth());
            this.invalidLength = (int)((double)n3 / (double)n4 * (double)this.getWidth());
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.BLACK);
        SwingUtil.setRenderingQuality((Graphics2D)graphics2D, (SwingUtil.RenderQuality)this.renderQuality);
        SwingUtil.setAntialiasing((Graphics2D)graphics2D, (boolean)false);
        if (this.hlOrCircles) {
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
        } else {
            graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineGreen());
        }
        graphics2D.fillRect(0, 0, this.validLength, this.getHeight());
        graphics2D.setColor(ThemeManager.getInstance().getTheme().getAxisColor());
        graphics2D.fillRect(this.validLength, 0, this.validLength + this.outLength, this.getHeight());
        graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineRed());
        graphics2D.fillRect(this.validLength + this.outLength, 0, this.validLength + this.outLength + this.invalidLength, this.getHeight());
    }

    public final SwingUtil.RenderQuality getRenderQuality() {
        return this.renderQuality;
    }

    public void setRenderQuality(SwingUtil.RenderQuality renderQuality) {
        this.renderQuality = renderQuality;
    }
}

