/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.epimap.gisexport;

import edu.geophys.hypoline.epimap.gisexport.KMLBase;
import edu.geophys.hypoline.epimap.gisexport.KMLCoordinate;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.PrintWriter;

@XmlType(name="tAbstractLine", propOrder={"name", "color", "coordinates"})
abstract class KMLLine
implements KMLBase {
    private static final String startLineString = "<Placemark><name>%s</name><description><![CDATA[<ul>%s</ul>]]></description><styleUrl>#%sLine</styleUrl><LineString><extrude>0</extrude><tessellate>1</tessellate><coordinates>";
    private static final String lineCoordinateString = "%f,%f,0 ";
    private static final String endLineString = "</coordinates></LineString></Placemark>";
    private KMLCoordinate[] coordinates = new KMLCoordinate[0];
    private String name = "Not set";
    private String color = "Not set";

    KMLLine() {
    }

    @XmlElement(name="name", required=true, nillable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @XmlElement(name="color", required=true, nillable=false)
    public String getColor() {
        return this.color;
    }

    public void setColor(String string) {
        this.color = string;
    }

    protected abstract String getDescription();

    @XmlElementWrapper(name="coordinates", required=true, nillable=false)
    @XmlElement(name="coordinate", required=false, nillable=false)
    public KMLCoordinate[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(KMLCoordinate[] kMLCoordinateArray) {
        this.coordinates = kMLCoordinateArray;
    }

    @Override
    public final void writeKML(PrintWriter printWriter) throws IOException {
        printWriter.printf(startLineString, this.getName(), this.getDescription(), this.getColor());
        for (KMLCoordinate kMLCoordinate : this.coordinates) {
            printWriter.printf(lineCoordinateString, kMLCoordinate.getLongitude(), kMLCoordinate.getLatitude());
        }
        printWriter.println(endLineString);
    }
}

