/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.me;

import edu.geophys.commons.model.AbstractTrace;
import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.model.knowledgebase.CampaignKnowledge;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.suite.TraceProvider;
import edu.geophys.commons.util.CoordinateUtil;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ccode.CHypoLineRoutines56;
import edu.geophys.hypoline.protocol.ProtEntry;
import edu.geophys.hypoline.protocol.ProtFileManager;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.trace.TraceRenderer;
import edu.geophys.sonoview.swing.FilteringTrace;
import java.util.ArrayList;
import java.util.List;

public class MasterEventManager {
    private TraceProvider traceProvider = SuiteManager.INSTANCE.getTraceProvider();
    private SiteModel activeModel = null;
    private List<SiteModel> sitemodels = new ArrayList<SiteModel>();
    private int meShift = 0;
    private double meAmpFactor = 1.0;
    private List<double[]> masterEventVectors = new ArrayList<double[]>();
    private boolean initialized = false;
    private float recti;
    private double startme;
    private double[] ponsetme;
    private double[] ponset;
    private double epixme;
    private double epiyme;
    private double[] statlocx;
    private double[] statlocy;
    CampaignKnowledge ck = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge();
    StationsKnowledge sk = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();

    public void init(String string, List<SiteModel> list) {
        this.sitemodels.clear();
        this.meShift = 0;
        this.meAmpFactor = 1.0;
        this.activeModel = null;
        this.masterEventVectors.clear();
        ProtFileManager protFileManager = new ProtFileManager(string);
        protFileManager.load();
        if (protFileManager.getProtEntries().size() <= 0) {
            LogUtil.error(this.getClass(), (String)"No entries found in master event xml file.", (boolean)true);
            return;
        }
        ProtEntry protEntry = protFileManager.getProtEntries().get(0);
        if (Double.isNaN(protEntry.getHypoX().getLat()) || Double.isNaN(protEntry.getHypoX().getLon())) {
            LogUtil.error(this.getClass(), (String)"Can not initialize Master Event because epicenter lat/lon is not defined.", (boolean)true);
            return;
        }
        if (Double.isNaN(protEntry.getHypoX().gettSource())) {
            LogUtil.error(this.getClass(), (String)"Can not initialize Master Event because epicenter source time is not defined.", (boolean)true);
            return;
        }
        this.startme = protEntry.getHypoX().gettSource();
        if (this.startme < (double)this.ck.getCampaignEpochStart() / 1000.0 || this.startme > (double)this.ck.getCampaignEpochEnd() / 1000.0) {
            LogUtil.error(this.getClass(), (String)("Source time of master event is outside of campaign knowbase time " + DateTimeUtil.formatDateTimeISO((double)this.startme) + " " + DateTimeUtil.formatDateTimeISO((long)this.ck.getCampaignEpochStart()) + " " + DateTimeUtil.formatDateTimeISO((long)this.ck.getCampaignEpochEnd())), (boolean)true);
        }
        int n = 0;
        for (ProtEntry.Pick pick : protEntry.getPicks()) {
            if (Double.isNaN(pick.getP())) continue;
            for (SiteModel siteModel : list) {
                if (!siteModel.getId().equals(pick.getSiteId())) continue;
                siteModel.setMeOrigpPick(pick.getP());
                ++n;
                if (siteModel.isActiveTrace() && siteModel.ispOrSActive()) {
                    this.activeModel = siteModel;
                }
                this.sitemodels.add(siteModel);
            }
        }
        if (this.activeModel == null) {
            LogUtil.error(this.getClass(), (String)"<html>Can not initialize Master Event.<br>No active trace with an active P phase is selected<br>which is also available in the master event.</html>", (boolean)true);
            return;
        }
        this.ponsetme = new double[n];
        this.ponset = new double[n];
        this.statlocx = new double[n];
        this.statlocy = new double[n];
        for (int i = 0; i < this.sitemodels.size(); ++i) {
            this.ponsetme[i] = this.sitemodels.get(i).getMeOrigpPick();
            this.ponset[i] = this.sitemodels.get(i).getpPick();
            this.statlocx[i] = this.sitemodels.get(i).getXOffsetKm();
            this.statlocy[i] = this.sitemodels.get(i).getYOffsetKm();
        }
        CoordinateUtil.RelativeResult relativeResult = CoordinateUtil.convertAbsoluteToRelative((double)this.ck.getReferencePoint().getLatitude(), (double)this.ck.getReferencePoint().getLongitude(), (double)protEntry.getHypoX().getLat(), (double)protEntry.getHypoX().getLon());
        this.epixme = relativeResult.xOffset;
        this.epiyme = relativeResult.yOffset;
        HypoLineManager.INSTANCE.getEpiMapDb().getEpiZoom().updateLocation(HypoLineManager.INSTANCE.getEpiMapDb().getEpiZoom().getMapModel());
        this.initialized = true;
        this.updateMeSolution();
        HypoLineManager.INSTANCE.getEpiMapDb().getEpiMap().updateLocation(HypoLineManager.INSTANCE.getEpiMapDb().getEpiMap().getMapModel());
    }

    public DefaultTrace getMeTrace(SiteModel siteModel, TraceRenderer.TraceType traceType) {
        if (!this.sitemodels.contains((Object)siteModel)) {
            return null;
        }
        double d = !Double.isNaN(this.activeModel.getpPick()) ? this.activeModel.getpPick() : siteModel.getStart() + siteModel.getLength() / 2.0;
        double d2 = d + (siteModel.getMeOrigpPick() - this.activeModel.getMeOrigpPick()) - (double)((float)this.meShift / this.ck.getGlobalSamplerate());
        siteModel.setMepPick(d2);
        double d3 = this.activeModel.getMeOrigpPick() + (this.activeModel.getStart() - d) + (double)((float)this.meShift / this.ck.getGlobalSamplerate());
        String string = siteModel.getTraceZ();
        if (traceType.equals((Object)TraceRenderer.TraceType.TRACE_EW)) {
            string = siteModel.getTraceEW();
        } else if (traceType.equals((Object)TraceRenderer.TraceType.TRACE_NS)) {
            string = siteModel.getTraceNS();
        }
        DefaultTrace defaultTrace = this.traceProvider.requestTrace(d3, d3 + siteModel.getLength(), this.ck.getGlobalSamplerate(), new String[]{string})[0];
        defaultTrace.setSamples(MathUtil.subMeanZeroNaN((float[])defaultTrace.getSamples()));
        FilteringTrace filteringTrace = new FilteringTrace((AbstractTrace)defaultTrace);
        filteringTrace.directFilter(siteModel.getFl(), siteModel.getFu());
        defaultTrace.setSamples(filteringTrace.getSamples());
        return defaultTrace;
    }

    public double getShiftedStartme(SiteModel siteModel) {
        double d = !Double.isNaN(this.activeModel.getpPick()) ? this.activeModel.getpPick() + (this.startme - this.activeModel.getMeOrigpPick()) - (double)((float)this.meShift / this.ck.getGlobalSamplerate()) : siteModel.getStart() + siteModel.getLength() / 2.0 + (this.startme - this.activeModel.getMeOrigpPick()) - (double)((float)this.meShift / this.ck.getGlobalSamplerate());
        return d;
    }

    public void updatePick(SiteModel siteModel) {
        if (Double.isNaN(siteModel.getpPick())) {
            // empty if block
        }
        for (int i = 0; i < this.sitemodels.size(); ++i) {
            this.ponsetme[i] = this.sitemodels.get(i).getMeOrigpPick();
            this.ponset[i] = this.sitemodels.get(i).getpPick();
            this.statlocx[i] = this.sitemodels.get(i).getXOffsetKm();
            this.statlocy[i] = this.sitemodels.get(i).getYOffsetKm();
        }
        this.updateMeSolution();
    }

    private void updateMeSolution() {
        CHypoLineRoutines56 cHypoLineRoutines56 = HypoLineManager.INSTANCE.getRaytracer();
        int n = 0;
        for (int i = 0; i < this.sitemodels.size(); ++i) {
            if (!this.sitemodels.get(i).getId().equals(this.activeModel.getId())) continue;
            n = i;
            break;
        }
        this.recti = cHypoLineRoutines56.hypolocme(n, this.ponsetme, this.ponset, (float)this.epixme, (float)this.epiyme, this.ck.getGlobalSamplerate(), this.startme);
        this.masterEventVectors = cHypoLineRoutines56.getMasterEventVectors();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public int getMeShift() {
        return this.meShift;
    }

    public void setMeShift(int n) {
        this.meShift = n;
    }

    public List<double[]> getMasterEventVectors() {
        return this.masterEventVectors;
    }

    public void setMasterEventVectors(List<double[]> list) {
        this.masterEventVectors = list;
    }

    public double getEpixme() {
        return this.epixme;
    }

    public void setEpixme(double d) {
        this.epixme = d;
    }

    public double getEpiyme() {
        return this.epiyme;
    }

    public void setEpiyme(double d) {
        this.epiyme = d;
    }

    public float getRecti() {
        return this.recti;
    }

    public void setRecti(float f) {
        this.recti = f;
    }

    public double getStartme() {
        return this.startme;
    }

    public void setStartme(double d) {
        this.startme = d;
    }

    public double getMeAmpFactor() {
        return this.meAmpFactor;
    }

    public void setMeAmpFactor(double d) {
        this.meAmpFactor = d;
    }
}

