/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.protocol;

import edu.geophys.commons.model.protfiles.ProtFile;
import edu.geophys.commons.model.protfiles.ProtFileEntry;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.protocol.ProtEntry;
import edu.geophys.hypoline.protocol.ProtFileManager;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ToolTipManager;

public class ProtConvert {
    SimpleDateFormat simpleTime = new SimpleDateFormat("HH:mm:ss");
    Calendar calDay;

    private String[] splitAndRemoveEmpty(String string, String string2) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray = string.split(string2)) {
            if (string3.isEmpty()) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String trimEnd(String string) {
        return string.replaceAll("\\s+$", "");
    }

    private String trimStart(String string) {
        return string.replaceAll("^+\\s", "");
    }

    private double parseDayTime(String string) throws ParseException {
        double d = Double.parseDouble(string.substring(string.length() - 4, string.length())) / 10000.0;
        double d2 = (double)(this.simpleTime.parse(string).getTime() + this.calDay.getTimeInMillis()) / 1000.0;
        return d2 + d;
    }

    private ProtEntry readProtFile(ProtFileEntry protFileEntry) {
        Object object;
        String[] stringArray;
        Object object2;
        String[] stringArray2;
        Object object3;
        Object object4;
        Object object5;
        this.calDay = new GregorianCalendar();
        String string = " |>|<|,|\\[|\\]|\\(|\\)|\\\\|'";
        String string2 = " |,";
        ProtEntry protEntry = new ProtEntry();
        try {
            protEntry.setComment(protFileEntry.m_COMMENT);
            protEntry.setEntry(Integer.parseInt(this.splitAndRemoveEmpty(protFileEntry.m_ENTRY, string)[1]));
            String[] stringArray3 = this.splitAndRemoveEmpty(protFileEntry.m_DATE, string);
            object5 = DateTimeUtil.parseDateTimeHypoProt((String)(stringArray3[1] + " " + stringArray3[2]));
            protEntry.setDate(((Calendar)object5).getTimeInMillis());
            this.calDay.setTimeInMillis(0L);
            this.calDay.set(1, ((Calendar)object5).get(1));
            this.calDay.set(2, ((Calendar)object5).get(2));
            this.calDay.set(5, ((Calendar)object5).get(5));
            object4 = this.splitAndRemoveEmpty(protFileEntry.m_SETUP, string);
            object3 = new ProtEntry.Setup();
            ((ProtEntry.Setup)object3).setSubnet(Integer.parseInt((String)object4[1]));
            ((ProtEntry.Setup)object3).setResamp(Integer.parseInt((String)object4[2]));
            ((ProtEntry.Setup)object3).setSono(Integer.parseInt((String)object4[3]) != 0);
            protEntry.setSetup((ProtEntry.Setup)object3);
            stringArray2 = this.splitAndRemoveEmpty(protFileEntry.m_TIME, string);
            object2 = new ProtEntry.Time();
            ((ProtEntry.Time)object2).setStart(Long.parseLong(stringArray2[1].substring(0, stringArray2[1].length() - 1)));
            ((ProtEntry.Time)object2).setLength(Double.parseDouble(stringArray2[2].substring(0, stringArray2[2].length() - 1)));
            ((ProtEntry.Time)object2).setZoomLeft(Double.parseDouble(stringArray2[3].substring(0, stringArray2[3].length() - 1)));
            ((ProtEntry.Time)object2).setZoomRight(Double.parseDouble(stringArray2[4].substring(0, stringArray2[4].length() - 1)));
            protEntry.setTime((ProtEntry.Time)object2);
            stringArray = this.splitAndRemoveEmpty(protFileEntry.m_MAP, string);
            object = new ProtEntry.Map();
            ((ProtEntry.Map)object).setX0(Float.parseFloat(stringArray[1]));
            ((ProtEntry.Map)object).setY0(Float.parseFloat(stringArray[2]));
            ((ProtEntry.Map)object).setSize(Float.parseFloat(stringArray[3]));
            ((ProtEntry.Map)object).setZoomX0(Float.parseFloat(stringArray[4]));
            ((ProtEntry.Map)object).setZoomY0(Float.parseFloat(stringArray[5]));
            ((ProtEntry.Map)object).setZoomSite(Float.parseFloat(stringArray[6]));
            ((ProtEntry.Map)object).setzMax(Float.parseFloat(stringArray[7]));
            if (stringArray.length > 8) {
                ((ProtEntry.Map)object).setMapXY(Float.parseFloat(stringArray[8]));
            }
            protEntry.setMap((ProtEntry.Map)object);
            String[] stringArray4 = this.splitAndRemoveEmpty(protFileEntry.m_MODEL, string2);
            ProtEntry.Model model = new ProtEntry.Model();
            model.setLayerModel(stringArray4[1]);
            model.setMagModel(ProtEntry.Model.MagModelType.def);
            model.setDepth(Float.parseFloat(stringArray4[3].substring(0, stringArray4[3].length() - 1)));
            if (stringArray4.length > 4) {
                if (stringArray4[4].length() == 1 && stringArray4[4].equals("(")) {
                    model.setVp1(Float.parseFloat(stringArray4[5]));
                    model.setZ1(Float.parseFloat(stringArray4[6]));
                    if (stringArray4[7].endsWith(")")) {
                        model.setVp2(Float.parseFloat(stringArray4[7].substring(0, stringArray4[7].length() - 1)));
                    } else {
                        model.setVp2(Float.parseFloat(stringArray4[7]));
                    }
                } else {
                    model.setVp1(Float.parseFloat(stringArray4[4].substring(1)));
                    model.setZ1(Float.parseFloat(stringArray4[5]));
                    if (stringArray4[stringArray4[6].length() - 1].equals(Character.valueOf(')'))) {
                        model.setVp2(Float.parseFloat(stringArray4[6].substring(0, stringArray4[6].length() - 1)));
                    } else {
                        model.setVp2(Float.parseFloat(stringArray4[6]));
                    }
                }
            }
            protEntry.setModel(model);
            if (protFileEntry.m_HYPO_X != null) {
                String[] stringArray5 = this.splitAndRemoveEmpty(protFileEntry.m_HYPO_X, string);
                ProtEntry.HypoX hypoX = new ProtEntry.HypoX();
                int n = 1;
                if (!stringArray5[n].equals("nd") && !stringArray5[n + 1].equals("nd")) {
                    hypoX.settSource((double)DateTimeUtil.parseDateTimeHypoProt((String)(stringArray5[n] + " " + stringArray5[n + 1])).getTimeInMillis() / 1000.0 + Double.parseDouble(stringArray5[n + 1].substring(stringArray5[n + 1].length() - 4, stringArray5[n + 1].length())));
                    ++n;
                }
                if (!stringArray5[++n].equals("nd")) {
                    hypoX.setLat(Double.parseDouble(stringArray5[n]));
                }
                if (!stringArray5[++n].equals("nd")) {
                    hypoX.setLon(Double.parseDouble(stringArray5[n]));
                }
                if (!stringArray5[++n].equals("nd")) {
                    hypoX.setDepth(Float.parseFloat(stringArray5[n]));
                }
                if (!stringArray5[++n].equals("nd")) {
                    hypoX.setMagnitude(Float.parseFloat(stringArray5[n]));
                }
                if (!stringArray5[n += 2].equals("nd")) {
                    hypoX.setX(Double.parseDouble(stringArray5[n]));
                }
                if (!stringArray5[++n].equals("nd")) {
                    hypoX.setY(Double.parseDouble(stringArray5[n]));
                }
                if (!stringArray5[++n].equals("nd")) {
                    hypoX.setLatc(Double.parseDouble(stringArray5[n]));
                }
                if (!stringArray5[++n].equals("nd")) {
                    hypoX.setLonc(Double.parseDouble(stringArray5[n]));
                }
                protEntry.setHypoX(hypoX);
            }
        }
        catch (Exception exception) {
            LogUtil.error(this.getClass(), (String)("PARSE Exception in Read ENTRY header records: " + exception.getMessage()));
            exception.printStackTrace();
        }
        if (protFileEntry.m_ARRAYS.size() > 0) {
            for (int i = 0; i < protFileEntry.m_ARRAYS.size(); ++i) {
                object5 = new ProtEntry.Array();
                try {
                    object4 = this.trimEnd((String)protFileEntry.m_ARRAYS.get(i)).substring(8, 25).split("-");
                    ((ProtEntry.Array)object5).setId(object4[0].substring(0, object4[0].length() - 1) + "C");
                    object3 = this.splitAndRemoveEmpty(((String)protFileEntry.m_ARRAYS.get(i)).substring(67, 81), string);
                    if (((String[])object3).length == 3) {
                        ((ProtEntry.Array)object5).setpBeamSimulAppVelocity(Double.parseDouble((String)object3[0]));
                        ((ProtEntry.Array)object5).setpBeamSimulDegree(Double.parseDouble((String)object3[2]));
                        ((ProtEntry.Array)object5).setpBeamAppVelocity(Double.parseDouble((String)object3[0]));
                        ((ProtEntry.Array)object5).setpBeamDegree(Double.parseDouble((String)object3[2]));
                    }
                    if ((stringArray2 = this.splitAndRemoveEmpty(((String)protFileEntry.m_ARRAYS.get(i)).substring(84, 98), string)).length == 3) {
                        ((ProtEntry.Array)object5).setsBeamSimulAppVelocity(Double.parseDouble(stringArray2[0]));
                        ((ProtEntry.Array)object5).setsBeamSimulDegree(Double.parseDouble(stringArray2[2]));
                        ((ProtEntry.Array)object5).setsBeamAppVelocity(Double.parseDouble(stringArray2[0]));
                        ((ProtEntry.Array)object5).setsBeamDegree(Double.parseDouble(stringArray2[2]));
                    }
                    if (((String[])(object2 = this.splitAndRemoveEmpty(((String)protFileEntry.m_ARRAYS.get(i)).substring(100, 110), string))).length == 1 && !((String)object2[0]).equals("nd")) {
                        ((ProtEntry.Array)object5).setHypo71(Integer.parseInt((String)object2[0]));
                    }
                    if ((stringArray = this.splitAndRemoveEmpty(((String)protFileEntry.m_ARRAYS.get(i)).substring(110), string)).length == 1 && !stringArray[0].equals("nd")) {
                        ((ProtEntry.Array)object5).setHypoX(Integer.parseInt(stringArray[0]));
                    }
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), (String)("PARSE Exception in Read m_ARRAYS: " + exception.getMessage()));
                    exception.printStackTrace();
                }
                protEntry.getArrays().add((ProtEntry.Array)object5);
            }
        }
        if (protFileEntry.m_CIRCLES.size() > 0) {
            for (int i = 0; i < protFileEntry.m_CIRCLES.size(); ++i) {
                object5 = new ProtEntry.Circle();
                try {
                    object4 = this.splitAndRemoveEmpty((String)protFileEntry.m_CIRCLES.get(i), string);
                    ((ProtEntry.Circle)object5).setSite(((String)protFileEntry.m_CIRCLES.get(i)).substring(7, 18).trim());
                    ((ProtEntry.Circle)object5).settSource((long)(1000.0 * this.parseDayTime(((String)protFileEntry.m_CIRCLES.get(i)).substring(18, 32))));
                    ((ProtEntry.Circle)object5).setDepth(Float.parseFloat(((String)object4[3]).substring(0, ((String)object4[3]).length() - 1)));
                    ((ProtEntry.Circle)object5).settStoP(Float.parseFloat((String)object4[4]));
                    ((ProtEntry.Circle)object5).setDist1(Float.parseFloat((String)object4[5]));
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), (String)("PARSE Exception in Read m_CIRCLES: " + exception.getMessage()));
                    exception.printStackTrace();
                }
                protEntry.getCirlces().add((ProtEntry.Circle)object5);
            }
        }
        if (protFileEntry.m_PICKS.size() > 0) {
            for (int i = 0; i < protFileEntry.m_PICKS.size(); ++i) {
                object5 = new ProtEntry.Pick();
                try {
                    ((ProtEntry.Pick)object5).setSiteid(((String)protFileEntry.m_PICKS.get(i)).substring(5, 16).trim());
                    object4 = ((String)protFileEntry.m_PICKS.get(i)).substring(16, 31).trim();
                    if (object4 != null && ((String)object4).length() > 0) {
                        ((ProtEntry.Pick)object5).setP(this.parseDayTime(((String)object4).substring(0, ((String)object4).length() - 1)));
                    }
                    if ((object3 = ((String)protFileEntry.m_PICKS.get(i)).substring(34, 48).trim()) != null && ((String)object3).length() > 0) {
                        ((ProtEntry.Pick)object5).setPg(this.parseDayTime(((String)object3).substring(0, ((String)object3).length() - 1)));
                    }
                    if ((stringArray2 = ((String)protFileEntry.m_PICKS.get(i)).substring(51, 65).trim()) != null && stringArray2.length() > 0) {
                        ((ProtEntry.Pick)object5).setS(this.parseDayTime(stringArray2.substring(0, stringArray2.length() - 1)));
                    }
                    if ((object2 = ((String)protFileEntry.m_PICKS.get(i)).substring(68, 82).trim()) != null && ((String)object2).length() > 0) {
                        ((ProtEntry.Pick)object5).setLg(this.parseDayTime(((String)object2).substring(0, ((String)object2).length() - 1)));
                    }
                    ((ProtEntry.Pick)object5).setDist(ProtEntry.Pick.distType.loc);
                    stringArray = ((String)protFileEntry.m_PICKS.get(i)).substring(89, 103).trim();
                    if (stringArray != null && stringArray.length() > 0) {
                        ((ProtEntry.Pick)object5).setpCorr(this.parseDayTime(stringArray.substring(0, stringArray.length() - 1)));
                    }
                    if ((object = ((String)protFileEntry.m_PICKS.get(i)).substring(105, 119).trim()) != null && ((String)object).length() > 0) {
                        ((ProtEntry.Pick)object5).setsCorr(this.parseDayTime(((String)object).substring(0, ((String)object).length() - 1)));
                    }
                }
                catch (Exception exception) {
                    LogUtil.info(this.getClass(), (String)("PARSE Exception in Read m_PICKS: " + exception.getMessage()));
                    exception.printStackTrace();
                }
                protEntry.getPicks().add((ProtEntry.Pick)object5);
            }
        }
        if (protFileEntry.m_VIEWS.size() > 0) {
            for (int i = 0; i < protFileEntry.m_VIEWS.size(); ++i) {
                object5 = new ProtEntry.View();
                try {
                    object4 = this.splitAndRemoveEmpty((String)protFileEntry.m_VIEWS.get(i), string);
                    ((ProtEntry.View)object5).setTrace(object4[1]);
                    ((ProtEntry.View)object5).setFl(Float.parseFloat(object4[2]));
                    ((ProtEntry.View)object5).setFu(Float.parseFloat((String)object4[3]));
                    ((ProtEntry.View)object5).setCalib_bar(Float.parseFloat((String)object4[4]));
                    ((ProtEntry.View)object5).setMaxAmp(Float.parseFloat((String)object4[6]));
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), (String)("PARSE Exception in Read VIEWS: " + exception.getMessage()));
                    exception.printStackTrace();
                }
                protEntry.getViews().add((ProtEntry.View)object5);
            }
        }
        if (protFileEntry.m_AMPLS.size() > 0) {
            for (int i = 0; i < protFileEntry.m_AMPLS.size(); ++i) {
                object5 = new ProtEntry.Ampl();
                try {
                    object4 = this.splitAndRemoveEmpty((String)protFileEntry.m_AMPLS.get(i), string);
                    ((ProtEntry.Ampl)object5).setTrace(object4[1].split("-")[0]);
                    ((ProtEntry.Ampl)object5).setStart(this.parseDayTime((String)object4[2]));
                    ((ProtEntry.Ampl)object5).setPeriod(Double.parseDouble((String)object4[3]));
                    ((ProtEntry.Ampl)object5).setEnd(((ProtEntry.Ampl)object5).getStart() + ((ProtEntry.Ampl)object5).getPeriod());
                    ((ProtEntry.Ampl)object5).setDiplacement(Float.parseFloat((String)object4[4]) / 1000.0f);
                    ((ProtEntry.Ampl)object5).setFl(Float.parseFloat((String)object4[6]));
                    ((ProtEntry.Ampl)object5).setFu(Float.parseFloat((String)object4[7]));
                    ((ProtEntry.Ampl)object5).setExtrem1(Float.parseFloat(((String)object4[8]).substring(0, ((String)object4[8]).length() - 2)));
                    ((ProtEntry.Ampl)object5).setExtrem2(Float.parseFloat(((String)object4[9]).substring(0, ((String)object4[9]).length() - 2)));
                }
                catch (Exception exception) {
                    LogUtil.error(this.getClass(), (String)("PARSE Exception in Read AMPLS: " + exception.getMessage()));
                    exception.printStackTrace();
                }
                protEntry.getAmpls().add((ProtEntry.Ampl)object5);
            }
        }
        return protEntry;
    }

    public void convertAll() {
        String string = SuiteManager.INSTANCE.getKnowledgebase().getTmpFolder().getAbsolutePath();
        ProtFile protFile = new ProtFile();
        protFile.readFromFile(new File(string + File.separator + "hypoprot.txt"));
        ProtFileManager protFileManager = HypoLineManager.INSTANCE.getProtFileManager();
        protFileManager.getProtEntries().clear();
        for (ProtFileEntry protFileEntry : protFile.m_entries) {
            ProtEntry protEntry = this.readProtFile(protFileEntry);
            protFileManager.getProtEntries().add(protEntry);
        }
        protFileManager.store();
        LogUtil.info(this.getClass(), (String)"Conversion from hypoprot.txt to hypoprot.xml done.", (boolean)true);
    }

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.UK);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        ProtFile protFile = new ProtFile();
        protFile.readFromFile(new File("/home/sick/geophys/knowbases/2006-Basel/tmp/hypoprot.txt"));
        ProtFileManager protFileManager = new ProtFileManager("/home/sick/geophys/knowbases/2006-Basel/tmp/hypoprot.xml");
        ProtConvert protConvert = new ProtConvert();
        for (ProtFileEntry protFileEntry : protFile.m_entries) {
            ProtEntry protEntry = protConvert.readProtFile(protFileEntry);
            protFileManager.getProtEntries().add(protEntry);
        }
        protFileManager.store();
    }
}

