/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.protocol;

import edu.geophys.commons.model.tracefiles.converters.TimeHelper;
import edu.geophys.commons.ui.AbstractBean;
import edu.geophys.commons.util.JAXBSerializable;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

@XmlRootElement(name="ProtEntry")
public class ProtEntry
implements Comparable<ProtEntry>,
JAXBSerializable {
    private int entry;
    private long date;
    private String comment;
    private Map map = new Map();
    private Model model = new Model();
    private HypoX hypoX = new HypoX();
    private Setup setup = new Setup();
    private Time time = new Time();
    private List<Ampl> ampls = new ArrayList<Ampl>();
    private List<Pick> picks = new ArrayList<Pick>();
    private List<View> views = new ArrayList<View>();
    private List<Array> arrays = new ArrayList<Array>();
    private List<Circle> cirlces = new ArrayList<Circle>();

    @Override
    public int compareTo(ProtEntry protEntry) {
        long l;
        long l2 = this.getDate();
        if (l2 > (l = protEntry.getDate())) {
            return 1;
        }
        if (l2 < l) {
            return -1;
        }
        return 0;
    }

    public String getHypo34TextFormat() {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(Locale.ENGLISH);
        formatter.format("ENTRY  %d\n", this.entry);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeHelper.TIMEZONE_UTC, Locale.ENGLISH);
        gregorianCalendar.setTimeInMillis(this.date);
        formatter.format("DATE   %2.2d.%2.2d.%4.4d  <%2.2d:%2.2d:%2.2d>ff\n", gregorianCalendar.get(5), gregorianCalendar.get(2) + 1, gregorianCalendar.get(1), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13));
        formatter.format("#\n", new Object[0]);
        formatter.format("#                -----P,Pn-----   ------Pg------   -----S,Sn-----   ------Lg------ dist  ----Pcorr-----  ----Scorr-----\n", new Object[0]);
        stringBuilder.append(formatter);
        return stringBuilder.toString();
    }

    @XmlElement(name="Amplitudes", required=true)
    public List<Ampl> getAmpls() {
        return this.ampls;
    }

    public void setAmpls(List<Ampl> list) {
        this.ampls = list;
    }

    @XmlElement(name="Setup", required=true)
    public Setup getSetup() {
        return this.setup;
    }

    public void setSetup(Setup setup) {
        this.setup = setup;
    }

    @XmlElement(name="Time", required=true)
    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    @XmlElement(name="View", required=true)
    public List<View> getViews() {
        return this.views;
    }

    public void setViews(List<View> list) {
        this.views = list;
    }

    @XmlElement(name="Map", required=true)
    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    @XmlElement(name="Model", required=true)
    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    @XmlElement(name="Array", required=true)
    public List<Array> getArrays() {
        return this.arrays;
    }

    public void setArrays(List<Array> list) {
        this.arrays = list;
    }

    @XmlElement(name="Circle", required=true)
    public List<Circle> getCirlces() {
        return this.cirlces;
    }

    public void setCirlces(List<Circle> list) {
        this.cirlces = list;
    }

    @XmlElement(name="HypoX", required=true)
    public HypoX getHypoX() {
        return this.hypoX;
    }

    public void setHypoX(HypoX hypoX) {
        this.hypoX = hypoX;
    }

    @XmlElement(name="Date", required=true)
    public long getDate() {
        return this.date;
    }

    public void setDate(long l) {
        this.date = l;
    }

    @XmlElement(name="Pick", required=true)
    public List<Pick> getPicks() {
        return this.picks;
    }

    public void setPicks(List<Pick> list) {
        List<Pick> list2 = this.picks;
        this.picks = list;
    }

    @XmlElement(name="Entry", required=true)
    public int getEntry() {
        return this.entry;
    }

    public void setEntry(int n) {
        this.entry = n;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public static class Map {
        private float x0;
        private float y0;
        private float size;
        private float zoomX0;
        private float zoomY0;
        private float zoomSite;
        private float zMax;
        private float mapXY;

        public float getX0() {
            return this.x0;
        }

        public void setX0(float f) {
            this.x0 = f;
        }

        public float getY0() {
            return this.y0;
        }

        public void setY0(float f) {
            this.y0 = f;
        }

        public float getSize() {
            return this.size;
        }

        public void setSize(float f) {
            this.size = f;
        }

        public float getZoomX0() {
            return this.zoomX0;
        }

        public void setZoomX0(float f) {
            this.zoomX0 = f;
        }

        public float getZoomY0() {
            return this.zoomY0;
        }

        public void setZoomY0(float f) {
            this.zoomY0 = f;
        }

        public float getZoomSite() {
            return this.zoomSite;
        }

        public void setZoomSite(float f) {
            this.zoomSite = f;
        }

        public float getzMax() {
            return this.zMax;
        }

        public void setzMax(float f) {
            this.zMax = f;
        }

        public float getMapXY() {
            return this.mapXY;
        }

        public void setMapXY(float f) {
            this.mapXY = f;
        }
    }

    public static class Model {
        private String layerModel;
        private MagModelType magModel;
        private float depth;
        private float vp1;
        private float z1;
        private float vp2;

        public String getLayerModel() {
            return this.layerModel;
        }

        public void setLayerModel(String string) {
            this.layerModel = string;
        }

        public MagModelType getMagModel() {
            return this.magModel;
        }

        public void setMagModel(MagModelType magModelType) {
            this.magModel = magModelType;
        }

        public float getDepth() {
            return this.depth;
        }

        public void setDepth(float f) {
            this.depth = f;
        }

        public float getVp1() {
            return this.vp1;
        }

        public void setVp1(float f) {
            this.vp1 = f;
        }

        public float getZ1() {
            return this.z1;
        }

        public void setZ1(float f) {
            this.z1 = f;
        }

        public float getVp2() {
            return this.vp2;
        }

        public void setVp2(float f) {
            this.vp2 = f;
        }

        public static enum MagModelType {
            def;

        }
    }

    public static class HypoX
    extends AbstractBean {
        private double tSource;
        private double lat = Double.NaN;
        private double lon = Double.NaN;
        private float depth = Float.NaN;
        private float magnitude = Float.NaN;
        private double x = Double.NaN;
        private double y = Double.NaN;
        private double latc = Double.NaN;
        private double lonc = Double.NaN;

        public double gettSource() {
            return this.tSource;
        }

        public void settSource(double d) {
            this.tSource = d;
        }

        public double getLat() {
            return this.lat;
        }

        public void setLat(double d) {
            this.lat = d;
        }

        public double getLon() {
            return this.lon;
        }

        public void setLon(double d) {
            this.lon = d;
        }

        public float getDepth() {
            return this.depth;
        }

        public void setDepth(float f) {
            this.depth = f;
        }

        public float getMagnitude() {
            return this.magnitude;
        }

        public void setMagnitude(float f) {
            this.magnitude = f;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        public double getLatc() {
            return this.latc;
        }

        public void setLatc(double d) {
            this.latc = d;
        }

        public double getLonc() {
            return this.lonc;
        }

        public void setLonc(double d) {
            this.lonc = d;
        }
    }

    public static class Setup {
        private int subnet;
        private int resamp;
        private boolean sono;

        public int getSubnet() {
            return this.subnet;
        }

        public void setSubnet(int n) {
            this.subnet = n;
        }

        public int getResamp() {
            return this.resamp;
        }

        public void setResamp(int n) {
            this.resamp = n;
        }

        public boolean isSono() {
            return this.sono;
        }

        public void setSono(boolean bl) {
            this.sono = bl;
        }
    }

    public static class Time {
        private long start;
        private double length;
        private double zoomLeft;
        private double zoomRight;

        public long getStart() {
            return this.start;
        }

        public void setStart(long l) {
            this.start = l;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double d) {
            this.length = d;
        }

        public double getZoomLeft() {
            return this.zoomLeft;
        }

        public void setZoomLeft(double d) {
            this.zoomLeft = d;
        }

        public double getZoomRight() {
            return this.zoomRight;
        }

        public void setZoomRight(double d) {
            this.zoomRight = d;
        }
    }

    public static class Circle {
        private String site;
        private long tSource;
        private float depth;
        private double tStoP;
        private double dist1;

        public String getSite() {
            return this.site;
        }

        public void setSite(String string) {
            this.site = string;
        }

        public long gettSource() {
            return this.tSource;
        }

        public void settSource(long l) {
            this.tSource = l;
        }

        public float getDepth() {
            return this.depth;
        }

        public void setDepth(float f) {
            this.depth = f;
        }

        public double gettStoP() {
            return this.tStoP;
        }

        public void settStoP(double d) {
            this.tStoP = d;
        }

        public double getDist1() {
            return this.dist1;
        }

        public void setDist1(double d) {
            this.dist1 = d;
        }
    }

    public static class Array {
        private String id;
        private String sites;
        private double pBeamAppVelocity;
        private double pBeamDegree;
        private double pBeamCertainty;
        private double sBeamAppVelocity;
        private double sBeamDegree;
        private double sBeamCertainty;
        private double pBeamSimulAppVelocity;
        private double pBeamSimulDegree;
        private double sBeamSimulAppVelocity;
        private double sBeamSimulDegree;
        private int hypo71;
        private int hypoX;

        public Array() {
        }

        public Array(String string) {
            this.id = string;
        }

        public String getSites() {
            return this.sites;
        }

        public void setSites(String string) {
            this.sites = string;
        }

        public double getpBeamAppVelocity() {
            return this.pBeamAppVelocity;
        }

        public void setpBeamAppVelocity(double d) {
            this.pBeamAppVelocity = d;
        }

        public double getpBeamDegree() {
            return this.pBeamDegree;
        }

        public void setpBeamDegree(double d) {
            this.pBeamDegree = d;
        }

        public double getsBeamAppVelocity() {
            return this.sBeamAppVelocity;
        }

        public void setsBeamAppVelocity(double d) {
            this.sBeamAppVelocity = d;
        }

        public double getsBeamDegree() {
            return this.sBeamDegree;
        }

        public void setsBeamDegree(double d) {
            this.sBeamDegree = d;
        }

        public double getpBeamSimulAppVelocity() {
            return this.pBeamSimulAppVelocity;
        }

        public void setpBeamSimulAppVelocity(double d) {
            this.pBeamSimulAppVelocity = d;
        }

        public double getpBeamSimulDegree() {
            return this.pBeamSimulDegree;
        }

        public void setpBeamSimulDegree(double d) {
            this.pBeamSimulDegree = d;
        }

        public double getsBeamSimulAppVelocity() {
            return this.sBeamSimulAppVelocity;
        }

        public void setsBeamSimulAppVelocity(double d) {
            this.sBeamSimulAppVelocity = d;
        }

        public double getsBeamSimulDegree() {
            return this.sBeamSimulDegree;
        }

        public void setsBeamSimulDegree(double d) {
            this.sBeamSimulDegree = d;
        }

        public int getHypo71() {
            return this.hypo71;
        }

        public void setHypo71(int n) {
            this.hypo71 = n;
        }

        public int getHypoX() {
            return this.hypoX;
        }

        public void setHypoX(int n) {
            this.hypoX = n;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public double getpBeamCertainty() {
            return this.pBeamCertainty;
        }

        public void setpBeamCertainty(double d) {
            this.pBeamCertainty = d;
        }

        public double getsBeamCertainty() {
            return this.sBeamCertainty;
        }

        public void setsBeamCertainty(double d) {
            this.sBeamCertainty = d;
        }
    }

    public static class View {
        private String trace;
        private float fl;
        private float fu;
        private float calib_bar;
        private float maxAmp;

        public View() {
        }

        public View(String string) {
            this.trace = string;
        }

        public String getTrace() {
            return this.trace;
        }

        public void setTrace(String string) {
            this.trace = string;
        }

        public float getFl() {
            return this.fl;
        }

        public void setFl(float f) {
            this.fl = f;
        }

        public float getFu() {
            return this.fu;
        }

        public void setFu(float f) {
            this.fu = f;
        }

        public float getCalib_bar() {
            return this.calib_bar;
        }

        public void setCalib_bar(float f) {
            this.calib_bar = f;
        }

        public float getMaxAmp() {
            return this.maxAmp;
        }

        public void setMaxAmp(float f) {
            this.maxAmp = f;
        }
    }

    public static class Ampl {
        private String trace;
        private double start;
        private double end;
        private double period;
        private float diplacement;
        private float fl;
        private float fu;
        private float extrem1;
        private float extrem2;

        public Ampl() {
        }

        public Ampl(String string) {
            this.trace = string;
        }

        public String getTrace() {
            return this.trace;
        }

        public double getStart() {
            return this.start;
        }

        public void setStart(double d) {
            this.start = d;
        }

        public double getPeriod() {
            return this.period;
        }

        public void setPeriod(double d) {
            this.period = d;
        }

        public float getDiplacement() {
            return this.diplacement;
        }

        public void setDiplacement(float f) {
            this.diplacement = f;
        }

        public float getFl() {
            return this.fl;
        }

        public void setFl(float f) {
            this.fl = f;
        }

        public float getFu() {
            return this.fu;
        }

        public void setFu(float f) {
            this.fu = f;
        }

        public float getExtrem1() {
            return this.extrem1;
        }

        public void setExtrem1(float f) {
            this.extrem1 = f;
        }

        public float getExtrem2() {
            return this.extrem2;
        }

        public void setExtrem2(float f) {
            this.extrem2 = f;
        }

        public double getEnd() {
            return this.end;
        }

        public void setEnd(double d) {
            this.end = d;
        }

        public void setTrace(String string) {
            this.trace = string;
        }
    }

    public static class Pick {
        private String siteid;
        private double p;
        private double puncert;
        private double pg;
        private double s;
        private double suncert;
        private double lg;
        private distType dist;
        private double pCorr;
        private double sCorr;

        public Pick() {
        }

        public Pick(String string) {
            this.siteid = string;
        }

        public String getSiteId() {
            return this.siteid;
        }

        public double getP() {
            return this.p;
        }

        public void setP(double d) {
            this.p = d;
        }

        public double getPg() {
            return this.pg;
        }

        public void setPg(double d) {
            this.pg = d;
        }

        public double getS() {
            return this.s;
        }

        public void setS(double d) {
            this.s = d;
        }

        public double getLg() {
            return this.lg;
        }

        public void setLg(double d) {
            this.lg = d;
        }

        public distType getDist() {
            return this.dist;
        }

        public void setDist(distType distType2) {
            this.dist = distType2;
        }

        public double getpCorr() {
            return this.pCorr;
        }

        public void setpCorr(double d) {
            this.pCorr = d;
        }

        public double getsCorr() {
            return this.sCorr;
        }

        public void setsCorr(double d) {
            this.sCorr = d;
        }

        public String getSiteid() {
            return this.siteid;
        }

        public void setSiteid(String string) {
            this.siteid = string;
        }

        public double getPuncert() {
            return this.puncert;
        }

        public void setPuncert(double d) {
            this.puncert = d;
        }

        public double getSuncert() {
            return this.suncert;
        }

        public void setSuncert(double d) {
            this.suncert = d;
        }

        public static enum distType {
            loc;

        }
    }
}

