/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.protocol;

import edu.geophys.hypoline.protocol.ProtEntry;
import edu.geophys.hypoline.protocol.ProtFileManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import layout.TableLayout;

public class UpdateOrNew {
    static final int border = 10;
    private ProtEntry entry;
    private List<Integer> matchingEntryIds;
    private Map<Integer, ProtEntry> matchingEntries;
    private JComboBox existingEvents = null;
    private JLabel warning;
    private JLabel warningMessage;
    private JTextField nameField;
    private JTextField commentField;

    public UpdateOrNew(ProtEntry protEntry, List<Integer> list, Map<Integer, ProtEntry> map) {
        this.matchingEntries = map;
        this.matchingEntryIds = list;
        this.entry = protEntry;
    }

    public JPanel getView() {
        JPanel jPanel = new JPanel((LayoutManager)new TableLayout((double[][])new double[][]{{10.0, -3.0, 10.0, -1.0, 10.0}, {10.0, -3.0, 10.0, -3.0, 10.0, -3.0, 10.0, -3.0, 10.0, -3.0, 10.0}}));
        JLabel jLabel = new JLabel("Existing:");
        jPanel.add((Component)jLabel, "1, 1");
        if (this.matchingEntryIds.size() > 0) {
            this.existingEvents = new JComboBox<Object>(this.matchingEntryIds.toArray());
            this.existingEvents.setRenderer(new ProtListRenderer());
            this.existingEvents.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UpdateOrNew.this.updateFields();
                }
            });
            jPanel.add((Component)this.existingEvents, "3, 1");
        } else {
            jPanel.add((Component)new JLabel("none in current time window"), "3, 1");
        }
        this.warning = new JLabel("");
        jPanel.add((Component)this.warning, "1, 5");
        this.warningMessage = new JLabel("");
        jPanel.add((Component)this.warningMessage, "3, 5");
        jLabel = new JLabel("EventName:");
        jPanel.add((Component)jLabel, "1, 7");
        this.nameField = new JTextField();
        jPanel.add((Component)this.nameField, "3, 7");
        jLabel = new JLabel("Comments:");
        jPanel.add((Component)jLabel, "1, 9");
        this.commentField = new JTextField();
        jPanel.add((Component)this.commentField, "3, 9");
        this.updateFields();
        return jPanel;
    }

    private void updateFields() {
        Object object = "";
        String string = "";
        if (this.getSelectedEntry() != null) {
            string = this.getSelectedEntry().getComment();
        }
        if (((String)object).equals("")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
            object = "EV" + simpleDateFormat.format(this.entry.getDate());
        }
        this.nameField.setText((String)object);
        this.commentField.setText(string);
    }

    public ProtEntry getSelectedEntry() {
        if (this.existingEvents == null) {
            return null;
        }
        return this.matchingEntries.get(this.existingEvents.getSelectedItem());
    }

    public String getName() {
        return this.nameField.getText();
    }

    public String getComment() {
        return this.commentField.getText();
    }

    class ProtListRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        ProtListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ProtEntry protEntry = UpdateOrNew.this.matchingEntries.get(object);
            String string = ProtFileManager.ProtToString(protEntry);
            JLabel jLabel = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            return jLabel;
        }
    }
}

