/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.sitecollection;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.Site;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.hypoline.sitecollection.ZClassMerger;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SiteCollectionModel {
    private static final float ZCLASS_WIDTH_KM = 0.05f;
    private Map<String, Site> siteById = new HashMap<String, Site>();
    private Map<String, SNS> snsById = new HashMap<String, SNS>();
    private Map<String, String> snsIdBySiteId = new HashMap<String, String>();
    private Map<String, Integer> snsIndexById = new HashMap<String, Integer>();
    private Map<String, Integer> siteIndexById = new HashMap<String, Integer>();
    private SNS[] snsByIndex = null;
    private Site[] siteByIndex = null;
    private int[] siteZClassByIndex = null;
    private float[] zClasses = null;
    private float[] siteNorthingsKm;
    private float[] siteEastingsKm;
    private float[] siteElevationsKm;
    private final float highestZClassElevationKm;
    private final float highestSiteElevationKm;
    private final float lowestZClassElevationKm;
    private final float lowestSiteElevationKm;
    private final String highestElevationSnsId;
    private boolean initialized = false;
    private static final String csvfmt = "%7s,%9s,%+9.3f,%+9.3f,%+9.3f,%+9.3f,%3d,%+9.3f";
    private static final String csvheader = String.format("#%6s,%9s,%9s,%9s,%9s,%9s,%3s,%9s", "SNS", "SITE", "east_km", "north_km", "elev_km", "zcl_km", "zcl", "|z_error|");

    public SiteCollectionModel() {
        this.init();
        ZClassMerger zClassMerger = new ZClassMerger(this.siteElevationsKm, 0.05f);
        this.zClasses = zClassMerger.getZClasses();
        this.siteZClassByIndex = zClassMerger.getSiteZClass();
        this.highestZClassElevationKm = this.getArrMax(this.zClasses);
        this.highestSiteElevationKm = this.getArrMax(this.siteElevationsKm);
        String string = "";
        for (int i = 0; i < this.siteElevationsKm.length; ++i) {
            if (this.siteElevationsKm[i] != this.highestSiteElevationKm) continue;
            string = this.snsIdBySiteId.get(this.siteByIndex[i].getId());
            break;
        }
        this.highestElevationSnsId = string;
        this.lowestZClassElevationKm = this.getArrMin(this.zClasses);
        this.lowestSiteElevationKm = this.getArrMin(this.siteElevationsKm);
    }

    public void init() {
        int n;
        this.snsByIndex = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge().getAllActiveSNS();
        for (n = 0; n < this.snsByIndex.length; ++n) {
            SNS sNS = this.snsByIndex[n];
            this.snsById.put(sNS.getID(), sNS);
            this.snsIndexById.put(sNS.getID(), n);
            for (Site object : sNS.getAllSites()) {
                this.siteById.put(object.getId(), object);
                this.snsIdBySiteId.put(object.getId(), sNS.getID());
            }
        }
        n = this.siteById.size();
        this.siteByIndex = new Site[n];
        this.siteNorthingsKm = new float[n];
        this.siteEastingsKm = new float[n];
        this.siteElevationsKm = new float[n];
        int n2 = 0;
        for (Map.Entry entry : this.siteById.entrySet()) {
            Site site;
            this.siteByIndex[n2] = site = (Site)entry.getValue();
            this.siteIndexById.put((String)entry.getKey(), n2);
            this.siteNorthingsKm[n2] = (float)site.getYOffsetKm();
            this.siteEastingsKm[n2] = (float)site.getXOffsetKm();
            this.siteElevationsKm[n2] = (float)site.getZOffsetKm();
            ++n2;
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getSnsIDBySiteId(String string) {
        return this.snsIdBySiteId.get(string);
    }

    public Site getSiteById(String string) {
        return this.siteById.get(string);
    }

    public int getSiteIndexById(String string) {
        return this.siteIndexById.get(string);
    }

    public int[] getSiteZClassByIndex() {
        return this.siteZClassByIndex;
    }

    public float[] getZClasses() {
        return this.zClasses;
    }

    public float[] getSiteNorthingsKm() {
        return this.siteNorthingsKm;
    }

    public float[] getSiteEastingsKm() {
        return this.siteEastingsKm;
    }

    public Site[] getSiteByIndex() {
        return this.siteByIndex;
    }

    public String toStringCSV(boolean bl) {
        int n = this.siteZClassByIndex.length;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < n; ++i) {
            String string = this.siteByIndex[i].getId();
            String string2 = this.snsIdBySiteId.get(string);
            int n2 = this.siteZClassByIndex[i];
            linkedList.add(String.format(csvfmt, string2, string, Float.valueOf(this.siteEastingsKm[i]), Float.valueOf(this.siteNorthingsKm[i]), Float.valueOf(this.siteElevationsKm[i]), Float.valueOf(this.zClasses[n2]), n2, Float.valueOf(Math.abs(this.siteElevationsKm[i] - this.zClasses[n2]))));
        }
        if (bl) {
            Collections.sort(linkedList);
        }
        linkedList.add(0, csvheader);
        return String.join((CharSequence)"\n", linkedList);
    }

    private float getArrMax(float[] fArray) {
        float f = -3.4028235E38f;
        for (float f2 : fArray) {
            f = Math.max(f, f2);
        }
        return f;
    }

    private float getArrMin(float[] fArray) {
        float f = Float.MAX_VALUE;
        for (float f2 : fArray) {
            f = Math.min(f, f2);
        }
        return f;
    }

    public float getHighestZClassElevationKm() {
        return this.highestZClassElevationKm;
    }

    public float getHighestSiteElevationKm() {
        return this.highestSiteElevationKm;
    }

    public float getLowestZClassElevationKm() {
        return this.lowestZClassElevationKm;
    }

    public float getLowestSiteElevationKm() {
        return this.lowestSiteElevationKm;
    }

    public float[] getSiteElevationsKm() {
        return this.siteElevationsKm;
    }

    public String getHighestElevationSnsId() {
        return this.highestElevationSnsId;
    }
}

