/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arraybeamprocessing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayCrossCorrelation {
    private static int maxdelay = 25;

    public static double[] calcCrossCorrPicks(List<float[]> list) {
        int n;
        double[] dArray = new double[list.size()];
        maxdelay = list.get(0).length / 2;
        dArray[0] = 0.0;
        double[][] dArray2 = new double[list.size()][list.size()];
        double[] dArray3 = new double[list.size()];
        for (n = 0; n < dArray.length; ++n) {
            for (int i = 0; i < dArray.length; ++i) {
                Map<Integer, Double> map = ArrayCrossCorrelation.crossCorrelation(list.get(n), list.get(i));
                double d = map.values().toArray(new Double[1])[0];
                dArray2[n][i] = map.keySet().toArray(new Integer[1])[0].intValue();
                int n2 = n;
                dArray3[n2] = dArray3[n2] + d;
            }
        }
        n = 0;
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray3[i] > d)) continue;
            d = dArray3[i];
            n = i;
        }
        dArray = dArray2[n];
        return dArray;
    }

    public static Map<Integer, Double> crossCorrelation(float[] fArray, float[] fArray2) {
        int n;
        int n2 = Math.min(fArray.length, fArray2.length);
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < n2; ++n) {
            d2 += (double)(fArray[n] * fArray[n]);
            d3 += (double)(fArray2[n] * fArray2[n]);
        }
        double d4 = Math.sqrt(d2 * d3);
        double d5 = Double.MIN_VALUE;
        int n4 = 0;
        for (n3 = -maxdelay; n3 < maxdelay; ++n3) {
            double d6 = 0.0;
            for (n = 0; n < n2; ++n) {
                int n5 = n + n3;
                if (n5 < 0 || n5 >= n2) continue;
                d6 += (double)(fArray[n] * fArray2[n5]);
            }
            d = d6 / d4;
            if (!(d > d5)) continue;
            d5 = d;
            n4 = n3;
        }
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        hashMap.put(n4, d5);
        return hashMap;
    }
}

