/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arraybeamprocessing;

import edu.geophys.commons.ui.AbstractPainter;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamCoordinateSystemModel;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamView;
import edu.geophys.hypoline.util.HypoLineFonts;
import java.awt.Graphics2D;
import org.jdesktop.application.Application;

class BeamCoordinateSystemPainter
extends AbstractPainter<BeamCoordinateSystemModel> {
    private int textPadding = 3;

    public BeamCoordinateSystemPainter() {
        Application.getInstance().getContext().getResourceMap(BeamView.class).injectFields((Object)this);
    }

    protected void doPaint(Graphics2D graphics2D, int n, int n2) {
        BeamCoordinateSystemModel beamCoordinateSystemModel = (BeamCoordinateSystemModel)this.getModel();
        if (beamCoordinateSystemModel == null) {
            return;
        }
        double d = (double)n / 2.0;
        double d2 = (double)n2 / 2.0;
        graphics2D.drawLine((int)d, 0, (int)d, n2);
        graphics2D.drawLine(0, (int)d2, n, (int)d2);
        for (BeamCoordinateSystemModel.Circle circle : beamCoordinateSystemModel) {
            double d3 = circle.radiusPercent * ((double)n / 2.0) * beamCoordinateSystemModel.maxValue;
            double d4 = circle.radiusPercent * ((double)n2 / 2.0 * beamCoordinateSystemModel.maxValue);
            graphics2D.drawOval((int)(d - d3), (int)(d2 - d4), (int)(d3 * 2.0), (int)(d4 * 2.0));
            graphics2D.drawString(circle.caption, (int)d + this.textPadding, (int)(d2 - (double)this.textPadding - d4));
        }
        graphics2D.setFont(HypoLineFonts.semiSmallMapFont);
        graphics2D.drawString(MathUtil.format2Digits((double)beamCoordinateSystemModel.maxValue) + "km/s", (int)d + this.textPadding, n2 - this.textPadding);
    }
}

