/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arraybeamprocessing;

import edu.geophys.commons.util.MathUtil;
import java.awt.Point;

public class BeamLocation {
    private double angle;
    private double relativeDistance;
    private double x;
    private double y;

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    public final double getRelativeDistance() {
        return this.relativeDistance;
    }

    public final void setRelativeDistance(double d) {
        this.relativeDistance = d;
    }

    public final int getAbsoluteX(int n) {
        double d = (double)n / 2.0;
        return (int)(d + d * this.x);
    }

    public final int getAbsoluteY(int n) {
        double d = (double)n / 2.0;
        return (int)(d + d * this.y);
    }

    public final Point getAbsolutePoint(int n, int n2) {
        return new Point(this.getAbsoluteX(n), this.getAbsoluteY(n2));
    }

    public final void setRelativePoint(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.update();
    }

    public final double getRelativeX() {
        return this.x;
    }

    public final double getRelativeY() {
        return this.y;
    }

    public final void setAbsolutePoint(double d, double d2, double d3, double d4) {
        double d5 = d3 / 2.0;
        double d6 = d4 / 2.0;
        d = (d - d5) / d5;
        d2 = (d2 - d6) / d6;
        this.x = d;
        this.y = d2;
        this.update();
    }

    private void update() {
        this.relativeDistance = Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
        this.angle = Math.atan2(-this.y, this.x);
        this.angle = Math.toDegrees(this.angle);
        this.angle = MathUtil.convertMathAngleToAzimuth((double)this.angle);
    }

    public final void setAbsolutePoint(Point point, int n, int n2) {
        this.setAbsolutePoint((double)point.x, (double)point.y, (double)n, (double)n2);
    }

    public final void setAbsolutePoint(int n, int n2, int n3, int n4) {
        this.setAbsolutePoint((double)n, (double)n2, (double)n3, (double)n4);
    }
}

