/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arraybeamprocessing;

import edu.geophys.commons.ui.AbstractBasicPainter;
import edu.geophys.hypoline.ui.arraybeamprocessing.BeamLocation;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

class BeamLocationPainter
extends AbstractBasicPainter<BeamLocation> {
    private static final Stroke BEAM_STROKE = new BasicStroke(2.0f);

    BeamLocationPainter() {
    }

    protected void doBasicPaint(Graphics2D graphics2D, int n, int n2, BeamLocation beamLocation) {
        double d = (double)n / 2.0;
        double d2 = (double)n2 / 2.0;
        Point point = beamLocation.getAbsolutePoint(n, n2);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(BEAM_STROKE);
        graphics2D.drawLine((int)d, (int)d2, point.x, point.y);
        graphics2D.fillOval(point.x - 3, point.y - 3, 6, 6);
        graphics2D.setStroke(stroke);
    }
}

