/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.arrayselection;

import edu.geophys.commons.model.SNS;
import edu.geophys.commons.model.knowledgebase.StationsKnowledge;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.util.SwingUtil;
import edu.geophys.hypoline.HypoLineManager;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class ArraySelectionButton
extends JLabel {
    private static final long serialVersionUID = 1L;
    private final boolean isSNS;

    public ArraySelectionButton(SNS sNS) {
        this.setFocusable(false);
        this.setText(sNS.getID());
        this.setHorizontalAlignment(0);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.isSNS = !sNS.getAllSatellites().isEmpty();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        SwingUtil.setRenderingQuality((Graphics2D)graphics2D, (SwingUtil.RenderQuality)SwingUtil.RenderQuality.HIGH);
        SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
        if (this.isSelected()) {
            graphics2D.setColor(suiteTheme.getHypolineRed());
        } else if (this.isSNS) {
            graphics2D.setColor(suiteTheme.getZSatteliteColor());
        } else {
            graphics2D.setColor(suiteTheme.getHCenterColor());
        }
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.setColor(suiteTheme.getPlotBackgroundColor());
        Font font = this.getFont();
        graphics2D.setFont(new Font(font.getFontName(), 1, font.getSize() + 1));
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.getText(), graphics2D);
        graphics2D.drawString(this.getText(), (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() - rectangle2D.getHeight()) / 2.0) + fontMetrics.getAscent());
    }

    public boolean isSelected() {
        String string = "";
        StationsKnowledge stationsKnowledge = SuiteManager.INSTANCE.getKnowledgebase().getStationsKnowledge();
        if (HypoLineManager.INSTANCE.getConfig().getActiveSNS() >= 0) {
            string = stationsKnowledge.getAllActiveSNS()[HypoLineManager.INSTANCE.getConfig().getActiveSNS()].getID();
        }
        return this.getText().equals(string);
    }
}

