/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.singlewindow;

import edu.geophys.commons.themes.SuiteTheme;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.hypoline.HypoLineConfiguration;
import edu.geophys.hypoline.HypoLineManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;

public class ModeSelectionButton
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private final HypoLineConfiguration.HypoLineMode mode;
    private static final List<ModeSelectionButton> buttons = new LinkedList<ModeSelectionButton>();

    public ModeSelectionButton(String string, final HypoLineConfiguration.HypoLineMode hypoLineMode) {
        super(string);
        this.mode = hypoLineMode;
        this.setOpaque(true);
        this.setMaximumSize(this.getPreferredSize());
        buttons.add(this);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HypoLineManager.INSTANCE.getConfig().setHypoLineMode(hypoLineMode);
                HypoLineManager.INSTANCE.getHlApp().getMainFrame().resetSplitPane();
                for (ModeSelectionButton modeSelectionButton : buttons) {
                    if (modeSelectionButton.mode == hypoLineMode) continue;
                    modeSelectionButton.repaint();
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (HypoLineManager.INSTANCE.getConfig().getHypoLineMode() != this.mode) {
            super.paintComponent(graphics);
            return;
        }
        SuiteTheme suiteTheme = ThemeManager.getInstance().getTheme();
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        this.setBackground(suiteTheme.getHypolineRed());
        this.setForeground(color2);
        super.paintComponent(graphics);
        this.setForeground(color);
        this.setBackground(color2);
    }
}

