/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.threecomp;

import edu.geophys.commons.util.JFrameHelper;
import edu.geophys.hypoline.ui.threecomp.HodoPanel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javaxt.io.Image;

class BufferedImage3dView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage bik2k1;
    private BufferedImage bik2k3;
    private BufferedImage bik3k1;

    BufferedImage3dView() {
    }

    public void update(BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3) {
        this.bik2k1 = bufferedImage2;
        this.bik2k3 = bufferedImage;
        this.bik3k1 = bufferedImage3;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.bik2k1 != null && this.bik2k3 != null && this.bik3k1 != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = n / 2;
            int n4 = n2 / 2;
            double d = Math.sqrt(2.0);
            Image image = new Image(this.bik2k3);
            int n5 = image.getWidth();
            int n6 = (int)((double)n5 / d);
            int n7 = n5 - n6;
            int n8 = image.getHeight();
            int n9 = (int)((double)n8 / d);
            image.setCorners((float)n7, 0.0f, (float)n5, 0.0f, (float)n6, (float)n9, 0.0f, (float)n9);
            graphics2D.drawImage(image.getBufferedImage(), n - (int)((double)n3 * d), n4, (int)((double)n3 * d), n4, null);
            graphics2D.drawImage(this.bik2k1, n3, 0, n3, n4, null);
            d = 1.9;
            Image image2 = new Image(this.bik3k1);
            int n10 = image2.getWidth();
            int n11 = (int)((double)n10 / d);
            int n12 = n10 - n11;
            int n13 = image2.getHeight();
            int n14 = (int)((double)n13 / d);
            int n15 = n13 - n14;
            image2.setCorners((float)n12, (float)n15, (float)n10, 0.0f, (float)n10, (float)n14, (float)n12, (float)n13);
            graphics2D.drawImage(image2.getBufferedImage(), n3 - (int)((double)n3 / d), 0, n3, (int)((double)n4 * d), null);
        }
    }

    private void createTrapezium(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f) {
        int n;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f >= 1.0f) {
            f = 1.0f;
        }
        float f2 = (float)n2 * f;
        float f3 = (float)n2 * (1.0f - f);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0;
        }
        for (n = 0; n < n3; ++n) {
            int n4 = n * n2;
            float f4 = (float)n / (float)n3;
            float f5 = f2 * (1.0f - f4);
            float f6 = -f5 + f3 + ((float)n2 - f3) * f4;
            float f7 = f6 / (float)n2;
            for (int i = 0; i < n2; ++i) {
                int n5 = (int)(f5 + (float)i * f7);
                nArray2[n4 + n5] = nArray[n4 + i];
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage3dView bufferedImage3dView = new BufferedImage3dView();
        HodoPanel.HodoPanelPainter hodoPanelPainter = new HodoPanel.HodoPanelPainter(new HodoPanel(), "a", "b");
        hodoPanelPainter.update(new float[10], new float[10], 1.0f);
        hodoPanelPainter.setSize(50, 50);
        BufferedImage bufferedImage = new BufferedImage(hodoPanelPainter.getWidth(), hodoPanelPainter.getHeight(), 2);
        hodoPanelPainter.paint(bufferedImage.getGraphics());
        bufferedImage3dView.update(bufferedImage, bufferedImage, bufferedImage);
        JFrameHelper.showInFrame((JComponent[])new JComponent[]{bufferedImage3dView});
    }
}

