/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.ui.trace.PlotRenderer;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.hypoline.ui.trace.MouseRenderer;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.trace.TraceRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class AbstractRenderer
extends ActivateableComponent {
    private static final long serialVersionUID = 1L;
    protected Color traceColor = null;
    protected MouseRenderer mouseListener;
    protected ActivateableComponent parent;
    protected final SiteModel model;
    protected PlotRenderer plot = new PlotRenderer();
    protected PlotRenderer[] horizontalPlots;
    protected TraceRenderer.TraceType traceType = TraceRenderer.TraceType.TRACE_Z;
    private PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("update")) {
                LogUtil.debug(this.getClass(), (String)("abstract update: " + propertyChangeEvent.getPropertyName()));
                AbstractRenderer.this.update();
            } else if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("repaint")) {
                LogUtil.debug(this.getClass(), (String)"abstract repaint");
                AbstractRenderer.this.repaint();
            } else if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("automaticCalc")) {
                AbstractRenderer.this.automaticCalc();
            } else if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("automaticCalc2")) {
                AbstractRenderer.this.automaticCalc2();
            } else if (propertyChangeEvent.getPropertyName().equalsIgnoreCase("firepick")) {
                AbstractRenderer.this.calcPeak2Peak();
            }
        }
    };

    public AbstractRenderer(SiteModel siteModel, MouseRenderer mouseRenderer, ActivateableComponent activateableComponent) {
        this.model = siteModel;
        this.model.addPropertyChangeListener(this.changeListener);
        this.mouseListener = mouseRenderer;
        this.parent = activateableComponent;
        mouseRenderer.register(this);
        this.setBackground(ThemeManager.getInstance().getTheme().getPlotBackgroundColor());
    }

    public void removeChangeListener() {
        this.model.removePropertyChangeListener(this.changeListener);
    }

    protected abstract void calcPeak2Peak();

    public abstract void update();

    public abstract void automaticCalc();

    public abstract void automaticCalc2();

    public void setActive(boolean bl) {
        if (this.parent != null) {
            this.parent.setActive(bl);
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setColor(Color.GRAY);
        graphics2D.drawLine(this.mouseListener.getMouse(), 0, this.mouseListener.getMouse(), this.getHeight());
    }

    public Color getTraceColor() {
        return this.traceColor;
    }

    public void setTraceColor(Color color) {
        this.traceColor = color;
    }

    public SiteModel getModel() {
        return this.model;
    }

    public PlotRenderer getPlot() {
        return this.plot;
    }

    public void setPlot(PlotRenderer plotRenderer) {
        this.plot = plotRenderer;
    }

    public PlotRenderer[] getHorizontalPlots() {
        return this.horizontalPlots;
    }

    public void setHorizontalPlots(PlotRenderer[] plotRendererArray) {
        this.horizontalPlots = plotRendererArray;
    }
}

