/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.model.AbstractTrace;
import edu.geophys.commons.model.DefaultTrace;
import edu.geophys.commons.range.RangeMarkerModel;
import edu.geophys.commons.suite.SuiteManager;
import edu.geophys.commons.themes.ThemeManager;
import edu.geophys.commons.ui.ActivateableComponent;
import edu.geophys.commons.ui.trace.PlotRenderer;
import edu.geophys.commons.util.DateTimeUtil;
import edu.geophys.commons.util.LogUtil;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.HypoLineManager;
import edu.geophys.hypoline.ensemble.FilterPicker5;
import edu.geophys.hypoline.ui.arraybeamprocessing.ArrayCrossCorrelation;
import edu.geophys.hypoline.ui.trace.MouseRenderer;
import edu.geophys.hypoline.ui.trace.SiteModel;
import edu.geophys.hypoline.ui.trace.StationView;
import edu.geophys.hypoline.ui.trace.TraceRenderer;
import edu.geophys.hypoline.util.HypoLineUtils;
import edu.geophys.sonoview.swing.FilteringTrace;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class ArrayModeTraceRenderer
extends TraceRenderer {
    private static final long serialVersionUID = 1L;
    private PlotRenderer[] plots;
    private PlotRenderer stackedPlot;
    private final List<SiteModel> renderers;
    private final boolean pOrSBeam;
    private double[] pickOffsets;
    private int sampleLength;
    private DefaultTrace stackTrace;
    private double pkBaerPick;
    private float samprate = SuiteManager.INSTANCE.getKnowledgebase().getCampaignKnowledge().getGlobalSamplerate();

    public ArrayModeTraceRenderer(SiteModel siteModel, MouseRenderer mouseRenderer, ActivateableComponent activateableComponent, RangeMarkerModel<Object> rangeMarkerModel, String string, String string2, StationView stationView, List<SiteModel> list, boolean bl) {
        super(siteModel, mouseRenderer, activateableComponent, rangeMarkerModel, string, string2, stationView);
        this.renderers = list;
        this.pOrSBeam = bl;
        this.pickOffsets = new double[list.size()];
        this.plots = new PlotRenderer[list.size()];
        this.removeMouseMotionListener(this.mouseAdapter);
        this.removeMouseListener(this.mouseAdapter);
        this.removeMouseWheelListener(this.mouseAdapter);
    }

    @Override
    public void update() {
        int n;
        int n2;
        double d = 2.147483647E9;
        for (int i = 0; i < this.pickOffsets.length; ++i) {
            this.pickOffsets[i] = this.pOrSBeam ? this.renderers.get(i).getpCorr() : this.renderers.get(i).getsCorr();
            if (Double.isNaN(this.pickOffsets[i]) || !(this.pickOffsets[i] < d)) continue;
            d = this.pickOffsets[i];
        }
        double[] dArray = new double[this.pickOffsets.length];
        for (n2 = 0; n2 < this.pickOffsets.length; ++n2) {
            dArray[n2] = this.pickOffsets[n2];
            this.pickOffsets[n2] = this.pickOffsets[n2] - d;
        }
        for (n2 = 0; n2 < this.pickOffsets.length; ++n2) {
            if (this.pOrSBeam) {
                this.renderers.get(n2).setpCorr(dArray[n2]);
                continue;
            }
            this.renderers.get(n2).setsCorr(dArray[n2]);
        }
        float f = -3.4028235E38f;
        float[] fArray = new float[]{};
        int n3 = 0;
        for (n = 0; n < this.renderers.size(); ++n) {
            if (!Double.isNaN(this.pickOffsets[n])) {
                this.plots[n] = new PlotRenderer();
                DefaultTrace defaultTrace = this.traceProvider.requestTrace(this.model.getStart() + this.pickOffsets[n], this.model.getStart() + this.pickOffsets[n] + this.model.getLength(), this.samprate, new String[]{this.renderers.get(n).getTraceName(this.traceType)})[0];
                defaultTrace.setSamples(MathUtil.subMean((float[])defaultTrace.getSamples()));
                FilteringTrace filteringTrace = new FilteringTrace((AbstractTrace)defaultTrace);
                filteringTrace.directFilter(this.renderers.get(n).getFl(), this.renderers.get(n).getFu());
                defaultTrace.setSamples(filteringTrace.getSamples());
                LogUtil.debug(((Object)((Object)this)).getClass(), (String)("ArrayModeLength: " + this.model.getLength() + " samples: " + defaultTrace.getSamples().length + " " + this.renderers.get(n).getTraceName(this.traceType) + " " + this.model.getStart()));
                this.plots[n].setModel((AbstractTrace)filteringTrace);
                float f2 = this.renderers.get(n).getCurrentMaxValue();
                if (f2 > f) {
                    f = f2;
                }
                this.plots[n].setExternalScale((double)(1.0f / f2));
                if (fArray.length == 0) {
                    fArray = new float[defaultTrace.getSamples().length];
                }
                float[] fArray2 = defaultTrace.getSamples();
                for (int i = 0; i < fArray2.length && i < fArray.length; ++i) {
                    int n4 = i;
                    fArray[n4] = fArray[n4] + fArray2[i];
                }
                ++n3;
                continue;
            }
            this.plots[n] = null;
        }
        n = 0;
        while (n < fArray.length) {
            int n5 = n++;
            fArray[n5] = fArray[n5] / (float)n3;
        }
        this.stackedPlot = new PlotRenderer();
        this.stackTrace = new DefaultTrace();
        this.stackTrace.setSamples(fArray);
        this.stackTrace.setSamplerate(this.samprate);
        this.sampleLength = this.stackTrace.getSamples().length;
        this.stackedPlot.setModel((AbstractTrace)this.stackTrace);
        this.stackedPlot.setExternalScale((double)(1.0f / f));
        this.repaint();
    }

    @Override
    public void automaticCalc2() {
        float[] fArray = this.stackTrace.getSamples();
        if (fArray.length > 1) {
            int n;
            FilterPicker5 filterPicker5 = new FilterPicker5();
            filterPicker5.apply(1.0 / (double)this.samprate, fArray, 0);
            boolean bl = false;
            for (n = 0; n < this.renderers.size(); ++n) {
                if (Double.isNaN(this.renderers.get(n).getsPick())) continue;
                bl = true;
            }
            if (filterPicker5.triggerPickData.size() == 0) {
                double d = -1.0;
                boolean bl2 = true;
                for (SiteModel siteModel : this.renderers) {
                    if (!siteModel.isActiveTrace()) continue;
                    if (siteModel.ispOrSActive() && !Double.isNaN(siteModel.getpCorr())) {
                        d = siteModel.getpCorr();
                        bl2 = true;
                        continue;
                    }
                    if (siteModel.ispOrSActive() || Double.isNaN(siteModel.getsCorr())) continue;
                    d = siteModel.getsCorr();
                    bl2 = false;
                }
                if (d >= 0.0) {
                    for (int i = 0; i < this.renderers.size(); ++i) {
                        if (Double.isNaN(this.pickOffsets[i])) continue;
                        if (bl2 && this.pOrSBeam) {
                            this.renderers.get(i).setpPick(d + this.pickOffsets[i]);
                            continue;
                        }
                        if (bl2 || this.pOrSBeam) continue;
                        this.renderers.get(i).setsPick(d + this.pickOffsets[i]);
                    }
                }
            } else {
                for (n = 0; n < filterPicker5.triggerPickData.size(); ++n) {
                    int n2;
                    double[] dArray = filterPicker5.triggerPickData.get((int)n).indices;
                    if (dArray.length != 2) continue;
                    double d = this.model.getStart() + (dArray[0] + dArray[1]) / 2.0 / (double)this.samprate;
                    double d2 = (dArray[1] - dArray[0]) / 2.0 / (double)this.samprate;
                    if (n == 0) {
                        LogUtil.info(((Object)((Object)this)).getClass(), (String)("Automatic P pick on stack " + dArray[0] + " " + dArray[1] + " " + DateTimeUtil.formatDateTimeISOHighPrecision((double)d)));
                        for (n2 = 0; n2 < this.renderers.size(); ++n2) {
                            if (Double.isNaN(this.pickOffsets[n2])) continue;
                            this.pkBaerPick = d;
                            this.renderers.get(n2).setpPick(d + this.pickOffsets[n2]);
                            if (this.renderers.get(n2).getsPick() <= this.renderers.get(n2).getpPick()) {
                                this.renderers.get(n2).setsPick(Double.NaN);
                            }
                            this.renderers.get(n2).setPUncertainty(d2);
                        }
                        continue;
                    }
                    if (n != 1 || bl) continue;
                    LogUtil.info(((Object)((Object)this)).getClass(), (String)("Automatic S pick on stack " + dArray[0] + " " + dArray[1] + " " + DateTimeUtil.formatDateTimeISOHighPrecision((double)d)));
                    for (n2 = 0; n2 < this.renderers.size(); ++n2) {
                        if (Double.isNaN(this.pickOffsets[n2])) continue;
                        this.renderers.get(n2).setsPick(d + this.pickOffsets[n2]);
                        this.renderers.get(n2).setSUncertainty(d2);
                    }
                }
            }
            HypoLineManager.INSTANCE.getEpiMapDb().updateDepth();
        }
    }

    @Override
    public void automaticCalc() {
        boolean bl = true;
        for (Object object : this.renderers) {
            if (!object.isActiveTrace()) continue;
            if (object.ispOrSActive() && !Double.isNaN(object.getpCorr())) {
                bl = true;
                continue;
            }
            if (object.ispOrSActive() || Double.isNaN(object.getsCorr())) continue;
            bl = false;
        }
        if (this.pOrSBeam && bl || !this.pOrSBeam && !bl) {
            ArrayList arrayList = new ArrayList();
            for (SiteModel siteModel : this.renderers) {
                arrayList.add(siteModel.getCurrentZoomZTrace().getSamples());
            }
            this.pickOffsets = ArrayCrossCorrelation.calcCrossCorrPicks(arrayList);
            double d = this.model.getStart() + this.model.getLength() / 2.0;
            for (SiteModel siteModel : this.renderers) {
                if (!siteModel.isActiveTrace()) continue;
                if (siteModel.ispOrSActive() && !Double.isNaN(siteModel.getpCorr())) {
                    d = siteModel.getpCorr();
                    continue;
                }
                if (siteModel.ispOrSActive() || Double.isNaN(siteModel.getsCorr())) continue;
                d = siteModel.getsCorr();
            }
            for (int i = 0; i < this.pickOffsets.length; ++i) {
                if (this.pOrSBeam && bl) {
                    this.renderers.get(i).setpCorr(this.pickOffsets[i] / (double)this.samprate + d);
                    continue;
                }
                if (this.pOrSBeam || bl) continue;
                this.renderers.get(i).setsCorr(this.pickOffsets[i] / (double)this.samprate + d);
            }
            for (SiteModel siteModel : HypoLineManager.INSTANCE.getCurrentSitesDetail()) {
                siteModel.updateRepaint();
            }
            HypoLineManager.INSTANCE.getpBeamView().update();
            HypoLineManager.INSTANCE.getsBeamView().update();
            this.update();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics, true);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.model.getShowStacked() != 2) {
            int n = 0;
            for (PlotRenderer plotRenderer : this.plots) {
                if (plotRenderer != null) {
                    Color object2 = n == 3 ? ThemeManager.getInstance().getTheme().getZCenterColor() : ThemeManager.getInstance().getTheme().getPaletteColor(n);
                    plotRenderer.setForegroundColor(object2);
                    plotRenderer.setExternalScale((double)(1.0f / this.renderers.get(n).getCurrentMaxValue()));
                    plotRenderer.draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(this._minX, this._minY, this._maxX, this._maxY));
                }
                ++n;
            }
        }
        if (this.model.getShowStacked() != 0) {
            this.stackedPlot.setForegroundColor(Color.BLACK);
            this.stackedPlot.draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(this._minX, this._minY, this._maxX, this._maxY));
        }
        double d = (double)this._maxX / (double)(this.sampleLength - 1) / 2.0;
        int n = (int)(MathUtil.convertFromTo((double)HypoLineUtils.convertTimeToPick(this.pkBaerPick, this.model.getStart(), this.samprate), (double)0.0, (double)(this.sampleLength - 1), (double)this._minX, (double)(this._maxX + this._minX)) - d);
        graphics2D.setColor(ThemeManager.getInstance().getTheme().getHypolineBlue());
        graphics2D.drawLine(n, 0, n, this.getHeight());
        SiteModel object = null;
        for (SiteModel siteModel : this.renderers) {
            if (!siteModel.isActiveTrace()) continue;
            object = siteModel;
            break;
        }
        graphics2D.dispose();
    }
}

