/*
 * Decompiled with CFR 0.152.
 */
package edu.geophys.hypoline.ui.trace;

import edu.geophys.commons.ui.BoundedLongRangeModel;
import edu.geophys.commons.util.MathUtil;
import edu.geophys.hypoline.ui.trace.AbstractRenderer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;

public class MouseRenderer {
    private int mouse;
    private List<AbstractRenderer> clients = new ArrayList<AbstractRenderer>();
    private BoundedLongRangeModel model;
    MouseMotionListener mouseListener = new MouseMotionListener(){

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MouseRenderer.this.mouse = mouseEvent.getX();
            int n = ((AbstractRenderer)((Object)mouseEvent.getSource())).getWidth();
            if (n > 0) {
                long l = (long)MathUtil.convertFromTo((double)MouseRenderer.this.mouse, (double)0.0, (double)(n - 1), (double)MouseRenderer.this.model.getMinimum(), (double)MouseRenderer.this.model.getMaximum());
                MouseRenderer.this.model.setValue(l);
                for (AbstractRenderer abstractRenderer : MouseRenderer.this.clients) {
                    abstractRenderer.repaint();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }
    };

    public MouseRenderer(BoundedLongRangeModel boundedLongRangeModel) {
        this.model = boundedLongRangeModel;
    }

    public void register(AbstractRenderer abstractRenderer) {
        this.clients.add(abstractRenderer);
        abstractRenderer.addMouseMotionListener(this.mouseListener);
    }

    public void unregister(AbstractRenderer abstractRenderer) {
        this.clients.remove((Object)abstractRenderer);
    }

    public int getMouse() {
        return this.mouse;
    }

    public void setMouse(int n) {
        this.mouse = n;
    }
}

